<?php
/**
 * @version    1.0
 * @package    Udetor
 * @author     Your Team <support@yourdomain.com>
 * @copyright  Copyright (C) 2014 yourdomain.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 */

/**
 * Plug additional sidebars into Admin.
 *
 * @package  Udetor
 * @since    1.0
 */
class Udetor_Start_Visual_Composer {
    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;

    public static $fonts = array();
    public static $weights = array();
    public static $order_by_values = array();
    public static $order_way_values = array();

    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize() {
        // Do nothing if start functions already initialized.
        if ( self::$initialized ) {
            return;
        }

        // Visual Composer
        add_action( 'vc_after_init', array( __CLASS__, 'vc_after_init_actions' ));
        add_action( 'vc_before_init', array( __CLASS__, 'map_shortcode'   ) );
        add_action( 'vc_after_init' , array( __CLASS__, 'update_elements' ) );

        // Filter to Replace default css class for vc_row shortcode and vc_column
        add_filter('vc_shortcodes_css_class', array( __CLASS__, 'udetor_custom_css_classes_for_vc_row_and_vc_column'), 10, 2 ); 

        // State that initialization completed.
        self::$initialized = true;
    }

    /** 
    * Custom class css row
    */
    public static function udetor_custom_css_classes_for_vc_row_and_vc_column($class_string = null, $tag = null) { 

        if($tag=='vc_row' || $tag=='vc_row_inner') {
           $class_string = str_replace('vc_row-fluid', '', $class_string);
        }
        if($tag=='vc_column' || $tag=='vc_column_inner') {
            $class_string = preg_replace('/vc_col-xs-(\d{1,2})/', 'col-xs-$1', $class_string);
            $class_string = preg_replace('/vc_col-sm-(\d{1,2})/', 'col-md-$1', $class_string);
            $class_string = preg_replace('/vc_col-md-(\d{1,2})/', 'col-sm-$1', $class_string);
            $class_string = preg_replace('/vc_col-lg-(\d{1,2})/', 'col-lg-$1', $class_string);
        }
        return $class_string;
    }


    /**
     * Register page type for visual composer
     * After VC Init
     */
    public static function vc_after_init_actions() {

        // Enable VC by default on a list of Post Types
        if( function_exists('vc_set_default_editor_post_types') ){
            $list = array(
                'page',
                'page_header', // add here your custom post types slug
            );
            vc_set_default_editor_post_types( $list );
        }

        // Disable AdminBar VC edit link
        if( function_exists('vc_frontend_editor') ){
            remove_action( 'admin_bar_menu', array( vc_frontend_editor(), 'adminBarEditLink' ), 1000 );
        }

    }


    /**
     * Customize Visual Composer elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524329
     */
    public static function update_elements() {

        // Global object containing current admin page
        global $pagenow;


        // Update params to default elements
        self::update_default_params();


        // If current page is post.php and post isset than query for its post type
        // if the post type is 'page_header' do something
        // Do something
        if (('post.php' === $pagenow && isset($_GET['post']) && 'page' === get_post_type( $_GET['post'] )) ||
            ('post.php' === $pagenow && isset($_GET['post']) && 'post' === get_post_type( $_GET['post'] )) ||
            ('post-new.php' === $pagenow && isset($_GET['post_type']) && 'page' === $_GET['post_type'] )) {

            // No Frontend
            vc_disable_frontend();

            // Remove Header Elements
            self::remove_elements_header();


        }

        // Register actions to do something.
        if (( 'post-new.php' === $pagenow && isset($_GET['post_type']) && 'page_header' === $_GET['post_type'] ) ||
            ( 'post.php' === $pagenow && isset($_GET['post']) && 'page_header' === get_post_type( $_GET['post'] )) ) {
            
            // No Frontend
            vc_disable_frontend();

            // move row into header
            $settings = array (
                'category' => esc_html__( 'Header Elements', 'udetor' )
            );
            vc_map_update( 'vc_row', $settings ); // Note: 'vc_row' was used as a base for "Header" element
            vc_map_update( 'vc_column', $settings ); // Note: 'vc_row' was used as a base for "Header" element
            vc_map_update( 'vc_section', $settings ); // Note: 'vc_section' was used as a base for "Header" element
        }
        
        /*add param fullwidth*/
        vc_add_param('vc_row',array(
                              "type" => "dropdown",
                              "heading" => esc_html__('Fullwidth', 'udetor'),
                              "param_name" => "fullwidth",
                              "value" => array(   
                                                esc_html__('No', 'udetor') => 'no',  
                                                esc_html__('Yes', 'udetor') => 'yes',                                                                                
                                              ),
                              "description" => esc_html__("Select Fullwidth or not, Default: No fullwidth", "udetor"),      
                            ) 
        );        

    }

    /**
     * Update Elements params for Defaults
    */

    public static function update_default_params(){

        // Update parameters for Row.
        vc_add_params(
            'vc_row',
            array(
                array(
                    'param_name'       => 'background_position',
                    'heading'          => esc_html__( 'Background Position', 'udetor' ),
                    'group'            => esc_html__( 'Design Options', 'udetor' ),
                    'type'             => 'dropdown',
                    'edit_field_class' => 'vc_col-xs-6 mgt60m',
                    'value'      => array(
                        esc_html__( 'Left Top', 'udetor' )      => 'left_top',
                        esc_html__( 'Left Center', 'udetor' )   => 'left center',
                        esc_html__( 'Left Bottom', 'udetor' )   => 'left bottom',
                        esc_html__( 'Right Top', 'udetor' )     => 'right top',
                        esc_html__( 'Right Center', 'udetor' )  => 'right center',
                        esc_html__( 'Right Bottom', 'udetor' )  => 'right bottom',
                        esc_html__( 'Center Top', 'udetor' )    => 'center top',
                        esc_html__( 'Center Center', 'udetor' ) => 'center center',
                        esc_html__( 'Center Bottom', 'udetor' ) => 'center bottom',
                    ),
                )
            )
        );
        vc_add_params(
            'vc_row_inner',
            array(
                array(
                    'param_name'       => 'background_position',
                    'heading'          => esc_html__( 'Background Position', 'udetor' ),
                    'group'            => esc_html__( 'Design Options', 'udetor' ),
                    'type'             => 'dropdown',
                    'edit_field_class' => 'vc_col-xs-6 mgt60m',
                    'value'      => array(
                        esc_html__( 'Left Top', 'udetor' )      => 'left_top',
                        esc_html__( 'Left Center', 'udetor' )   => 'left center',
                        esc_html__( 'Left Bottom', 'udetor' )   => 'left bottom',
                        esc_html__( 'Right Top', 'udetor' )     => 'right top',
                        esc_html__( 'Right Center', 'udetor' )  => 'right center',
                        esc_html__( 'Right Bottom', 'udetor' )  => 'right bottom',
                        esc_html__( 'Center Top', 'udetor' )    => 'center top',
                        esc_html__( 'Center Center', 'udetor' ) => 'center center',
                        esc_html__( 'Center Bottom', 'udetor' ) => 'center bottom',
                    ),
                ),
            )
        );

        // Update parameters for Column.
        vc_add_params(
            'vc_column',
            array(
                array(
                    'param_name'       => 'background_position',
                    'heading'          => esc_html__( 'Background Position', 'udetor' ),
                    'group'            => esc_html__( 'Design Options', 'udetor' ),
                    'type'             => 'dropdown',
                    'edit_field_class' => 'vc_col-xs-6 mgt60m',
                    'value'      => array(
                        esc_html__( 'Left Top', 'udetor' )      => 'left_top',
                        esc_html__( 'Left Center', 'udetor' )   => 'left center',
                        esc_html__( 'Left Bottom', 'udetor' )   => 'left bottom',
                        esc_html__( 'Right Top', 'udetor' )     => 'right top',
                        esc_html__( 'Right Center', 'udetor' )  => 'right center',
                        esc_html__( 'Right Bottom', 'udetor' )  => 'right bottom',
                        esc_html__( 'Center Top', 'udetor' )    => 'center top',
                        esc_html__( 'Center Center', 'udetor' ) => 'center center',
                        esc_html__( 'Center Bottom', 'udetor' ) => 'center bottom',
                    ),
                ),
            )
        );
        vc_add_params(
            'vc_column_inner',
            array(
                array(
                    'param_name'       => 'background_position',
                    'heading'          => esc_html__( 'Background Position', 'udetor' ),
                    'group'            => esc_html__( 'Design Options', 'udetor' ),
                    'type'             => 'dropdown',
                    'edit_field_class' => 'vc_col-xs-6 mgt60m',
                    'value'      => array(
                        esc_html__( 'Left Top', 'udetor' )      => 'left_top',
                        esc_html__( 'Left Center', 'udetor' )   => 'left center',
                        esc_html__( 'Left Bottom', 'udetor' )   => 'left bottom',
                        esc_html__( 'Right Top', 'udetor' )     => 'right top',
                        esc_html__( 'Right Center', 'udetor' )  => 'right center',
                        esc_html__( 'Right Bottom', 'udetor' )  => 'right bottom',
                        esc_html__( 'Center Top', 'udetor' )    => 'center top',
                        esc_html__( 'Center Center', 'udetor' ) => 'center center',
                        esc_html__( 'Center Bottom', 'udetor' ) => 'center bottom',
                    ),
                ),
            )
        );

        // Update parameters for Tabs element.
        vc_add_params(
            'vc_tta_tabs',
            array(
                array(
                    'param_name' => 'style',
                    'heading'    => esc_html__( 'Select style', 'udetor' ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        esc_html__( 'Style 1', 'udetor' ) => 'style-1',
                        esc_html__( 'Style 2', 'udetor' ) => 'style-2',
                        esc_html__( 'Style 3', 'udetor' ) => 'style-3',
                        esc_html__( 'Style 4', 'udetor' ) => 'style-4',
                        esc_html__( 'Style 5', 'udetor' ) => 'style-5',
                        esc_html__( 'Style 6', 'udetor' ) => 'style-6',
                        esc_html__( 'Style 7', 'udetor' ) => 'style-7',
                    ),
                ),
            )
        );

        // Update parameters for Toggle element.
        vc_add_params(
            'vc_toggle',
            array(
                array(
                    'param_name' => 'style',
                    'heading'    => esc_html__( 'Select style', 'udetor' ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        esc_html__( 'Style 1', 'udetor' ) => 'style-1',
                        esc_html__( 'Style 2', 'udetor' ) => 'style-2',
                        esc_html__( 'Style 3', 'udetor' ) => 'style-3',
                        esc_html__( 'Style 4', 'udetor' ) => 'style-4',
                    ),
                ),
            )
        );

        // Update parameters for Accordion element.
        vc_add_params(
            'vc_accordion',
            array(
                array(
                    'param_name' => 'style',
                    'heading'    => esc_html__( 'Select style', 'udetor' ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        esc_html__( 'Style 1', 'udetor' ) => 'style-1',
                        esc_html__( 'Style 2', 'udetor' ) => 'style-2',
                        esc_html__( 'Style 3', 'udetor' ) => 'style-3',
                        esc_html__( 'Style 4', 'udetor' ) => 'style-4',
                    ),
                ),
            )
        );

        // Update parameters for Progress Bar element.
        vc_add_params(
            'vc_progress_bar',
            array(
                array(
                    'param_name' => 'style',
                    'heading'    => esc_html__( 'Select style', 'udetor' ),
                    'type'       => 'dropdown',
                    'value'      => array(
                        esc_html__( 'Default', 'udetor' ) => '',
                        esc_html__( 'Style 1', 'udetor' ) => 'style-1',
                    ),
                ),
            )
        );

    }

    /**
     * Remove Elements in Header Type     *
    */

    public static function remove_elements_header(){

        // Remove elements.
        vc_remove_element( 'netbase_hlogo');
        vc_remove_element( 'netbase_hmenu');
        vc_remove_element( 'netbase_hsearch');
        vc_remove_element( 'netbase_hsidebar');
        vc_remove_element( 'netbase_hsocials');
        vc_remove_element( 'netbase_htext');

    }

    /**
     * Remove Elements in Custom Expand *
     */

    public static function remove_netbase_elements(){

        // Remove elements.
        vc_remove_element( 'netbase_button');
        vc_remove_element( 'netbase_carousel_categories');
        vc_remove_element( 'netbase_carousel_posts');
        vc_remove_element( 'netbase_countdown');
        vc_remove_element( 'netbase_counters_box');
        vc_remove_element( 'netbase_courses');
        vc_remove_element( 'netbase_gallery_images');
        vc_remove_element( 'netbase_gallery_posts');
        vc_remove_element( 'netbase_google_map');
        vc_remove_element( 'netbase_heading');
        vc_remove_element( 'netbase_course_categories');
        vc_remove_element( 'netbase_course_collection');
        vc_remove_element( 'netbase_course_searching');
        vc_remove_element( 'netbase_our_team');
        vc_remove_element( 'netbase_icon_box');
        vc_remove_element( 'netbase_link');
        vc_remove_element( 'netbase_list_events');
        vc_remove_element( 'netbase_list_post');
        vc_remove_element( 'netbase_login_form');
        vc_remove_element( 'netbase_multiple_images');
        vc_remove_element( 'netbase_one_course_instructors');
        vc_remove_element( 'netbase_portfolio');
        vc_remove_element( 'netbase_single_image');
        vc_remove_element( 'netbase_social');
        vc_remove_element( 'netbase_tab_event');
        vc_remove_element( 'netbase_testimonials');
        vc_remove_element( 'netbase_timetable');
        vc_remove_element( 'netbase_twitter');
        vc_remove_element( 'netbase_video');
        vc_remove_element( 'netbase_team');
        vc_remove_element( 'netbase_banner');
        vc_remove_element( 'netbase_dropcap');
        vc_remove_element( 'netbase_list');
        vc_remove_element( 'netbase_spotlight');
        vc_remove_element( 'netbase_subscription');
        vc_remove_element( 'netbase_timeline');
        vc_remove_element( 'netbase_separator');
        vc_remove_element( 'netbase_faq');
        vc_remove_element( 'netbase_gallery');
        vc_remove_element( 'netbase_testimonial');
        vc_remove_element( 'netbase_pricing_table');
        vc_remove_element( 'netbase_popular_courses');
        vc_remove_element( 'netbase_course_category_carousel');
        vc_remove_element( 'netbase_services');
        vc_remove_element( 'netbase_posts_gallery');
        vc_remove_element( 'rev_slider');
        // other
        vc_remove_element( 'rev_slider_vc');

    }

    /**
     * Remove Elements Default of Visual Composer     *
     */

    public static function remove_default_elements(){

        // Remove elements.
        vc_remove_element( 'contact-form-7');
        vc_remove_element( 'vc_separator');
        vc_remove_element( 'vc_message');
        vc_remove_element( 'vc_facebook');
        vc_remove_element( 'vc_googleplus');
        vc_remove_element( 'vc_tweetmeme');
        vc_remove_element( 'vc_pinterest');
        vc_remove_element( 'vc_toggle');
        vc_remove_element( 'vc_gallery');
        vc_remove_element( 'vc_images_carousel');
        vc_remove_element( 'vc_tta_tabs');
        vc_remove_element( 'vc_tta_section');
        vc_remove_element( 'vc_tta_tour');
        vc_remove_element( 'vc_tta_accordion');
        vc_remove_element( 'vc_tta_pageable');
        vc_remove_element( 'vc_custom_heading');
        vc_remove_element( 'vc_cta');
        vc_remove_element( 'vc_btn');
        vc_remove_element( 'vc_icon');
        vc_remove_element( 'vc_text_separator');
        vc_remove_element( 'vc_posts_slider');
        vc_remove_element( 'vc_video');
        vc_remove_element( 'vc_gmaps');
        vc_remove_element( 'vc_raw_html');
        vc_remove_element( 'vc_raw_js');
        vc_remove_element( 'vc_progress_bar');
        vc_remove_element( 'vc_line_chart');
        vc_remove_element( 'vc_round_chart');
        vc_remove_element( 'vc_pie');
        vc_remove_element( 'vc_flickr');
        vc_remove_element( 'vc_masonry_grid');
        vc_remove_element( 'vc_masonry_media_grid');
        vc_remove_element( 'vc_media_grid');
        vc_remove_element( 'vc_basic_grid');
        vc_remove_element( 'vc_acf');
        vc_remove_element( 'vc_single_image');
        vc_remove_element( 'vc_widget_sidebar');
        vc_remove_element( 'vc_column_text');
        vc_remove_element( 'vc_wp_calendar');
        vc_remove_element( 'vc_wp_tagcloud');
        vc_remove_element( 'vc_wp_archives');
        vc_remove_element( 'vc_wp_recentcomments');
        vc_remove_element( 'vc_wp_posts');
        vc_remove_element( 'vc_wp_pages');
        vc_remove_element( 'vc_wp_rss');
        vc_remove_element( 'vc_wp_meta');
        vc_remove_element( 'vc_wp_search');
        vc_remove_element( 'vc_wp_custommenu');
        vc_remove_element( 'vc_wp_categories');
        vc_remove_element( 'vc_wp_text');
        vc_remove_element( 'vc_wp_sidebar');
        vc_remove_element( 'vc_hoverbox');
        vc_remove_element( 'vc_zigzag');

        // old
        vc_remove_element( 'vc_tabs');
        vc_remove_element( 'vc_tab');
        vc_remove_element( 'vc_accordion');
        vc_remove_element( 'vc_accordion_tab');
        vc_remove_element( 'vc_button');
        vc_remove_element( 'vc_button2');
        vc_remove_element( 'vc_cta_button');
        vc_remove_element( 'vc_cta_button2');
        vc_remove_element( 'vc_tour');

    }

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public static function map_shortcode() {
        /**
         * Force Visual Composer to initialize as "built into the theme",
         * this will hide certain tabs under the Settings -> Visual Composer page.
         */
        vc_set_as_theme();

        /**
         * To enable Visual Composer page builder for theme defined post types by default.
         */
        vc_set_default_editor_post_types( array( 'page', 'page_headers' ) );

        // Get the list of Google fonts.
        $fonts_origin = Udetor_Helper::google_fonts();

        self::$fonts[ __( 'Use theme default font family', 'udetor' ) ] = '';

        // Set key equal value for Google fonts.
        foreach( $fonts_origin as $key => $val ) {
            self::$fonts[ $key ] = $key;
        }

        // Define font weights.
        self::$weights = array(
            '1'  => '100',
            '2'  => '100i',
            '3'  => '200',
            '4'  => '200i',
            '5'  => '300',
            '6'  => '300i',
            '7'  => '400',
            '8'  => '400i',
            '9'  => '500',
            '10' => '500i',
            '11' => '600',
            '12' => '600i',
            '13' => '700',
            '14' => '700i',
            '15' => '800',
            '16' => '800i',
            '17' => '900',
            '18' => '900i',
        );

        self::$order_by_values = array(
            '',
            esc_html__( 'Date', 'udetor' )          => 'date',
            esc_html__( 'ID', 'udetor' )            => 'ID',
            esc_html__( 'Author', 'udetor' )        => 'author',
            esc_html__( 'Title', 'udetor' )         => 'title',
            esc_html__( 'Modified', 'udetor' )      => 'modified',
            esc_html__( 'Random', 'udetor' )        => 'rand',
            esc_html__( 'Comment count', 'udetor' ) => 'comment_count',
            esc_html__( 'Menu order', 'udetor' )    => 'menu_order',
        );
        self::$order_way_values = array(
            '',
            esc_html__( 'Descending', 'udetor' ) => 'DESC',
            esc_html__( 'Ascending', 'udetor' )  => 'ASC',
        );

    }
}