<?php
/**
 * Created by PhpStorm.
 * User: duongnth
 * Date: 7/6/2017
 * Time: 2:28 PM
 */

// Map new video element
vc_map(
    array(
        'name'     => esc_html__( 'Video', 'udetor' ),
        'base'     => 'udetor_video',
        ////'icon'   => 'fa fa-video-camera',
        'category' => esc_html__( 'Udetor Elements', 'udetor' ),
        'params'   => array(
            array(
                'param_name'  => 'source',
                'heading'     => esc_html__( 'Video Source', 'udetor' ),
                'type'        => 'dropdown',
                'admin_label' => true,
                'value'       => array(
                    esc_html__( 'Youtube', 'udetor' ) => 'youtube',
                    esc_html__( 'Vimeo', 'udetor' )   => 'vimeo',
                ),
            ),
            array(
                'param_name' => 'url',
                'heading'    => esc_html__( 'Link To Video', 'udetor' ),
                'type'       => 'textfield',
            ),
            array(
                'param_name' => 'style',
                'heading'    => esc_html__( 'Style', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Video Screen Preview', 'udetor' ) => 'screen',
                    esc_html__( 'Player Icon', 'udetor' )          => 'icon',
                    esc_html__( 'Image Thumbnail', 'udetor' )      => 'image',
                ),
            ),
            array(
                'param_name' => 'icon_color',
                'heading'    => esc_html__( 'Icon Color', 'udetor' ),
                'type'       => 'colorpicker',
                'value'      => '#2d2d2d2',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => array( 'image', 'icon' ),
                ),
            ),
            array(
                'param_name'  => 'width',
                'heading'     => esc_html__( 'Video Width (number only)', 'udetor' ),
                'description' => esc_html__( 'This parameter is not work on video popup', 'udetor' ),
                'type'        => 'textfield',
                'value'       => 500,
            ),
            array(
                'param_name' => 'graphic',
                'heading'    => esc_html__( 'Upload image', 'udetor' ),
                'type'       => 'attach_image',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'image',
                ),
            ),
            array(
                'param_name' => 'align',
                'heading'    => esc_html__( 'Video Align', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Left', 'udetor' )   => 'tl',
                    esc_html__( 'Center', 'udetor' ) => 'tc',
                    esc_html__( 'Right', 'udetor' )  => 'tr',
                ),
            ),
            array(
                'param_name' => 'shadow',
                'heading'    => esc_html__( 'Shadow', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'None', 'udetor' )    => '',
                    esc_html__( 'Style 1', 'udetor' ) => '1',
                    esc_html__( 'Style 2', 'udetor' ) => '2',
                    esc_html__( 'Style 3', 'udetor' ) => '3',
                    esc_html__( 'Style 4', 'udetor' ) => '4',
                    esc_html__( 'Style 5', 'udetor' ) => '5',
                    esc_html__( 'Style 6', 'udetor' ) => '6',
                    esc_html__( 'Style 7', 'udetor' ) => '7',
                    esc_html__( 'Style 8', 'udetor' ) => '8',
                    esc_html__( 'Style 9', 'udetor' ) => '9',
                ),
                'dependency' => array(
                    'element' => 'style',
                    'value'   => array( 'image' )
                ),
            ),
            array(
                'param_name' => 'popup',
                'heading'    => esc_html__( 'Play in popup?', 'udetor' ),
                'type'       => 'checkbox',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'image',
                ),
            ),
            array(
                'param_name' => 'control',
                'heading'    => esc_html__( 'Enable Control', 'udetor' ),
                'type'       => 'checkbox',
                'dependency' => array(
                    'element' => 'source',
                    'value'   => 'youtube',
                ),
            ),
            array(
                'param_name' => 'autoplay',
                'heading'    => esc_html__( 'Enable Auto Play', 'udetor' ),
                'type'       => 'checkbox',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => array( 'screen' ),
                ),
            ),
            array(
                'param_name'  => 'extra_class',
                'heading'     => esc_html__( 'Extra Class Name', 'udetor' ),
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'udetor' ),
                'type'        => 'textfield',
            ),
            array(
                'param_name'       => 'video_custom_id',
                'heading'          => esc_html__( 'Hidden ID', 'udetor' ),
                'type'             => 'textfield',
                'value'            => 1122334455,
                'edit_field_class' => 'hidden',
            ),
        )
    )
);