<?php
/**
 * Created by PhpStorm.
 * User: duongnth
 * Date: 7/6/2017
 * Time: 2:28 PM
 */

// Map new social network element
vc_map(
    array(
        'name'     => esc_html__( 'Social Network', 'udetor' ),
        'base'     => 'udetor_social_network',
        ////'icon'   => 'fa fa-dribbble',
        'category' => esc_html__( 'Udetor Elements', 'udetor' ),
        'params'   => array(
            array(
                'param_name'  => 'network',
                'heading'     => esc_html__( 'Network', 'udetor' ),
                'type'        => 'dropdown',
                'admin_label' => true,
                'value'       => array(
                    esc_html__( 'Dribbble', 'udetor' )  => 'dribbble',
                    esc_html__( 'Flickr', 'udetor' )    => 'flickr',
                    esc_html__( 'Instagram', 'udetor' ) => 'instagram',
                ),
            ),
            array(
                'param_name'  => 'user_id',
                'heading'     => esc_html__( 'User ID', 'udetor' ),
                'description' => sprintf( esc_html__( 'Lookup User ID for <a target="_blank" rel="noopener noreferrer" href="%s">Instagram</a> - <a target="_blank" rel="noopener noreferrer" href="%s">Flickr</a>', 'udetor' ), 'https://smashballoon.com/instagram-feed/find-instagram-user-id/', 'http://idgettr.com/' ),
                'type'        => 'textfield',
                'admin_label' => true,
            ),
            array(
                'param_name'  => 'access_token',
                'heading'     => esc_html__( 'Instagram Access Token', 'udetor' ),
                'description' => sprintf( esc_html__( 'Generate Access Token <a target="_blank" rel="noopener noreferrer" href="%s">Instagram</a>', 'udetor' ), 'http://instagram.pixelunion.net/'),
                'type'        => 'textfield',
                'dependency' => array(
                    'element' => 'network',
                    'value'   => 'instagram',
                ),
            ),
            array(
                'param_name' => 'layout',
                'heading'    => esc_html__( 'Layout', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Grid', 'udetor' )    => 'grid',
                    esc_html__( 'Masonry', 'udetor' ) => 'masonry',
                ),
                'dependency' => array(
                    'element' => 'slider',
                    'value'   => '0',
                ),
            ),
            array(
                'param_name'  => 'item_large',
                'heading'     => esc_html__( 'Item Large', 'udetor' ),
                'description' => esc_html__( 'Number of item you want to set larger (Note: separate values by commas ",")', 'udetor' ),
                'type'        => 'textfield',
                'dependency' => array(
                    'element' => 'layout',
                    'value'   => 'masonry',
                ),
            ),
            array(
                'param_name' => 'columns',
                'heading'    => esc_html__( 'Columns', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( '2 Columns', 'udetor' ) => '2',
                    esc_html__( '3 Columns', 'udetor' ) => '3',
                    esc_html__( '4 Columns', 'udetor' ) => '4',
                    esc_html__( '5 Columns', 'udetor' ) => '5',
                    esc_html__( '6 Columns', 'udetor' ) => '6',
                    esc_html__( '7 Columns', 'udetor' ) => '7',
                    esc_html__( '8 Columns', 'udetor' ) => '8',
                ),
                'std' => 4,
                'dependency' => array(
                    'element' => 'slider',
                    'value'   => '0',
                ),
            ),
            array(
                'param_name'  => 'limit',
                'heading'     => esc_html__( 'Per Page', 'udetor' ),
                'description' => esc_html__( 'How much items per page to show', 'udetor' ),
                'type'        => 'textfield',
                'value'       => 10
            ),
            array(
                'param_name' => 'gutter',
                'heading'    => esc_html__( 'Gutter Width', 'udetor' ),
                'type'       => 'textfield',
            ),
            array(
                'param_name' => 'slider',
                'heading'    => esc_html__( 'Enable Carousel', 'udetor' ),
                'type'       => 'dropdown',
                'value' => array(
                    esc_html__( 'Yes', 'udetor' )    => 1,
                    esc_html__( 'No', 'udetor' ) => 0,
                ),
            ),
            array(
                'param_name'  => 'item',
                'heading'     => esc_html__( 'Item', 'udetor' ),
                'description' => esc_html__( 'The number of items you want to see on the screen.', 'udetor' ),
                'type'        => 'textfield',
                'value'       => 4,
                'dependency' => array(
                    'element' => 'slider',
                    'value'   => '1',
                ),
            ),
            array(
                'param_name' => 'autoplay',
                'heading'    => esc_html__( 'Autoplay', 'udetor' ),
                'type'       => 'checkbox',
                'std'        => 'no',
                'dependency' => array(
                    'element' => 'slider',
                    'value'   => '1',
                ),
            ),
            array(
                'param_name' => 'enable_info',
                'heading'    => esc_html__( 'Enable Shot Info', 'udetor' ),
                'type'       => 'checkbox',
                'dependency' => array(
                    'element' => 'network',
                    'value'   => array( 'dribbble', 'instagram' )
                ),
            ),
            array(
                'param_name' => 'info_style',
                'heading'    => esc_html__( 'Info Style', 'udetor' ),
                'type'       => 'dropdown',
                'value' => array(
                    esc_html__( 'Inside Shot', 'udetor' )  => 'inside',
                    esc_html__( 'Outside Shot', 'udetor' ) => 'outside',
                ),
                'dependency' => array(
                    'element' => 'enable_info',
                    'value'   => 'true',
                ),
            ),
            array(
                'param_name' => 'mask_bg',
                'heading'    => esc_html__( 'Mask Overlay', 'udetor' ),
                'type'       => 'colorpicker',
                'value'      => 'rgba(0, 0, 0, .85)',
                'dependency' => array(
                    'element' => 'info_style',
                    'value'   => 'inside',
                ),
            ),
            array(
                'param_name' => 'text_color',
                'heading'    => esc_html__( 'Text Color', 'udetor' ),
                'type'       => 'colorpicker',
                'dependency' => array(
                    'element' => 'info_style',
                    'value'   => 'inside',
                ),
            ),
            array(
                'param_name'       => 'social_network_custom_id',
                'heading'          => esc_html__( 'Hidden ID', 'udetor' ),
                'type'             => 'textfield',
                'value'            => 1122334455,
                'edit_field_class' => 'hidden',
            ),
        )
    )
);