<?php
/**
 * Created by PhpStorm.
 * User: duongnth
 * Date: 7/6/2017
 * Time: 2:22 PM
 */

// Map new Service Box element.
vc_map(
    array(
        'name'     => esc_html__( 'Icon Box', 'udetor' ),
        'base'     => 'udetor_services',
        ////'icon'   => 'fa fa-credit-card',
        'category' => esc_html__( 'Udetor Elements', 'udetor' ),
        'params'   => array(
            array(
                'param_name'       => 'style',
                'heading'          => esc_html__( 'Style', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-6 mgt15',
                'group'            => esc_html__( 'General', 'udetor' ),
                'value'            => array(
                    esc_html__( 'Character', 'udetor' ) => 'character',
                    esc_html__( 'Icon', 'udetor' )      => 'icon',
                    esc_html__( 'Image', 'udetor' )     => 'image',
                ),
            ),
            array(
                'param_name'       => 'align',
                'heading'          => esc_html__( 'Box Alignment', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-6',
                'group'            => esc_html__( 'General', 'udetor' ),
                'value'            => array(
                    esc_html__( 'Left', 'udetor' )   => 'left',
                    esc_html__( 'Center', 'udetor' ) => 'center',
                    esc_html__( 'Right', 'udetor' )  => 'right',
                ),
            ),
            array(
                'param_name' => 'content_box',
                'heading'    => esc_html__( 'Content', 'udetor' ),
                'type'       => 'textarea',
                'group'      => esc_html__( 'General', 'udetor' ),
                'holder'     => 'p'
            ),
            array(
                'param_name' => 'text_color',
                'heading'    => esc_html__( 'Text Color', 'udetor' ),
                'type'       => 'colorpicker',
                'group'      => esc_html__( 'General', 'udetor' ),
            ),
            array(
                'param_name' => 'read_more',
                'heading'    => esc_html__( 'Enable Read More?', 'udetor' ),
                'type'       => 'checkbox',
                'group'      => esc_html__( 'General', 'udetor' ),
            ),
            array(
                'param_name' => 'read_more_link',
                'heading'    => esc_html__( 'Read more link', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'General', 'udetor' ),
                'dependency' => array(
                    'element' => 'read_more',
                    'value'   => 'true',
                ),
            ),
            array(
                'param_name'  => 'extra_class',
                'heading'     => esc_html__( 'Extra Class Name', 'udetor' ),
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'udetor' ),
                'type'        => 'textfield',
                'group'       => esc_html__( 'General', 'udetor' ),
            ),
            array(
                'param_name'  => 'character_text',
                'heading'     => esc_html__( 'Character', 'udetor' ),
                'type'        => 'textfield',
                'group'       => esc_html__( 'Character Settings', 'udetor' ),
                'value'       => 1,
                'dependency'  => array(
                    'element' => 'style',
                    'value'   => 'character',
                ),
            ),
            array(
                'param_name' => 'character_color',
                'heading'    => esc_html__( 'Character color', 'udetor' ),
                'type'       => 'colorpicker',
                'group'      => esc_html__( 'Character Settings', 'udetor' ),
                'value'      => '#e2e2e2',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'character',
                ),
            ),
            array(
                'param_name' => 'character_font_family',
                'heading'    => esc_html__( 'Font Family', 'udetor' ),
                'type'       => 'dropdown',
                'group'      => esc_html__( 'Character Settings', 'udetor' ),
                'value'      => $fonts,
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'character',
                ),
            ),
            array(
                'param_name' => 'character_font_weight',
                'heading'    => esc_html__( 'Font Weight', 'udetor' ),
                'type'       => 'dropdown',
                'group'      => esc_html__( 'Character Settings', 'udetor' ),
                'value'      => $weights,
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'character',
                ),
            ),
            array(
                'param_name' => 'character_font_size',
                'heading'    => esc_html__( 'Font Size (px)', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Character Settings', 'udetor' ),
                'value'      => 90,
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'character',
                ),
            ),
            array(
                'param_name' => 'character_margin_bottom',
                'heading'    => esc_html__( 'Margin Bottom (px)', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Character Settings', 'udetor' ),
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'character',
                ),
            ),
            array(
                'param_name' => 'character_width',
                'heading'    => esc_html__( 'Character Width (px, for center alignment)', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Character Settings', 'udetor' ),
                'value'      => 50,
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'character',
                ),
            ),
            array(
                'param_name'  => 'icon_type',
                'heading'     => esc_html__( 'Icon Library', 'udetor' ),
                'type'        => 'dropdown',
                'group'       => esc_html__( 'Icon Settings', 'udetor' ),
                'value'       => array(
                    esc_html__( 'Font Awesome', 'udetor' ) => 'fontawesome',
                    esc_html__( 'Open Iconic', 'udetor' )  => 'openiconic',
                    esc_html__( 'Typicons', 'udetor' )     => 'typicons',
                    esc_html__( 'Entypo', 'udetor' )       => 'entypo',
                    esc_html__( 'Linecons', 'udetor' )     => 'linecons',
                ),
                'dependency'  => array(
                    'element' => 'style',
                    'value'   => 'icon',
                ),
            ),
            array(
                'param_name'  => 'icon_fontawesome',
                'heading'     => esc_html__( 'Icon', 'udetor' ),
                'description' => esc_html__( 'Select icon from library.', 'udetor' ),
                'type'        => 'iconpicker',
                'group'       => esc_html__( 'Icon Settings', 'udetor' ),
                'value'       => 'fa fa-adjust',
                'settings'    => array(
                    'emptyIcon'    => false,
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'fontawesome',
                ),
            ),
            array(
                'param_name'  => 'icon_openiconic',
                'heading'     => esc_html__( 'Icon', 'udetor' ),
                'description' => esc_html__( 'Select icon from library.', 'udetor' ),
                'type'        => 'iconpicker',
                'group'       => esc_html__( 'Icon Settings', 'udetor' ),
                'value'       => 'vc-oi vc-oi-dial',
                'settings'    => array(
                    'emptyIcon'    => false,
                    'type'         => 'openiconic',
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'openiconic',
                ),
            ),
            array(
                'param_name'  => 'icon_typicons',
                'heading'     => esc_html__( 'Icon', 'udetor' ),
                'description' => esc_html__( 'Select icon from library.', 'udetor' ),
                'type'        => 'iconpicker',
                'group'       => esc_html__( 'Icon Settings', 'udetor' ),
                'value'       => 'typcn typcn-adjust-brightness',
                'settings'    => array(
                    'emptyIcon'    => false,
                    'type'         => 'typicons',
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'typicons',
                ),
            ),
            array(
                'param_name' => 'icon_entypo',
                'heading'    => esc_html__( 'Icon', 'udetor' ),
                'type'       => 'iconpicker',
                'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                'value'      => 'entypo-icon entypo-icon-note',
                'settings'   => array(
                    'emptyIcon'    => false,
                    'type'         => 'entypo',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value'   => 'entypo',
                ),
            ),
            array(
                'param_name'  => 'icon_linecons',
                'heading'     => esc_html__( 'Icon', 'udetor' ),
                'description' => esc_html__( 'Select icon from library.', 'udetor' ),
                'type'        => 'iconpicker',
                'group'       => esc_html__( 'Icon Settings', 'udetor' ),
                'value'       => 'vc_li vc_li-heart',
                'settings'    => array(
                    'emptyIcon'    => false,
                    'type'         => 'linecons',
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'linecons',
                ),
            ),
            array(
                'param_name' => 'icon_color',
                'heading'    => esc_html__( 'Icon color', 'udetor' ),
                'type'       => 'colorpicker',
                'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                'value'      => '#ff4064',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'icon',
                ),
            ),
            array(
                'param_name' => 'icon_hover_color',
                'heading'    => esc_html__( 'Icon Hover Color', 'udetor' ),
                'type'       => 'colorpicker',
                'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'icon',
                ),
            ),
            array(
                'param_name' => 'icon_size',
                'heading'    => esc_html__( 'Icon Size (px)', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                'value'      => 24,
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'icon',
                ),
            ),
            array(
                'param_name' => 'icon_mgb',
                'heading'    => esc_html__( 'Margin Bottom (px)', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                'value'      => 0,
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'icon',
                ),
            ),
            array(
                'param_name' => 'icon_box',
                'heading'    => esc_html__( 'Enable Box Wrap Icon?', 'udetor' ),
                'type'       => 'checkbox',
                'value'      => 'false',
                'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'icon',
                ),
            ),
            array(
                'param_name' => 'icon_box_position',
                'heading'    => esc_html__( 'Icon Box Position', 'udetor' ),
                'type'       => 'dropdown',
                'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                'value'      => array(
                    esc_html__( 'Top', 'udetor' )   => '',
                    esc_html__( 'Left', 'udetor' )  => 'left',
                    esc_html__( 'Right', 'udetor' ) => 'right',
                ),
                'dependency' => array(
                    'element' => 'icon_box',
                    'value'   => 'true',
                ),
                'edit_field_class' => 'vc_col-sm-4 vc_column',
            ),
            array(
                'param_name' => 'icon_box_width',
                'heading'    => esc_html__( 'Icon Box Width', 'udetor' ),
                'type'       => 'dropdown',
                'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                'value'      => array(
                    esc_html__( 'Large (80x80px)', 'udetor' )  => 'large',
                    esc_html__( 'Medium (64x64px)', 'udetor' ) => 'medium',
                    esc_html__( 'Small (48x48px)', 'udetor' )  => 'small',
                    esc_html__( 'Custom Size', 'udetor' )      => 'custom',
                ),
                'dependency' => array(
                    'element' => 'icon_box',
                    'value'   => 'true',
                ),
                'edit_field_class' => 'vc_col-sm-4 vc_column',
            ),
            array(
                'param_name' => 'icon_box_style',
                'heading'    => esc_html__( 'Icon Box Style', 'udetor' ),
                'type'       => 'dropdown',
                'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                'value'      => array(
                    esc_html__( 'Circle', 'udetor' ) => 'circle',
                    esc_html__( 'Square', 'udetor' ) => 'square',
                ),
                'dependency' => array(
                    'element' => 'icon_box',
                    'value'   => 'true',
                ),
                'edit_field_class' => 'vc_col-sm-4 vc_column',
            ),
            array(
                'param_name' => 'icon_box_custom',
                'heading'    => esc_html__( 'Custom Size (px)', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                'value'      => 80,
                'dependency' => array(
                    'element' => 'icon_box_width',
                    'value'   => 'custom',
                ),
            ),
            array(
                'param_name' => 'icon_border_color',
                'heading'    => esc_html__( 'Border Color', 'udetor' ),
                'type'       => 'colorpicker',
                'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                'dependency' => array(
                    'element' => 'icon_box',
                    'value'   => 'true',
                ),
            ),
            array(
                'param_name' => 'icon_bg_color',
                'heading'    => esc_html__( 'Background Color', 'udetor' ),
                'type'       => 'colorpicker',
                'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                'dependency' => array(
                    'element' => 'icon_box',
                    'value'   => 'true',
                ),
            ),
            array(
                'param_name' => 'icon_hover_border_color',
                'heading'    => esc_html__( 'Border Hover', 'udetor' ),
                'type'       => 'colorpicker',
                'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                'dependency' => array(
                    'element' => 'icon_box',
                    'value'   => 'true',
                ),
            ),
            array(
                'param_name' => 'icon_hover_bg_color',
                'heading'    => esc_html__( 'Background Hover', 'udetor' ),
                'type'       => 'colorpicker',
                'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                'dependency' => array(
                    'element' => 'icon_box',
                    'value'   => 'true',
                ),
            ),
            array(
                'param_name' => 'icon_box_link',
                'heading'    => esc_html__( 'Link to', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Icon Settings', 'udetor' ),
                'dependency' => array(
                    'element' => 'icon_box',
                    'value'   => 'true',
                ),
            ),
            array(
                'param_name' => 'graphic',
                'heading'    => esc_html__( 'Upload Image', 'udetor' ),
                'type'       => 'attach_image',
                'group'      => esc_html__( 'Image Settings', 'udetor' ),
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'image',
                ),
            ),
            array(
                'param_name' => 'image_radius',
                'heading'    => esc_html__( 'Border Radius (px)', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Image Settings', 'udetor' ),
                'value'      => 0,
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'image',
                ),
            ),
            array(
                'param_name' => 'image_mgb',
                'heading'    => esc_html__( 'Margin Bottom (px)', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Image Settings', 'udetor' ),
                'value'      => 20,
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'image',
                ),
            ),
            array(
                'param_name' => 'image_opacity',
                'heading'    => esc_html__( 'Image Opacity', 'udetor' ),
                'type'       => 'range',
                'group'      => esc_html__( 'Image Settings', 'udetor' ),
                'value'      => 1,
                'min'        => 0,
                'max'        => 1,
                'step'       => 0.1,
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'image',
                ),
            ),
            array(
                'param_name'       => 'title_text',
                'heading'          => esc_html__( 'Heading', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-12 mgb20',
                'group'            => esc_html__( 'Heading Settings', 'udetor' ),
            ),
            array(
                'param_name'       => 'font_family',
                'heading'          => esc_html__( 'Font Family', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 mgb20',
                'group'            => esc_html__( 'Heading Settings', 'udetor' ),
                'value'            => $fonts,
            ),
            array(
                'param_name'       => 'font_weight',
                'heading'          => esc_html__( 'Font Weight', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 mgb20 vc_column',
                'group'            => esc_html__( 'Heading Settings', 'udetor' ),
                'value'            => $weights,
                'dependency' => array(
                    'element'   => 'font_family',
                    'not_empty' => true
                ),
            ),
            array(
                'param_name'       => 'title_color',
                'heading'          => esc_html__( 'Color', 'udetor' ),
                'type'             => 'colorpicker',
                'edit_field_class' => 'vc_col-sm-4 mgb20 vc_column',
                'group'            => esc_html__( 'Heading Settings', 'udetor' ),
                'dependency' => array(
                    'element'   => 'font_family',
                    'not_empty' => true
                ),
            ),
            array(
                'param_name'       => 'text_transform',
                'heading'          => esc_html__( 'Text Transform', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Heading Settings', 'udetor' ),
                'value'            => array(
                    esc_html__( 'None', 'udetor' )       => 'none',
                    esc_html__( 'Uppercase', 'udetor' )  => 'uppercase',
                    esc_html__( 'Capitalize', 'udetor' ) => 'capitalize',
                ),
            ),
            array(
                'param_name'       => 'title_spacing',
                'heading'          => esc_html__( 'Letter Spacing (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Heading Settings', 'udetor' ),
                'value'            => 0,
            ),
            array(
                'param_name'       => 'font_size',
                'heading'          => esc_html__( 'Font Size (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Heading Settings', 'udetor' ),
                'value'            => 24,
            ),
            array(
                'param_name'       => 'heading_mgb',
                'heading'          => esc_html__( 'Margin Bottom (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Heading Settings', 'udetor' ),
                'value'            => 15,
            ),
            array(
                'param_name' => 'sep',
                'heading'    => esc_html__( 'Enable Separator?', 'udetor' ),
                'type'       => 'checkbox',
                'value'      => 'false',
                'group'      => esc_html__( 'Separator', 'udetor' ),
            ),
            array(
                'param_name' => 'sep_color',
                'heading'    => esc_html__( 'Separator Color', 'udetor' ),
                'type'       => 'colorpicker',
                'group'      => esc_html__( 'Separator', 'udetor' ),
                'value'      => '#bf9869',
                'dependency' => array(
                    'element' => 'sep',
                    'value'   => 'true',
                ),
            ),
            array(
                'param_name' => 'setting',
                'type'       => 'css_editor',
                'group'      => esc_html__( 'Background Settings', 'udetor' ),
            ),
            array(
                'param_name' => 'sub_1',
                'heading'    => esc_html__( 'Hover Settings', 'udetor' ),
                'type'       => 'sub_heading',
                'group'      => esc_html__( 'Background Settings', 'udetor' ),
            ),
            array(
                'param_name'       => 'border_hover_color',
                'heading'          => esc_html__( 'Border Hover color', 'udetor' ),
                'type'             => 'colorpicker',
                'edit_field_class' => 'vc_col-sm-4 mgb20',
                'group'            => esc_html__( 'Background Settings', 'udetor' ),
            ),
            array(
                'param_name'       => 'text_hover_color',
                'heading'          => esc_html__( 'Text Hover color', 'udetor' ),
                'type'             => 'colorpicker',
                'edit_field_class' => 'vc_col-sm-4 mgb20',
                'group'            => esc_html__( 'Background Settings', 'udetor' ),
            ),
            array(
                'param_name'       => 'bg_hover_color',
                'heading'          => esc_html__( 'Background Hover color', 'udetor' ),
                'type'             => 'colorpicker',
                'edit_field_class' => 'vc_col-sm-4 mgb20',
                'group'            => esc_html__( 'Background Settings', 'udetor' ),
            ),
            array(
                'param_name'       => 'services_custom_id',
                'heading'          => esc_html__( 'ID', 'udetor' ),
                'type'             => 'textfield',
                'value'            => 1122334455,
                'group'            => esc_html__( 'General', 'udetor' ),
                'edit_field_class' => 'hidden',
            ),
        )
    )
);