<?php
/**
 * Created by PhpStorm.
 * User: duongnth
 * Date: 7/6/2017
 * Time: 2:22 PM
 */

// Map new Separator element.
vc_map(
    array(
        'name'     => esc_html__( 'Separator', 'udetor' ),
        'base'     => 'udetor_separator',
        ////'icon'   => 'fa fa-minus',
        'category' => esc_html__( 'Udetor Elements', 'udetor' ),
        'params'   => array(
            array(
                'param_name' => 'style',
                'heading'    => esc_html__( 'Separator style', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Solid', 'udetor' )   => 'solid',
                    esc_html__( 'Double', 'udetor' )  => 'double',
                    esc_html__( 'Dashed', 'udetor' )  => 'dashed',
                    esc_html__( 'Pattern', 'udetor' ) => 'pattern',
                ),
            ),
            array(
                'param_name' => 'align',
                'heading'    => esc_html__( 'Separator Alignment', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Left', 'udetor' )   => 'left',
                    esc_html__( 'Center', 'udetor' ) => 'center',
                    esc_html__( 'Right', 'udetor' )  => 'right',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'width',
                'heading'    => esc_html__( 'Separator width (Example: 50px or 50%)', 'udetor' ),
                'type'       => 'textfield',
                'value'      => '100%',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'height',
                'heading'    => esc_html__( 'Separator Height (px)', 'udetor' ),
                'type'       => 'textfield',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'solid',
                ),
            ),
            array(
                'param_name' => 'color',
                'heading'    => esc_html__( 'Separator Color', 'udetor' ),
                'type'       => 'colorpicker',
                'value'      => '#ebebeb',
            ),
            array(
                'param_name' => 'symbol',
                'heading'    => esc_html__( 'Separator with symbol', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Icon', 'udetor' )  => 'icon',
                    esc_html__( 'Image', 'udetor' ) => 'image',
                    esc_html__( 'Text', 'udetor' )  => 'text',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name'  => 'icon_type',
                'heading'     => esc_html__( 'Icon Library', 'udetor' ),
                'type'        => 'dropdown',
                'value'       => array(
                    esc_html__( 'Font Awesome', 'udetor' ) => 'fontawesome',
                    esc_html__( 'Open Iconic', 'udetor' )  => 'openiconic',
                    esc_html__( 'Typicons', 'udetor' )     => 'typicons',
                    esc_html__( 'Entypo', 'udetor' )       => 'entypo',
                    esc_html__( 'Linecons', 'udetor' )     => 'linecons',
                ),
                'dependency'  => array(
                    'element' => 'symbol',
                    'value'   => 'icon',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name'  => 'icon_fontawesome',
                'heading'     => esc_html__( 'Icon', 'udetor' ),
                'description' => esc_html__( 'Select icon from library.', 'udetor' ),
                'type'        => 'iconpicker',
                'settings'    => array(
                    'emptyIcon'    => true,
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'fontawesome',
                ),
            ),
            array(
                'param_name'  => 'icon_openiconic',
                'heading'     => esc_html__( 'Icon', 'udetor' ),
                'description' => esc_html__( 'Select icon from library.', 'udetor' ),
                'type'        => 'iconpicker',
                'settings'    => array(
                    'emptyIcon'    => true,
                    'type'         => 'openiconic',
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'openiconic',
                ),
            ),
            array(
                'param_name'  => 'icon_typicons',
                'heading'     => esc_html__( 'Icon', 'udetor' ),
                'description' => esc_html__( 'Select icon from library.', 'udetor' ),
                'type'        => 'iconpicker',
                'settings'    => array(
                    'emptyIcon'    => true,
                    'type'         => 'typicons',
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'typicons',
                ),
            ),
            array(
                'param_name' => 'icon_entypo',
                'heading'    => esc_html__( 'Icon', 'udetor' ),
                'type'       => 'iconpicker',
                'settings'   => array(
                    'emptyIcon'    => true,
                    'type'         => 'entypo',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value'   => 'entypo',
                ),
            ),
            array(
                'param_name'  => 'icon_linecons',
                'heading'     => esc_html__( 'Icon', 'udetor' ),
                'description' => esc_html__( 'Select icon from library.', 'udetor' ),
                'type'        => 'iconpicker',
                'settings'    => array(
                    'emptyIcon'    => true,
                    'type'         => 'linecons',
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'linecons',
                ),
            ),
            array(
                'param_name' => 'icon_color',
                'heading'    => esc_html__( 'Icon Color', 'udetor' ),
                'type'       => 'colorpicker',
                'value'      => '#646464',
                'dependency' => array(
                    'element' => 'symbol',
                    'value'   => 'icon',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'icon_size',
                'heading'    => esc_html__( 'Icon Size (px)', 'udetor' ),
                'type'       => 'textfield',
                'value'      => '14',
                'dependency' => array(
                    'element' => 'symbol',
                    'value'   => 'icon',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'graphic',
                'heading'    => esc_html__( 'Upload image', 'udetor' ),
                'type'       => 'attach_image',
                'dependency' => array(
                    'element' => 'symbol',
                    'value'   => 'image',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'image_radius',
                'heading'    => esc_html__( 'Border radius (px)', 'udetor' ),
                'type'       => 'textfield',
                'value'      => '100',
                'dependency' => array(
                    'element' => 'symbol',
                    'value'   => 'image',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'text_editor',
                'heading'    => esc_html__( 'Content', 'udetor' ),
                'type'       => 'textarea',
                'dependency' => array(
                    'element' => 'symbol',
                    'value'   => 'text',
                ),
            ),
            array(
                'param_name' => 'text_transform',
                'heading'    => esc_html__( 'Text Transform', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'None', 'udetor' )       => 'none',
                    esc_html__( 'Uppercase', 'udetor' )  => 'uppercase',
                    esc_html__( 'Capitalize', 'udetor' ) => 'capitalize',
                ),
                'dependency' => array(
                    'element' => 'symbol',
                    'value'   => 'text',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'spacing',
                'heading'    => esc_html__( 'Letter Spacing (px)', 'udetor' ),
                'type'       => 'textfield',
                'value'      => 0,
                'dependency' => array(
                    'element' => 'symbol',
                    'value'   => 'text',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'font_family',
                'heading'    => esc_html__( 'Font Family', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => $fonts,
                'dependency' => array(
                    'element' => 'symbol',
                    'value'   => 'text',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'font_weight',
                'heading'    => esc_html__( 'Font Weight', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => $weights,
                'dependency' => array(
                    'element' => 'symbol',
                    'value'   => 'text',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'font_size',
                'heading'    => esc_html__( 'Font Size (px)', 'udetor' ),
                'type'       => 'textfield',
                'value'      => 16,
                'dependency' => array(
                    'element' => 'symbol',
                    'value'   => 'text',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'text_color',
                'heading'    => esc_html__( 'Text Color', 'udetor' ),
                'type'       => 'colorpicker',
                'value'      => '#646464',
                'dependency' => array(
                    'element' => 'symbol',
                    'value'   => 'text',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'margin_top',
                'heading'    => esc_html__( 'Margin Top (px)', 'udetor' ),
                'type'       => 'textfield',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'margin_bottom',
                'heading'    => esc_html__( 'Margin Bottom (px)', 'udetor' ),
                'type'       => 'textfield',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'heading'     => esc_html__( 'Extra Class Name', 'udetor' ),
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'udetor' ),
                'type'        => 'textfield',
                'param_name'  => 'el_class',
            ),
            array(
                'param_name'       => 'separator_custom_id',
                'heading'          => esc_html__( 'Hidden ID', 'udetor' ),
                'type'             => 'textfield',
                'value'            => 1122334455,
                'edit_field_class' => 'hidden',
            ),
        )
    )
);