<?php
/**
 * Created by PhpStorm.
 * User: duongnth
 * Date: 7/6/2017
 * Time: 2:22 PM
 */

// Map new Pricing Table element.
vc_map(
    array(
        'name'                    => esc_html__( 'Pricing Table', 'udetor' ),
        //'icon'                    => 'fa fa-table',
        'base'                    => 'udetor_pricing',
        'category'                => esc_html__( 'Udetor Elements', 'udetor' ),
        'as_parent'               => array( 'only' => 'udetor_pricing_single' ),
        'content_element'         => true,
        'show_settings_on_create' => true,
        'js_view'                 => 'VcColumnView',
        'params'                  => array(
            array(
                'param_name'  => 'style',
                'heading'     => esc_html__( 'Style', 'udetor' ),
                'description' => esc_html__( 'Choose style for pricing table.', 'udetor' ),
                'type'        => 'dropdown',
                'value'       => array(
                    esc_html__( 'Style 1', 'udetor' ) => 'style-1',
                    esc_html__( 'Style 2', 'udetor' ) => 'style-2',
                    esc_html__( 'Style 3', 'udetor' ) => 'style-3',
                    esc_html__( 'Style 4', 'udetor' ) => 'style-4',
                ),
            ),
            array(
                'heading'     => esc_html__( 'Extra Class Name', 'udetor' ),
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'udetor' ),
                'type'        => 'textfield',
                'param_name'  => 'el_class',
            ),
            array(
                'param_name'       => 'pricing_custom_id',
                'heading'          => esc_html__( 'ID', 'udetor' ),
                'type'             => 'textfield',
                'value'            => 1122334455,
                'edit_field_class' => 'hidden',
            ),
        )
    )
);

// Map new Pricing Item element.
vc_map(
    array(
        'name'            => esc_html__( 'Pricing Item', 'udetor' ),
        //'icon'            => 'fa fa-columns',
        'base'            => 'udetor_pricing_single',
        'content_element' => true,
        'as_child'        => array( 'only' => 'udetor_pricing' ),
        'params'          => array(
            array(
                'heading'     => esc_html__( 'Featured Item', 'udetor' ),
                'description' => 'Checked to active',
                'type'        => 'checkbox',
                'value'       => array( esc_html__( 'Yes', 'udetor' ) => 'yes' ),
                'param_name'  => 'pricing_featured',
            ),
            array(
                'heading'          => esc_html__( 'Heading', 'udetor' ),
                'type'             => 'textfield',
                'param_name'       => 'pricing_title',
                'edit_field_class' => 'vc_col-sm-12 mgb20 mgt20',
            ),
            array(
                'heading'    => esc_html__( 'Description', 'udetor' ),
                'type'       => 'textfield',
                'param_name' => 'pricing_title_desc',
                'dependency' => array(
                    'element'            => 'style',
                    'value_not_equal_to' => 'style-1',
                ),
            ),
            array(
                'heading'          => esc_html__( 'Price (eg: 100)', 'udetor' ),
                'type'             => 'textfield',
                'param_name'       => 'pricing_price',
                'edit_field_class' => 'vc_col-sm-4 mgb20 mgt20',
            ),
            array(
                'heading'          => esc_html__( 'Unit (eg: $)', 'udetor' ),
                'type'             => 'textfield',
                'param_name'       => 'pricing_price_units',
                'edit_field_class' => 'vc_col-sm-4 mgb20 mgt20',
            ),
            array(
                'heading'          => esc_html__( 'Value (eg: Monthly)', 'udetor' ),
                'type'             => 'textfield',
                'param_name'       => 'pricing_units',
                'edit_field_class' => 'vc_col-sm-4 mgb20 mgt20',
            ),
            array(
                'heading'    => esc_html__( 'Show Icon', 'udetor' ),
                'type'       => 'checkbox',
                'value'      => array( __( 'Yes', 'udetor' ) => 'yes' ),
                'param_name' => 'show_option_icon',
                'edit_field_class' => 'vc_col-sm-4 mgb20 mgt20',
            ),
            array(
                'heading'    => esc_html__( 'Options', 'udetor' ),
                'type'       => 'param_group',
                'param_name' => 'pricing_content',
                'params'     => array(
                    array(
                        'type'        => 'iconpicker',
                        'heading'     => esc_html__( 'Icon', 'udetor' ),
                        'param_name'  => 'item_icon_fontawesome',
                        'value'       => 'fa fa-info-circle',
                        'settings'    => array(
                            'emptyIcon'    => false, // default true, display an "EMPTY" icon?
                            'iconsPerPage' => 200, // default 100, how many icons per/page to display
                        ),
                        'description' => esc_html__( 'Select icon from library.', 'udetor' ),
                    ),
                    array(
                        'type'        => 'textarea',
                        'heading'     => esc_html__( 'Option Text', 'udetor' ),
                        'param_name'  => 'pricing_item',
                    ),
                ),
            ),
            array(
                'heading'          => esc_html__( 'Button Text', 'udetor' ),
                'description'      => 'Enter pricing table button text',
                'type'             => 'textfield',
                'holder'           => 'span',
                'class'            => 'pricing-button',
                'param_name'       => 'button_text',
                'edit_field_class' => 'vc_col-sm-6 vc_column mgb20',
                'dependency' => array(
                    'element'            => 'style',
                    'value_not_equal_to' => 'style-2',
                ),
            ),
            array(
                'heading'          => esc_html__( 'Button Link', 'udetor' ),
                'description'      => 'Enter button link',
                'type'             => 'textfield',
                'param_name'       => 'button_link',
                'edit_field_class' => 'vc_col-sm-6 mgb20 mgt15',
            ),
        )
    )
);