<?php
/**
 * Created by PhpStorm.
 * User: duongnth
 * Date: 7/6/2017
 * Time: 2:27 PM
 */

// Map new masonry builder element.
vc_map(
    array(
        'name'         => esc_html__( 'Masonry Layout', 'udetor' ),
        //'icon'         => 'fa fa-th-list',
        'base'         => 'udetor_masonry',
        'category'     => esc_html__( 'Udetor Elements', 'udetor' ),
        'as_parent'    => array( 'only' => 'udetor_masonry_element' ),
        'is_container' => true,
        'js_view'      => 'VcColumnView',
        'params'       => array(
            array(
                'param_name' => 'column',
                'heading'    => esc_html__( 'Number of columns', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( '3 Columns', 'udetor' ) => '3',
                    esc_html__( '4 Columns', 'udetor' ) => '4',
                    esc_html__( '5 Columns', 'udetor' ) => '5',
                    esc_html__( '6 Columns', 'udetor' ) => '6',
                    esc_html__( '7 Columns', 'udetor' ) => '7',
                    esc_html__( '8 Columns', 'udetor' ) => '8',
                ),
            ),
            array(
                'param_name' => 'border',
                'heading'    => esc_html__( 'Enable Border Outline', 'udetor' ),
                'type'       => 'checkbox',
                'value'      => array( esc_html__( 'Yes', 'udetor' ) => 'yes' ),
            ),
            array(
                'param_name' => 'border_color',
                'heading'    => esc_html__( 'Border Color', 'udetor' ),
                'type'       => 'colorpicker',
                'value'      => '#ddd',
                'dependency' => array(
                    'element'   => 'border',
                    'not_empty' => true,
                ),
            ),
            array(
                'param_name' => 'gutter_width',
                'heading'    => esc_html__( 'Gutter Width (px)', 'udetor' ),
                'type'       => 'textfield',
                'value'      => '',
            ),
            array(
                'param_name'  => 'extra_class',
                'heading'     => esc_html__( 'Extra Class Name', 'udetor' ),
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'udetor' ),
                'type'        => 'textfield',
            ),
            array(
                'param_name'       => 'wr_masonry_custom_id',
                'heading'          => esc_html__( 'Hidden ID', 'udetor' ),
                'type'             => 'textfield',
                'value'            => 1122334455,
                'edit_field_class' => 'hidden',
            ),
        )
    )
);
vc_map(
    array(
        'name'         => esc_html__( 'Masonry Element', 'udetor' ),
        //'icon'         => 'fa fa-stop',
        'base'         => 'udetor_masonry_element',
        'as_child'     => array( 'only' => 'udetor_masonry' ),
        'as_parent'    => array( 'only' => 'vc_column_text, udetor_product, udetor_blog_single, udetor_carousel, udetor_banner, udetor_gallery_single, udetor_counter_up, udetor_google_map, vc_icon, udetor_member, udetor_subscribe_form, udetor_services, udetor_quote, udetor_heading' ),
        'is_container' => true,
        'js_view'      => 'VcColumnView',
        'params'       => array(
            array(
                'param_name' => 'size',
                'heading'    => esc_html__( 'Element Size', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Small Square', 'udetor' )          => 'small-square',
                    esc_html__( 'Large Square', 'udetor' )          => 'large-square',
                    esc_html__( 'Rectangle (Portrait)', 'udetor' )  => 'rectangle-portrait',
                    esc_html__( 'Rectangle (Landscape)', 'udetor' ) => 'rectangle-landscape',
                ),
            ),
            array(
                'param_name' => 'setting',
                'type'       => 'css_editor',
                'group'      => esc_html__( 'Background Settings', 'udetor' ),
            ),
        )
    )
);