<?php
/**
 * Created by PhpStorm.
 * User: duongnth
 * Date: 7/6/2017
 * Time: 2:23 PM
 */

// Map new List element.
vc_map(
    array(
        'name'            => esc_html__( 'List', 'udetor' ),
        //'icon'            => 'fa fa-list-alt',
        'base'            => 'udetor_lists',
        'category'        => esc_html__( 'Udetor Elements', 'udetor' ),
        'content_element' => true,
        'params'          => array(
            array(
                'param_name' => 'style',
                'heading'    => esc_html__( 'List Style', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'None', 'udetor' )           => 'none',
                    esc_html__( 'Square Bullet', 'udetor' )  => 'square',
                    esc_html__( 'Dot Bullet', 'udetor' )     => 'dot',
                    esc_html__( 'Number', 'udetor' )         => 'number-list',
                    esc_html__( 'Icon', 'udetor' )           => 'icon-list',
                ),
                'std'        => 'none',
            ),
            array(
                'heading'    => esc_html__( 'List Content', 'udetor' ),
                'type'       => 'param_group',
                'param_name' => 'list_content',
                'params'     => array(
                    array(
                        'type'       => 'iconpicker',
                        'heading'    => esc_html__( 'Icon', 'udetor' ),
                        'param_name' => 'icon_fontawesome',
                        'value'      => 'fa fa-info-circle',
                        'settings'   => array(
                            'emptyIcon'    => false,
                            'iconsPerPage' => 200,
                        ),
                        'description' => esc_html__( 'Icon show only when you select Icon style.', 'udetor' ),
                    ),
                    array(
                        'param_name'  => 'icon_color',
                        'heading'     => esc_html__( 'Icon Color', 'udetor' ),
                        'type'        => 'colorpicker',
                        'value'       => '#363636',
                        'description' => esc_html__( 'Support both styles', 'udetor' ),
                    ),
                    array(
                        'type'       => 'textfield',
                        'heading'    => esc_html__( 'Text', 'udetor' ),
                        'param_name' => 'list_item',
                    ),
                    array(
                        'param_name' => 'link',
                        'heading'    => esc_html__( 'Link To', 'udetor' ),
                        'type'       => 'vc_link',
                    ),
                ),
            ),
            array(
                'param_name' => 'line_height',
                'heading'    => esc_html__( 'Line spacing', 'udetor' ),
                'group'      => esc_html__( 'Design settings', 'udetor' ),
                'type'       => 'textfield',
                'value'      => '20',
            ),
            array(
                'param_name'  => 'bg_color',
                'heading'     => esc_html__( 'Icon Background', 'udetor' ),
                'group'      => esc_html__( 'Design settings', 'udetor' ),
                'type'        => 'colorpicker',
                'value'       => '#fff',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'icon-list',
                ),
            ),
            array(
                'param_name' => 'divider',
                'heading'    => esc_html__( 'Enable divider', 'udetor' ),
                'group'      => esc_html__( 'Design settings', 'udetor' ),
                'type'       => 'checkbox',
                'value'      => array( __( 'Yes', 'udetor' ) => 'yes' ),
            ),
            array(
                'param_name' => 'divider_style',
                'heading'    => esc_html__( 'Divider style', 'udetor' ),
                'group'      => esc_html__( 'Design settings', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Solid', 'udetor' )  => 'solid',
                    esc_html__( 'Dotted', 'udetor' ) => 'dotted',
                    esc_html__( 'Dashed', 'udetor' ) => 'dashed',
                    esc_html__( 'Double', 'udetor' ) => 'double',
                    esc_html__( 'Groove', 'udetor' ) => 'groove',
                    esc_html__( 'Ridge', 'udetor' )  => 'ridge',
                    esc_html__( 'Inset', 'udetor' )  => 'inset',
                    esc_html__( 'Outset', 'udetor' ) => 'outset',
                ),
                'dependency' => array(
                    'element' => 'divider',
                    'value'   => 'yes',
                ),
            ),
            array(
                'param_name' => 'divider_width',
                'heading'    => esc_html__( 'Divider width', 'udetor' ),
                'group'      => esc_html__( 'Design settings', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( '1px', 'udetor' ) => '1',
                    esc_html__( '2px', 'udetor' ) => '2',
                    esc_html__( '3px', 'udetor' ) => '3',
                ),
                'dependency' => array(
                    'element' => 'divider',
                    'value'   => 'yes',
                ),
            ),
            array(
                'param_name'  => 'divider_color',
                'heading'     => esc_html__( 'Divider color', 'udetor' ),
                'group'      => esc_html__( 'Design settings', 'udetor' ),
                'type'        => 'colorpicker',
                'value'       => '#c5c5c5',
                'dependency' => array(
                    'element' => 'divider',
                    'value'   => 'yes',
                ),
            ),
            array(
                'param_name' => 'border',
                'heading'    => esc_html__( 'Enable icon border', 'udetor' ),
                'group'      => esc_html__( 'Design settings', 'udetor' ),
                'type'       => 'checkbox',
                'value'      => array( esc_html__( 'Yes', 'udetor' ) => 'yes' ),
            ),
            array(
                'param_name' => 'border_style',
                'heading'    => esc_html__( 'Border style', 'udetor' ),
                'group'      => esc_html__( 'Design settings', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Solid', 'udetor' )  => 'solid',
                    esc_html__( 'Dotted', 'udetor' ) => 'dotted',
                    esc_html__( 'Dashed', 'udetor' ) => 'dashed',
                    esc_html__( 'Double', 'udetor' ) => 'double',
                    esc_html__( 'Groove', 'udetor' ) => 'groove',
                    esc_html__( 'Ridge', 'udetor' )  => 'ridge',
                    esc_html__( 'Inset', 'udetor' )  => 'inset',
                    esc_html__( 'Outset', 'udetor' ) => 'outset',
                ),
                'dependency' => array(
                    'element' => 'border',
                    'value'   => 'yes',
                ),
            ),
            array(
                'param_name' => 'border_width',
                'heading'    => esc_html__( 'Border width', 'udetor' ),
                'group'      => esc_html__( 'Design settings', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( '1px', 'udetor' ) => '1',
                    esc_html__( '2px', 'udetor' ) => '2',
                    esc_html__( '3px', 'udetor' ) => '3',
                ),
                'dependency' => array(
                    'element' => 'border',
                    'value'   => 'yes',
                ),
            ),
            array(
                'param_name' => 'border_radius',
                'heading'    => esc_html__( 'Border radius', 'udetor' ),
                'group'      => esc_html__( 'Design settings', 'udetor' ),
                'type'       => 'textfield',
                'value'      => '0',
                'dependency' => array(
                    'element' => 'border',
                    'value'   => 'yes',
                ),
            ),
            array(
                'param_name'  => 'border_color',
                'heading'     => esc_html__( 'Border color', 'udetor' ),
                'group'      => esc_html__( 'Design settings', 'udetor' ),
                'type'        => 'colorpicker',
                'value'       => '#363636',
                'dependency' => array(
                    'element' => 'border',
                    'value'   => 'yes',
                ),
            ),
            array(
                'heading'     => esc_html__( 'Extra Class Name', 'udetor' ),
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'udetor' ),
                'type'        => 'textfield',
                'param_name'  => 'list_custom_class',
            ),
            array(
                'param_name'       => 'lists_custom_id',
                'heading'          => esc_html__( 'ID', 'udetor' ),
                'type'             => 'textfield',
                'value'            => 1122334455,
                'edit_field_class' => 'hidden',
            ),
        )
    )
);