<?php
/**
 * Created by PhpStorm.
 * User: duongnth
 * Date: 7/6/2017
 * Time: 2:22 PM
 */

// Map new Heading element.
vc_map(
    array(
        'name'     => esc_html__( 'Udetor Custom Heading', 'udetor' ),
        'base'     => 'udetor_heading',
        ////'icon'   => 'fa fa-header',
        'category' => esc_html__( 'Udetor Elements', 'udetor' ),
        'params'   => array(
            array(
                'param_name'       => 'align',
                'heading'          => esc_html__( 'Heading Alignment', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-6 mgt15',
                'group'            => esc_html__( 'General', 'udetor' ),
                'value'            => array(
                    esc_html__( 'Left', 'udetor' )   => 'left',
                    esc_html__( 'Center', 'udetor' ) => 'center',
                    esc_html__( 'Right', 'udetor' )  => 'right',
                ),
            ),
            array(
                'param_name'       => 'tag',
                'heading'          => esc_html__( 'Heading Tags', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-6',
                'group'            => esc_html__( 'General', 'udetor' ),
                'value'            => array(
                    esc_html__( 'H1', 'udetor' ) => 'h1',
                    esc_html__( 'H2', 'udetor' ) => 'h2',
                    esc_html__( 'H3', 'udetor' ) => 'h3',
                    esc_html__( 'H4', 'udetor' ) => 'h4',
                    esc_html__( 'H5', 'udetor' ) => 'h5',
                    esc_html__( 'H6', 'udetor' ) => 'h6',
                ),
            ),
            array(
                'param_name'  => 'extra_class',
                'heading'     => esc_html__( 'Extra Class Name', 'udetor' ),
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'udetor' ),
                'type'        => 'textfield',
                'group'       => esc_html__( 'General', 'udetor' ),
            ),
            array(
                'param_name'       => 'heading_custom_id',
                'heading'          => esc_html__( 'Hidden ID', 'udetor' ),
                'type'             => 'textfield',
                'value'            => 1122334455,
                'group'            => esc_html__( 'General', 'udetor' ),
                'edit_field_class' => 'hidden',
            ),
            array(
                'param_name' => 'sub_1',
                'heading'    => esc_html__( 'Sub heading settings', 'udetor' ),
                'type'       => 'sub_heading',
                'group'      => esc_html__( 'Typography', 'udetor' ),
            ),
            array(
                'param_name'       => 'sub_text',
                'heading'          => esc_html__( 'Text', 'udetor' ),
                'value'            => esc_html__( 'This is custom heading element', 'udetor' ),
                'type'             => 'textarea',
                'edit_field_class' => 'vc_col-sm-12 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
            ),
            array(
                'param_name'       => 'sub_font_family',
                'heading'          => esc_html__( 'Font Family', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => $fonts,
            ),
            array(
                'param_name'       => 'sub_font_weight',
                'heading'          => esc_html__( 'Font Weight', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => $weights,
                'std' 			   => '400',
                'dependency' => array(
                    'element'   => 'sub_font_family',
                    'not_empty' => true
                ),
            ),
            array(
                'param_name'       => 'sub_text_transform',
                'heading'          => esc_html__( 'Text Transform', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => array(
                    esc_html__( 'None', 'udetor' )       => 'none',
                    esc_html__( 'Uppercase', 'udetor' )  => 'uppercase',
                    esc_html__( 'Capitalize', 'udetor' ) => 'capitalize',
                ),
            ),
            array(
                'param_name'       => 'sub_color',
                'heading'          => esc_html__( 'Color', 'udetor' ),
                'type'             => 'colorpicker',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'dependency' => array(
                    'element'   => 'sub_font_family',
                    'not_empty' => true
                ),
            ),
            array(
                'param_name'       => 'sub_font_size',
                'heading'          => esc_html__( 'Font Size (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => 20,
            ),
            array(
                'param_name'       => 'sub_line_height',
                'heading'          => esc_html__( 'Line Height', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => '20px',
            ),
            array(
                'param_name'       => 'sub_spacing',
                'heading'          => esc_html__( 'Letter Spacing (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => 0,
            ),
            array(
                'param_name' => 'sub_2',
                'heading'    => esc_html__( 'Heading settings', 'udetor' ),
                'type'       => 'sub_heading',
                'group'      => esc_html__( 'Typography', 'udetor' ),
            ),
            array(
                'param_name'       => 'text',
                'heading'          => esc_html__( 'Text', 'udetor' ),
                'value'            => esc_html__( 'This is custom heading element', 'udetor' ),
                'type'             => 'textarea',
                'edit_field_class' => 'vc_col-sm-12 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'holder'           => 'h2'
            ),
            array(
                'param_name'       => 'font_family',
                'heading'          => esc_html__( 'Font Family', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => $fonts,
            ),
            array(
                'param_name'       => 'font_weight',
                'heading'          => esc_html__( 'Font Weight', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => $weights,
                'std' 			   => '400',
                'dependency' => array(
                    'element'   => 'font_family',
                    'not_empty' => true
                ),
            ),
            array(
                'param_name'       => 'text_transform',
                'heading'          => esc_html__( 'Text Transform', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => array(
                    esc_html__( 'None', 'udetor' )       => 'none',
                    esc_html__( 'Uppercase', 'udetor' )  => 'uppercase',
                    esc_html__( 'Capitalize', 'udetor' ) => 'capitalize',
                ),
            ),
            array(
                'param_name'       => 'color',
                'heading'          => esc_html__( 'Color', 'udetor' ),
                'type'             => 'colorpicker',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'dependency' => array(
                    'element'   => 'font_family',
                    'not_empty' => true
                ),
            ),
            array(
                'param_name'       => 'font_size',
                'heading'          => esc_html__( 'Font Size (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => 44,
            ),
            array(
                'param_name'       => 'line_height',
                'heading'          => esc_html__( 'Line Height', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => '44px',
            ),
            array(
                'param_name'       => 'spacing',
                'heading'          => esc_html__( 'Letter Spacing (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => 0,
            ),
            array(
                'param_name'       => 'margin_top',
                'heading'          => esc_html__( 'Margin Top (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => 10,
            ),
            array(
                'param_name'       => 'margin_bottom',
                'heading'          => esc_html__( 'Margin Bottom (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => 20,
            ),
            array(
                'param_name' => 'link_to',
                'heading'    => esc_html__( 'Link To', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Typography', 'udetor' ),
            ),
            array(
                'param_name' => 'sub_3',
                'heading'    => esc_html__( 'Description settings', 'udetor' ),
                'type'       => 'sub_heading',
                'group'      => esc_html__( 'Typography', 'udetor' ),
            ),
            array(
                'param_name'       => 'desc_text',
                'heading'          => esc_html__( 'Text', 'udetor' ),
                'value'            => esc_html__( 'This is custom heading element', 'udetor' ),
                'type'             => 'textarea',
                'edit_field_class' => 'vc_col-sm-12 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
            ),
            array(
                'param_name'       => 'desc_font_family',
                'heading'          => esc_html__( 'Font Family', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => $fonts,
            ),
            array(
                'param_name'       => 'desc_font_weight',
                'heading'          => esc_html__( 'Font Weight', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => $weights,
                'std' 			   => '400',
                'dependency' => array(
                    'element'   => 'desc_font_family',
                    'not_empty' => true
                ),
            ),
            array(
                'param_name'       => 'desc_text_transform',
                'heading'          => esc_html__( 'Text Transform', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => array(
                    esc_html__( 'None', 'udetor' )       => 'none',
                    esc_html__( 'Uppercase', 'udetor' )  => 'uppercase',
                    esc_html__( 'Capitalize', 'udetor' ) => 'capitalize',
                ),
            ),
            array(
                'param_name'       => 'desc_color',
                'heading'          => esc_html__( 'Color', 'udetor' ),
                'type'             => 'colorpicker',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'dependency' => array(
                    'element'   => 'desc_font_family',
                    'not_empty' => true
                ),
            ),
            array(
                'param_name'       => 'desc_font_size',
                'heading'          => esc_html__( 'Font Size (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => 10,
            ),
            array(
                'param_name'       => 'desc_line_height',
                'heading'          => esc_html__( 'Line Height', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => '15px',
            ),
            array(
                'param_name'       => 'desc_spacing',
                'heading'          => esc_html__( 'Letter Spacing (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Typography', 'udetor' ),
                'value'            => 3,
            ),
            array(
                'param_name'       => 'separator',
                'heading'          => esc_html__( 'Select Style', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-12 vc_column',
                'group'            => esc_html__( 'Separator', 'udetor' ),
                'value'            => array(
                    esc_html__( 'None', 'udetor' )       => 'none',
                    esc_html__( 'Short Line', 'udetor' ) => 'line',
                    esc_html__( 'Icon', 'udetor' )       => 'icon',
                    esc_html__( 'Image', 'udetor' )      => 'image',
                ),
            ),
            array(
                'param_name'       => 'separator_mgt',
                'heading'          => esc_html__( 'Margin Top (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
                'group'            => esc_html__( 'Separator', 'udetor' ),
            ),
            array(
                'param_name'       => 'separator_mgb',
                'heading'          => esc_html__( 'Margin Bottom (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
                'group'            => esc_html__( 'Separator', 'udetor' ),
            ),
            array(
                'param_name' => 'separator_width',
                'heading'    => esc_html__( 'Width (px)', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Separator', 'udetor' ),
                'value'      => 48,
                'dependency' => array(
                    'element' => 'separator',
                    'value'   => 'line',
                ),
            ),
            array(
                'param_name' => 'separator_height',
                'heading'    => esc_html__( 'Height (px)', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Separator', 'udetor' ),
                'value'      => 1,
                'dependency' => array(
                    'element' => 'separator',
                    'value'   => 'line',
                ),
            ),
            array(
                'param_name' => 'separator_position',
                'heading'    => esc_html__( 'Position', 'udetor' ),
                'type'       => 'dropdown',
                'group'      => esc_html__( 'Separator', 'udetor' ),
                'value'      => array(
                    esc_html__( 'Top', 'udetor' )    => 'top',
                    esc_html__( 'Bottom', 'udetor' ) => 'bottom',
                ),
                'dependency' => array(
                    'element' => 'separator',
                    'value'   => 'line',
                ),
            ),
            array(
                'param_name' => 'separator_color',
                'heading'    => esc_html__( 'Color', 'udetor' ),
                'type'       => 'colorpicker',
                'group'      => esc_html__( 'Separator', 'udetor' ),
                'value'      => '#8e8e8e',
                'dependency' => array(
                    'element' => 'separator',
                    'value'   => 'line',
                ),
            ),
            array(
                'param_name'  => 'icon_type',
                'heading'     => esc_html__( 'Icon Library', 'udetor' ),
                'type'        => 'dropdown',
                'group'       => esc_html__( 'Separator', 'udetor' ),
                'value'       => array(
                    esc_html__( 'Font Awesome', 'udetor' ) => 'fontawesome',
                    esc_html__( 'Open Iconic', 'udetor' )  => 'openiconic',
                    esc_html__( 'Typicons', 'udetor' )     => 'typicons',
                    esc_html__( 'Entypo', 'udetor' )       => 'entypo',
                    esc_html__( 'Linecons', 'udetor' )     => 'linecons',
                ),
                'dependency'  => array(
                    'element' => 'separator',
                    'value'   => 'icon',
                ),
            ),
            array(
                'param_name'  => 'icon_fontawesome',
                'heading'     => esc_html__( 'Icon', 'udetor' ),
                'description' => esc_html__( 'Select icon from library.', 'udetor' ),
                'type'        => 'iconpicker',
                'group'       => esc_html__( 'Separator', 'udetor' ),
                'value'       => 'fa fa-adjust',
                'settings'    => array(
                    'emptyIcon'    => false,
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'fontawesome',
                ),
            ),
            array(
                'param_name'  => 'icon_openiconic',
                'heading'     => esc_html__( 'Icon', 'udetor' ),
                'description' => esc_html__( 'Select icon from library.', 'udetor' ),
                'type'        => 'iconpicker',
                'group'       => esc_html__( 'Separator', 'udetor' ),
                'value'       => 'vc-oi vc-oi-dial',
                'settings'    => array(
                    'emptyIcon'    => false,
                    'type'         => 'openiconic',
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'openiconic',
                ),
            ),
            array(
                'param_name'  => 'icon_typicons',
                'heading'     => esc_html__( 'Icon', 'udetor' ),
                'description' => esc_html__( 'Select icon from library.', 'udetor' ),
                'type'        => 'iconpicker',
                'group'       => esc_html__( 'Separator', 'udetor' ),
                'value'       => 'typcn typcn-adjust-brightness',
                'settings'    => array(
                    'emptyIcon'    => false,
                    'type'         => 'typicons',
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'typicons',
                ),
            ),
            array(
                'param_name' => 'icon_entypo',
                'heading'    => esc_html__( 'Icon', 'udetor' ),
                'type'       => 'iconpicker',
                'group'      => esc_html__( 'Separator', 'udetor' ),
                'value'      => 'entypo-icon entypo-icon-note',
                'settings'   => array(
                    'emptyIcon'    => false,
                    'type'         => 'entypo',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value'   => 'entypo',
                ),
            ),
            array(
                'param_name'  => 'icon_linecons',
                'heading'     => esc_html__( 'Icon', 'udetor' ),
                'description' => esc_html__( 'Select icon from library.', 'udetor' ),
                'type'        => 'iconpicker',
                'group'       => esc_html__( 'Separator', 'udetor' ),
                'value'       => 'vc_li vc_li-heart',
                'settings'    => array(
                    'emptyIcon'    => false,
                    'type'         => 'linecons',
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'linecons',
                ),
            ),
            array(
                'param_name' => 'icon_color',
                'heading'    => esc_html__( 'Color', 'udetor' ),
                'type'       => 'colorpicker',
                'group'      => esc_html__( 'Separator', 'udetor' ),
                'value'      => '#646464',
                'dependency' => array(
                    'element' => 'separator',
                    'value'   => 'icon',
                ),
            ),
            array(
                'param_name' => 'icon_position',
                'heading'    => esc_html__( 'Position', 'udetor' ),
                'type'       => 'dropdown',
                'group'      => esc_html__( 'Separator', 'udetor' ),
                'value'      => array(
                    esc_html__( 'Top', 'udetor' )    => 'top',
                    esc_html__( 'Bottom', 'udetor' ) => 'bottom',
                ),
                'dependency' => array(
                    'element' => 'separator',
                    'value'   => 'icon',
                ),
            ),
            array(
                'param_name' => 'icon_size',
                'heading'    => esc_html__( 'Icon Size (px)', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Separator', 'udetor' ),
                'value'      => 14,
                'dependency' => array(
                    'element' => 'separator',
                    'value'   => 'icon',
                ),
            ),
            array(
                'param_name' => 'icon_line',
                'heading'    => esc_html__( 'Enable line?', 'udetor' ),
                'type'       => 'toggle',
                'group'      => esc_html__( 'Separator', 'udetor' ),
                'value'      => true,
                'dependency' => array(
                    'element' => 'separator',
                    'value'   => 'icon',
                ),
            ),
            array(
                'param_name' => 'graphic',
                'heading'    => esc_html__( 'Upload image', 'udetor' ),
                'type'       => 'attach_image',
                'group'      => esc_html__( 'Separator', 'udetor' ),
                'dependency' => array(
                    'element' => 'separator',
                    'value'   => 'image',
                ),
            ),
            array(
                'param_name' => 'image_position',
                'heading'    => esc_html__( 'Position', 'udetor' ),
                'type'       => 'dropdown',
                'group'      => esc_html__( 'Separator', 'udetor' ),
                'value'      => array(
                    esc_html__( 'Top', 'udetor' )    => 'top',
                    esc_html__( 'Bottom', 'udetor' ) => 'bottom',
                ),
                'dependency' => array(
                    'element' => 'separator',
                    'value'   => 'image',
                ),
            ),
            array(
                'param_name' => 'image_radius',
                'heading'    => esc_html__( 'Border radius (px)', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Separator', 'udetor' ),
                'value'      => 100,
                'dependency' => array(
                    'element' => 'separator',
                    'value'   => 'image',
                ),
            ),
            array(
                'param_name' => 'image_line',
                'heading'    => esc_html__( 'Enable line?', 'udetor' ),
                'type'       => 'toggle',
                'group'      => esc_html__( 'Separator', 'udetor' ),
                'value'      => true,
                'dependency' => array(
                    'element' => 'separator',
                    'value'   => 'image',
                ),
            ),
        )
    )
);