<?php
/**
 * Created by PhpStorm.
 * User: duongnth
 * Date: 7/6/2017
 * Time: 2:24 PM
 */

// Map new Google Maps element.
vc_map(
    array(
        'base'            => 'udetor_google_map',
        'name'            => esc_html__( 'Google Maps', 'udetor' ),
        //'icon'            => 'fa fa-map-marker',
        'category'        => esc_html__( 'Udetor Elements', 'udetor' ),
        'content_element' => true,
        'params'          => array(
            array(
                'param_name'       => 'api',
                'heading'          => esc_html__( 'Maps API', 'udetor' ),
                'description' => sprintf( __( 'Get a <a target="_blank" rel="noopener noreferrer" href="%s">API key</a></a>', 'udetor' ), 'https://developers.google.com/maps/documentation/javascript/get-api-key' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-6 vc_column vc_column-with-padding',
            ),
            array(
                'param_name'       => 'address',
                'heading'          => esc_html__( 'Address', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
                'admin_label'      => true,
            ),
            array(
                'param_name'       => 'z',
                'heading'          => esc_html__( 'Zoom Level', 'udetor' ),
                'description'      => esc_html__( 'Between 0-20', 'udetor' ),
                'type'             => 'textfield',
                'value'            => 14,
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name'       => 'lat',
                'heading'          => esc_html__( 'Latitude', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name'       => 'lon',
                'heading'          => esc_html__( 'Longitude', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name'       => 'w',
                'heading'          => esc_html__( 'Width', 'udetor' ),
                'description'      => esc_html__( 'Numeric value only, Unit is Pixel.', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name'       => 'h',
                'heading'          => esc_html__( 'Height', 'udetor' ),
                'description'      => esc_html__( 'Numeric value only, Unit is Pixel.', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'marker',
                'type'       => 'checkbox',
                'value'      => array(
                    esc_html__( 'Map Marker', 'udetor' ) => 'true',
                ),
            ),
            array(
                'param_name'  => 'markerimage',
                'heading'     => esc_html__( 'Marker Image', 'udetor' ),
                'description' => esc_html__( 'Change default Marker.', 'udetor' ),
                'type'        => 'attach_image',
                'dependency' => array(
                    'element' => 'marker',
                    'value'   => array( 'true' ),
                ),
            ),
            array(
                'param_name'  => 'infowindow',
                'heading'     => esc_html__( 'Info Box', 'udetor' ),
                'description' => esc_html__( 'Strong, br are accepted.', 'udetor' ),
                'type'        => 'textfield',
                'dependency' => array(
                    'element' => 'marker',
                    'value'   => array( 'true' ),
                ),
            ),
            array(
                'param_name' => 'infowindowdefault',
                'type'       => 'checkbox',
                'value'      => array( __( 'Always show info box', 'udetor' ) => 'true' ),
                'dependency' => array(
                    'element' => 'marker',
                    'value'   => array( 'true' ),
                ),
            ),
            array(
                'param_name' => 'traffic',
                'type'       => 'checkbox',
                'value'      => array( __( 'Show Traffic', 'udetor' ) => 'true' )
            ),
            array(
                'param_name' => 'draggable',
                'type'       => 'checkbox',
                'value'      => array( __( 'Draggable', 'udetor' ) => 'true' ),
                'dependency' => array(
                    'element' => 'marker',
                    'value'   => array( 'true' ),
                ),
            ),
            array(
                'param_name' => 'hidecontrols',
                'type'       => 'checkbox',
                'value'      => array( __( 'Hide Control', 'udetor' ) => 'true' ),
            ),
            array(
                'param_name' => 'scrollwheel',
                'type'       => 'checkbox',
                'value'      => array( __( 'Scrollwheel zooming', 'udetor' ) => 'true' )
            ),
            array(
                'param_name' => 'maptype',
                'heading'    => esc_html__( 'Map Type', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'ROADMAP', 'udetor' ) => 'ROADMAP',
                    esc_html__( 'SATELLITE', 'udetor' ) => 'SATELLITE',
                    esc_html__( 'HYBRID', 'udetor' ) => 'HYBRID',
                    esc_html__( 'TERRAIN', 'udetor' ) => 'TERRAIN',
                ),
            ),
            array(
                'param_name' => 'mapstype',
                'heading'    => esc_html__( 'Map style', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'None', 'udetor' ) => '',
                    esc_html__( 'Subtle Grayscale', 'udetor' ) => 'grayscale',
                    esc_html__( 'Blue water', 'udetor' ) => 'blue_water',
                    esc_html__( 'Pale Dawn', 'udetor' ) => 'pale_dawn',
                    esc_html__( 'Shades of Grey', 'udetor' ) => 'shades_of_grey',
                ),
            ),
        )
    )
);