<?php
/**
 * Created by PhpStorm.
 * User: duongnth
 * Date: 7/6/2017
 * Time: 2:25 PM
 */

// Map new Dropcap element.
vc_map(
    array(
        'base'     => 'udetor_dropcaps',
        'name'     => esc_html__( 'Drop Caps', 'udetor' ),
        ////'icon'   => 'fa fa-text-height',
        'category' => esc_html__( 'Udetor Elements', 'udetor' ),
        'params'   => array(
            array(
                'param_name' => 'dropcaps',
                'heading'    => esc_html__( 'Dropcaps Letter', 'udetor' ),
                'type'       => 'textfield',
            ),
            array(
                'param_name'  => 'text',
                'heading'     => esc_html__( 'Content', 'udetor' ),
                'type'        => 'textarea',
                'admin_label' => true,
            ),
            array(
                'param_name' => 'color',
                'heading'    => esc_html__( 'Dropcaps Color', 'udetor' ),
                'type'       => 'colorpicker',
                'value'      => '#323232',
            ),
            array(
                'param_name' => 'style',
                'heading'    => esc_html__( 'Style', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'No Background', 'udetor' )  => 'no-bg',
                    esc_html__( 'Square Outline', 'udetor' ) => 'square-outline',
                    esc_html__( 'Square Solid', 'udetor' )   => 'square-solid',
                    esc_html__( 'Circle Outline', 'udetor' ) => 'circle-outline',
                    esc_html__( 'Circle Solid', 'udetor' )   => 'circle-solid',
                ),
            ),
            array(
                'param_name' => 'bg_color',
                'heading'    => esc_html__( 'Background Color', 'udetor' ),
                'type'       => 'colorpicker',
                'value'      => '#d4a769',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => array( 'square-solid', 'circle-solid' ),
                ),
            ),
            array(
                'param_name' => 'border_color',
                'heading'    => esc_html__( 'Border Color', 'udetor' ),
                'type'       => 'colorpicker',
                'value'      => '#d4a769',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => array( 'square-outline', 'circle-outline' ),
                ),
            ),
            array(
                'param_name'  => 'extra_class',
                'heading'     => esc_html__( 'Extra Class Name', 'udetor' ),
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'udetor' ),
                'type'        => 'textfield',
            ),
            array(
                'param_name'       => 'dropcaps_custom_id',
                'heading'          => esc_html__( 'Hidden ID', 'udetor' ),
                'type'             => 'textfield',
                'value'            => 1122334455,
                'edit_field_class' => 'hidden',
            ),
        )
    )
);