<?php
/**
 * Created by PhpStorm.
 * User: duongnth
 * Date: 7/6/2017
 * Time: 2:28 PM
 */

// Map new button element
vc_map(
    array(
        'name'     => esc_html__( 'Udetor Button', 'udetor' ),
        'base'     => 'udetor_button',
        ////'icon'   => 'fa fa-square',
        'category' => esc_html__( 'Udetor Elements', 'udetor' ),
        'params'   => array(
            array(
                'param_name'       => 'text',
                'heading'          => esc_html__( 'Button Text', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-4',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
                'std'              => esc_html__( 'Button Text', 'udetor' ),
                'admin_label'      => true
            ),
            array(
                'param_name'       => 'link',
                'heading'          => esc_html__( 'Link To', 'udetor' ),
                'type'             => 'vc_link',
                'edit_field_class' => 'vc_col-sm-8',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
            ),
            array(
                'param_name' => 'sub_1',
                'heading'    => esc_html__( 'General Settings', 'udetor' ),
                'type'       => 'sub_heading',
                'group'      => esc_html__( 'Normal State', 'udetor' ),
            ),
            array(
                'param_name'       => 'font_family',
                'heading'          => esc_html__( 'Font Family', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
                'value'            => $fonts,
            ),
            array(
                'param_name'       => 'font_weight',
                'heading'          => esc_html__( 'Font Weight', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
                'value'            => $weights,
                'dependency' => array(
                    'element'   => 'font_family',
                    'not_empty' => true,
                ),
            ),
            array(
                'param_name'       => 'font_size',
                'heading'          => esc_html__( 'Font Size (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
                'value'            => 14,
            ),
            array(
                'param_name'       => 'font_style',
                'heading'          => esc_html__( 'Font Style', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
                'value'            => array(
                    esc_html__( 'Normal', 'udetor' ) => 'normal',
                    esc_html__( 'Italic', 'udetor' ) => 'italic',
                ),
            ),
            array(
                'param_name'       => 'text_transform',
                'heading'          => esc_html__( 'Text Transform', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
                'value'            => array(
                    esc_html__( 'None', 'udetor' )       => 'none',
                    esc_html__( 'Uppercase', 'udetor' )  => 'uppercase',
                    esc_html__( 'Capitalize', 'udetor' ) => 'capitalize',
                ),
            ),
            array(
                'param_name'       => 'alignment',
                'heading'          => esc_html__( 'Button Alignment', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
                'value'            => array(
                    esc_html__( 'Left', 'udetor' )   => 'tl',
                    esc_html__( 'Center', 'udetor' ) => 'tc',
                    esc_html__( 'Right', 'udetor' )  => 'tr',
                ),
            ),
            array(
                'param_name'       => 'color',
                'heading'          => esc_html__( 'Color', 'udetor' ),
                'type'             => 'colorpicker',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
                'value'            => '#fff',
            ),
            array(
                'param_name'       => 'bg_color',
                'heading'          => esc_html__( 'Background Color', 'udetor' ),
                'type'             => 'colorpicker',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
                'value'            => '#3d3d3d',
            ),
            array(
                'param_name' => 'sub_2',
                'heading'    => esc_html__( 'Border Settings', 'udetor' ),
                'type'       => 'sub_heading',
                'group'      => esc_html__( 'Normal State', 'udetor' ),
            ),
            array(
                'param_name'       => 'border_width',
                'heading'          => esc_html__( 'Border Width (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
            ),
            array(
                'param_name'       => 'border_style',
                'heading'          => esc_html__( 'Border Style', 'udetor' ),
                'type'             => 'dropdown',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
                'value'            => array(
                    esc_html__( 'Solid', 'udetor' )  => 'solid',
                    esc_html__( 'Dashed', 'udetor' ) => 'dasded',
                    esc_html__( 'Dotted', 'udetor' ) => 'dotted',
                    esc_html__( 'Double', 'udetor' ) => 'double',
                ),
                'dependency' => array(
                    'element'   => 'border_width',
                    'not_empty' => true,
                ),
            ),
            array(
                'param_name'       => 'border_radius',
                'heading'          => esc_html__( 'Border Radius (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
            ),
            array(
                'param_name'       => 'border_color',
                'heading'          => esc_html__( 'Border Color', 'udetor' ),
                'type'             => 'colorpicker',
                'edit_field_class' => 'vc_col-sm-6 vc_column vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
                'value'            => '#3d3d3d',
                'dependency' => array(
                    'element'   => 'border_width',
                    'not_empty' => true,
                ),
            ),
            array(
                'param_name' => 'sub_3',
                'heading'    => esc_html__( 'Spacing', 'udetor' ),
                'type'       => 'sub_heading',
                'group'      => esc_html__( 'Normal State', 'udetor' ),
            ),
            array(
                'param_name'       => 'line_height',
                'heading'          => esc_html__( 'Line Height', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
                'value'            => '40px'
            ),
            array(
                'param_name'       => 'padding',
                'heading'          => esc_html__( 'Padding Left + Right (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
                'value'            => 15
            ),
            array(
                'param_name'       => 'spacing',
                'heading'          => esc_html__( 'Letter Spacing (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
            ),
            array(
                'param_name'       => 'margin_top',
                'heading'          => esc_html__( 'Margin Top (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
            ),
            array(
                'param_name'       => 'margin_right',
                'heading'          => esc_html__( 'Margin Right (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
            ),
            array(
                'param_name'       => 'margin_bottom',
                'heading'          => esc_html__( 'Margin Bottom (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
            ),
            array(
                'param_name'       => 'margin_left',
                'heading'          => esc_html__( 'Margin Left (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
            ),
            array(
                'param_name' => 'sub_4',
                'heading'    => esc_html__( 'Icon Settings', 'udetor' ),
                'type'       => 'sub_heading',
                'group'      => esc_html__( 'Normal State', 'udetor' ),
            ),
            array(
                'param_name' => 'icon',
                'heading'    => esc_html__( 'Enable Icon?', 'udetor' ),
                'type'       => 'checkbox',
                'group'      => 'Normal State',
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name'  => 'icon_type',
                'heading'     => esc_html__( 'Icon Library', 'udetor' ),
                'type'        => 'dropdown',
                'group'       => esc_html__( 'Normal State', 'udetor' ),
                'value'       => array(
                    esc_html__( 'Font Awesome', 'udetor' ) => 'fontawesome',
                    esc_html__( 'Open Iconic', 'udetor' )  => 'openiconic',
                    esc_html__( 'Typicons', 'udetor' )     => 'typicons',
                    esc_html__( 'Entypo', 'udetor' )       => 'entypo',
                    esc_html__( 'Linecons', 'udetor' )     => 'linecons',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
                'dependency'  => array(
                    'element'   => 'icon',
                    'not_empty' => true,
                ),
            ),
            array(
                'param_name'  => 'icon_fontawesome',
                'heading'     => esc_html__( 'Icon', 'udetor' ),
                'type'        => 'iconpicker',
                'group'       => esc_html__( 'Normal State', 'udetor' ),
                'value'       => 'fa fa-adjust',
                'settings'    => array(
                    'emptyIcon'    => false,
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'fontawesome',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'icon_openiconic',
                'heading'    => esc_html__( 'Icon', 'udetor' ),
                'type'       => 'iconpicker',
                'group'      => esc_html__( 'Normal State', 'udetor' ),
                'value'      => 'vc-oi vc-oi-dial',
                'settings'   => array(
                    'emptyIcon'    => false,
                    'type'         => 'openiconic',
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'openiconic',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'icon_typicons',
                'heading'    => esc_html__( 'Icon', 'udetor' ),
                'type'       => 'iconpicker',
                'group'      => esc_html__( 'Normal State', 'udetor' ),
                'value'      => 'typcn typcn-adjust-brightness',
                'settings'   => array(
                    'emptyIcon'    => false,
                    'type'         => 'typicons',
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'typicons',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'icon_entypo',
                'heading'    => esc_html__( 'Icon', 'udetor' ),
                'type'       => 'iconpicker',
                'group'      => esc_html__( 'Normal State', 'udetor' ),
                'value'      => 'entypo-icon entypo-icon-note',
                'settings'   => array(
                    'emptyIcon'    => false,
                    'type'         => 'entypo',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value'   => 'entypo',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'icon_linecons',
                'heading'    => esc_html__( 'Icon', 'udetor' ),
                'type'       => 'iconpicker',
                'group'      => esc_html__( 'Normal State', 'udetor' ),
                'value'      => 'vc_li vc_li-heart',
                'settings'   => array(
                    'emptyIcon'    => false,
                    'type'         => 'linecons',
                    'iconsPerPage' => 4000,
                ),
                'dependency'  => array(
                    'element' => 'icon_type',
                    'value'   => 'linecons',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'icon_color',
                'heading'    => esc_html__( 'Color', 'udetor' ),
                'type'       => 'colorpicker',
                'group'      => esc_html__( 'Normal State', 'udetor' ),
                'value'      => '#fff',
                'dependency'  => array(
                    'element'   => 'icon',
                    'not_empty' => true,
                ),
                'edit_field_class' => 'vc_col-sm-6 mgt15 vc_column',
            ),
            array(
                'param_name' => 'icon_position',
                'heading'    => esc_html__( 'Position', 'udetor' ),
                'type'       => 'dropdown',
                'group'      => esc_html__( 'Normal State', 'udetor' ),
                'value'      => array(
                    esc_html__( 'Left', 'udetor' )  => 'left',
                    esc_html__( 'Right', 'udetor' ) => 'right',
                ),
                'dependency'  => array(
                    'element'   => 'icon',
                    'not_empty' => true,
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name' => 'icon_size',
                'heading'    => esc_html__( 'Icon Size (px)', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Normal State', 'udetor' ),
                'value'      => 14,
                'dependency'  => array(
                    'element'   => 'icon',
                    'not_empty' => true,
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column',
            ),
            array(
                'param_name'       => 'hover_color',
                'heading'          => esc_html__( 'Text Color', 'udetor' ),
                'type'             => 'colorpicker',
                'group'            => esc_html__( 'Hover State', 'udetor' ),
                'value'            => '#fff',
                'edit_field_class' => 'vc_col-sm-6 mgb20',
            ),
            array(
                'param_name'       => 'hover_border_color',
                'heading'          => esc_html__( 'Border Color', 'udetor' ),
                'type'             => 'colorpicker',
                'edit_field_class' => 'vc_col-sm-4 vc_column mgb20',
                'group'            => esc_html__( 'Hover State', 'udetor' ),
                'value'            => '#3d3d3d',
                'edit_field_class' => 'vc_col-sm-6 mgb20',
            ),
            array(
                'param_name'       => 'hover_bg_color',
                'heading'          => esc_html__( 'Background Color', 'udetor' ),
                'type'             => 'colorpicker',
                'group'            => esc_html__( 'Hover State', 'udetor' ),
                'value'            => '#000',
                'edit_field_class' => 'vc_col-sm-6 mgb20',
            ),
            array(
                'param_name'       => 'hover_icon_color',
                'heading'          => esc_html__( 'Icon Color', 'udetor' ),
                'type'             => 'colorpicker',
                'group'            => esc_html__( 'Hover State', 'udetor' ),
                'value'            => '#fff',
                'edit_field_class' => 'vc_col-sm-6 mgb20',
            ),
            array(
                'param_name'  => 'extra_class',
                'heading'     => esc_html__( 'Extra Class Name', 'udetor' ),
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'udetor' ),
                'type'        => 'textfield',
                'group'       => esc_html__( 'Normal State', 'udetor' ),
            ),
            array(
                'param_name'       => 'button_custom_id',
                'heading'          => esc_html__( 'Hidden ID', 'udetor' ),
                'type'             => 'textfield',
                'value'            => 1122334455,
                'edit_field_class' => 'hidden',
                'group'            => esc_html__( 'Normal State', 'udetor' ),
            ),
        )
    )
);