<?php
/**
 * Created by PhpStorm.
 * User: duongnth
 * Date: 7/6/2017
 * Time: 2:24 PM
 */

// Map new Blog Post element.
vc_map(
    array(
        'name'     => esc_html__( 'Blog Post', 'udetor' ),
        'base'     => 'udetor_blog_list',
        ////'icon'   => 'fa fa-file-text-o',
        'category' => esc_html__( 'Udetor Elements', 'udetor' ),
        'params'   => array(
            array(
                'param_name' => 'orderby',
                'heading'    => esc_html__( 'Order by', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Recent posts', 'udetor' )       => 'date',
                    esc_html__( 'Post ID', 'udetor' )            => 'ID',
                    esc_html__( 'Title', 'udetor' )              => 'title',
                    esc_html__( 'Last modified date', 'udetor' ) => 'modified',
                    esc_html__( 'Random order', 'udetor' )       => 'rand',
                    esc_html__( 'Number of comments', 'udetor' ) => 'comment_count',
                    esc_html__( 'Special posts', 'udetor' )      => 'specials',
                ),
            ),
            array(
                'param_name' => 'sort_order',
                'heading'    => esc_html__( 'Sort Order', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => $order_way_values,
                'std'        => 'ASC',
            ),
            array(
                'param_name'  => 'contain',
                'heading'     => esc_html__( 'Include special posts', 'udetor' ),
                'description' => esc_html__( 'Enter posts title to display only those records (Note: separate values by commas (,)).', 'udetor' ),
                'type'        => 'autocomplete',
                'settings'    => array(
                    'multiple'      => true,
                    'sortable'      => true,
                    'unique_values' => true,
                ),
                'dependency' => array(
                    'element' => 'orderby',
                    'value'   => 'specials'
                ),
            ),
            array(
                'param_name'  => 'exclude',
                'heading'     => esc_html__( 'Exclude posts', 'udetor' ),
                'description' => esc_html__( 'Enter posts title to exclude (Note: separate values by commas (,)).', 'udetor' ),
                'type'        => 'autocomplete',
                'settings'    => array(
                    'multiple'      => true,
                    'sortable'      => true,
                    'unique_values' => true,
                ),
                'dependency'  => array(
                    'element'            => 'orderby',
                    'value_not_equal_to' => 'specials'
                ),
            ),
            array(
                'param_name' => 'style',
                'heading'    => esc_html__( 'Layout', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Standard', 'udetor' )      => 'standard',
                    esc_html__( 'Horizontal', 'udetor' )    => 'horizontal',
                    esc_html__( 'List', 'udetor' )          => 'list',
                    esc_html__( 'Minimal', 'udetor' )       => 'minimal',
                    esc_html__( 'Inner Content', 'udetor' ) => 'inner',
                    esc_html__( 'Zigzag', 'udetor' )        => 'zigzag',
                ),
                'edit_field_class' => 'vc_col-sm-6 mgb20 mgt20',
            ),
            array(
                'param_name'       => 'limit',
                'heading'          => esc_html__( 'Total posts', 'udetor' ),
                'description'      => esc_html__( 'Set max limit for posts in list or enter -1 to display all', 'udetor' ),
                'type'             => 'textfield',
                'value'            => '12',
                'edit_field_class' => 'vc_col-sm-6 mgt20 mgb20',
            ),
            array(
                'param_name'  => 'columns',
                'heading'     => esc_html__( 'Number of columns displayed', 'udetor' ),
                'type'        => 'dropdown',
                'value'       => array(
                    esc_html__( '1 column', 'udetor' ) => '1',
                    esc_html__( '2 columns', 'udetor' ) => '2',
                    esc_html__( '3 columns', 'udetor' ) => '3',
                    esc_html__( '4 columns', 'udetor' ) => '4',
                    esc_html__( '5 columns', 'udetor' ) => '5',
                    esc_html__( '6 columns', 'udetor' ) => '6',
                ),
                'std'         => '3',
                'edit_field_class' => 'vc_col-sm-6 vc_column mgt10 mgb20',
            ),
            array(
                'param_name'  => 'gap',
                'heading'     => esc_html__( 'Gutter', 'udetor' ),
                'description' => esc_html__( 'Enter space between post (Unit: pixel).', 'udetor' ),
                'type'        => 'range',
                'value'       => '30',
                'max'         => '100',
                'min'         => '0',
                'step'        => '1',
                'unit'        => 'px',
                'edit_field_class' => 'vc_col-sm-6 mgt10 mgb20',
            ),
            array(
                'param_name'  => 'thumbnail',
                'heading'     => esc_html__( 'Thumbnail size', 'udetor' ),
                'type'        => 'dropdown',
                'value'       => array(
                    esc_html__( 'Small', 'udetor' )  => 'small',
                    esc_html__( 'Medium', 'udetor' ) => 'medium',
                    esc_html__( 'Large', 'udetor' )  => 'large',
                ),
                'std'         => 'medium',
                'dependency'  => array(
                    'element' => 'style',
                    'value'   => 'list'
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column mgt10 mgb20',
            ),
            array(
                'param_name' => 'slider',
                'heading'    => esc_html__( 'Enable Slider', 'udetor' ),
                'type'       => 'checkbox',
                'value'      => array( esc_html__( 'Yes', 'udetor' ) => 'yes' ),
                'std'        => 'no',
                'dependency' => array(
                    'element'            => 'style',
                    'value_not_equal_to' => array( 'list', 'zigzag' )
                ),
            ),
            array(
                'param_name' => 'navigation',
                'heading'    => esc_html__( 'Enable Navigation', 'udetor' ),
                'type'       => 'checkbox',
                'group'      => esc_html__( 'Slider settings', 'udetor' ),
                'value'      => array( esc_html__( 'Yes', 'udetor' ) => 'yes' ),
                'std'        => 'no',
                'dependency' => array(
                    'element' => 'slider',
                    'value'   => 'yes'
                ),
            ),
            array(
                'param_name' => 'pagination',
                'heading'    => esc_html__( 'Enable Pagination', 'udetor' ),
                'type'       => 'checkbox',
                'group'      => esc_html__( 'Slider settings', 'udetor' ),
                'value'      => array( esc_html__( 'Yes', 'udetor' ) => 'yes' ),
                'std'        => 'no',
                'dependency' => array(
                    'element' => 'slider',
                    'value'   => 'yes'
                ),
            ),
            array(
                'param_name' => 'autoplay',
                'heading'    => esc_html__( 'Autoplay', 'udetor' ),
                'type'       => 'checkbox',
                'group'      => esc_html__( 'Slider settings', 'udetor' ),
                'value'      => array( esc_html__( 'Yes', 'udetor' ) => 'yes' ),
                'std'        => 'no',
                'dependency' => array(
                    'element' => 'slider',
                    'value'   => 'yes'
                ),
            ),
            array(
                'param_name' => 'autotime',
                'heading'    => esc_html__( 'Autoplay interval timeout', 'udetor' ),
                'type'       => 'textfield',
                'group'      => esc_html__( 'Slider settings', 'udetor' ),
                'value'      => '5000',
                'dependency' => array(
                    'element' => 'autoplay',
                    'value'   => 'yes'
                ),
            ),
            array(
                'param_name' => 'pause',
                'heading'    => esc_html__( 'Pause on mouse hover', 'udetor' ),
                'type'       => 'checkbox',
                'group'      => esc_html__( 'Slider settings', 'udetor' ),
                'value'      => array( esc_html__( 'Yes', 'udetor' ) => 'yes' ),
                'std'        => 'no',
                'dependency' => array(
                    'element' => 'autoplay',
                    'value'   => 'yes'
                ),
            ),
            array(
                'heading'    => esc_html__( 'Show default content', 'udetor' ),
                'param_name' => 'show_content',
                'type'       => 'checkbox',
                'value'      => array( __( 'Yes', 'udetor' ) => 'yes' ),
                'std'        => 'yes',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'inner'
                ),
            ),
            array(
                'heading'    => esc_html__( 'Display settings', 'udetor' ),
                'param_name' => 'sub',
                'type'       => 'sub_heading',
            ),
            array(
                'param_name' => 'excerpt',
                'type'       => 'checkbox',
                'value'      => array( esc_html__( 'Display excerpt', 'udetor' ) => 'yes' ),
                'std'        => 'yes',
            ),
            array(
                'param_name' => 'image',
                'type'       => 'checkbox',
                'value'      => array( esc_html__( 'Display featured image', 'udetor' ) => 'yes' ),
                'std'        => 'yes',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => array( 'list' ),
                ),
            ),
            array(
                'param_name' => 'meta',
                'type'       => 'checkbox',
                'value'      => array( esc_html__( 'Display meta post', 'udetor' ) => 'yes' ),
                'std'        => 'yes',
            ),
            array(
                'param_name' => 'readmore',
                'type'       => 'checkbox',
                'value'      => array( esc_html__( 'Show Read more?', 'udetor' ) => 'yes' ),
                'std'        => 'yes',
                'dependency' => array(
                    'element'            => 'style',
                    'value_not_equal_to' => 'inner'
                ),
            ),
            array(
                'param_name' => 'divider',
                'type'       => 'checkbox',
                'value'      => array( esc_html__( 'Display divider?', 'udetor' ) => 'yes' ),
                'std'        => 'no',
                'dependency' => array(
                    'element'            => 'style',
                    'value_not_equal_to' => 'zigzag'
                ),
            ),
            array(
                'param_name' => 'divider_color',
                'type'       => 'colorpicker',
                'heading'    => esc_html__( 'Divider color', 'udetor' ),
                'value'      => '#eaeaea',
                'dependency' => array(
                    'element' => 'divider',
                    'value'   => 'yes',
                ),
            ),
            array(
                'param_name' => 'font_size',
                'type'       => 'textfield',
                'heading'    => esc_html__( 'Heading font size (px)', 'udetor' ),
                'value'      => '16',
                'edit_field_class' => 'vc_col-sm-6 vc_column mgt20',
            ),
            array(
                'param_name' => 'excerpt_length',
                'type'       => 'textfield',
                'heading'    => esc_html__( 'Excerpt length by words', 'udetor'),
                'value'      => '20',
                'dependency' => array(
                    'element' => 'excerpt',
                    'value'   => 'yes',
                ),
                'edit_field_class' => 'vc_col-sm-6 vc_column mgt20',
            ),
            array(
                'param_name' => 'align',
                'heading'    => esc_html__( 'Content alignment', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Left', 'udetor' )   => 'tl',
                    esc_html__( 'Center', 'udetor' ) => 'tc',
                    esc_html__( 'Right', 'udetor' )  => 'tr',
                ),
            ),
            array(
                'param_name' => 'content_position',
                'heading'    => esc_html__( 'Content position', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Top', 'udetor' )    => 'top',
                    esc_html__( 'Middle', 'udetor' ) => 'middle',
                    esc_html__( 'Bottom', 'udetor' ) => 'bottom',
                ),
                'std'        => 'bottom',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => 'inner'
                ),
            ),
            array(
                'param_name'  => 'el_class',
                'heading'     => esc_html__( 'Extra Class Name', 'udetor' ),
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'udetor' ),
                'type'        => 'textfield',
            ),
            array(
                'param_name'       => 'blog_list_custom_id',
                'heading'          => esc_html__( 'Hidden ID', 'udetor' ),
                'type'             => 'textfield',
                'value'            => 1122334455,
                'edit_field_class' => 'hidden',
            ),
        )
    )
);