<?php
/**
 * Created by PhpStorm.
 * User: duongnth
 * Date: 7/6/2017
 * Time: 2:23 PM
 */

// Map new Blockquote element.
vc_map(
    array(
        'name'            => esc_html__( 'Blockquote', 'udetor' ),
        //'icon'            => 'fa fa-quote-left',
        'base'            => 'udetor_quote',
        'category'        => esc_html__( 'Udetor Elements', 'udetor' ),
        'content_element' => true,
        'params'          => array(
            array(
                'param_name' => 'style',
                'heading'    => esc_html__( 'Style', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Border', 'udetor' )           => 'border',
                    esc_html__( 'Quote With Icon', 'udetor' )  => 'quote-icon',
                    esc_html__( 'Solid Background', 'udetor' ) => 'solid-bg',
                    esc_html__( 'Outline', 'udetor' )          => 'outline',
                ),
            ),
            array(
                'param_name' => 'border_position',
                'heading'    => esc_html__( 'Border Position', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Left', 'udetor' )  => 'tl',
                    esc_html__( 'Right', 'udetor' ) => 'tr',
                ),
                'dependency' => array(
                    'element' => 'style',
                    'value'   => array( 'border' ),
                ),
            ),
            array(
                'param_name'       => 'icon_margin_top',
                'heading'          => esc_html__( 'Icon Margin Top (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => array( 'quote-icon' ),
                ),
            ),
            array(
                'param_name'       => 'icon_margin_left',
                'heading'          => esc_html__( 'Icon Margin Left (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => array( 'quote-icon' ),
                ),
            ),
            array(
                'param_name' => 'icon_color',
                'heading'    => esc_html__( 'Icon Color', 'udetor' ),
                'type'       => 'colorpicker',
                'value'      => '#363636',
                'edit_field_class' => 'vc_col-sm-4 vc_column',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => array( 'quote-icon' ),
                ),
            ),
            array(
                'param_name' => 'border_color',
                'heading'    => esc_html__( 'Border Color', 'udetor' ),
                'type'       => 'colorpicker',
                'value'      => '#363636',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => array( 'border', 'outline' ),
                ),
            ),
            array(
                'heading'    => esc_html__( 'Border Width (px)', 'udetor' ),
                'type'       => 'textfield',
                'param_name' => 'border_width',
                'value'      => '3',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => array( 'border', 'outline' ),
                ),
            ),
            array(
                'param_name' => 'outline_style',
                'heading'    => esc_html__( 'Outline Style', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Solid', 'udetor' ) => 'solid',
                    esc_html__( 'Dashed', 'udetor' ) => 'dashed',
                    esc_html__( 'Double', 'udetor' ) => 'double',
                    esc_html__( 'Groove', 'udetor' ) => 'groove',
                ),
                'dependency' => array(
                    'element' => 'style',
                    'value'   => array( 'outline' ),
                ),
            ),
            array(
                'param_name' => 'bg_color',
                'heading'    => esc_html__( 'Background Color', 'udetor' ),
                'type'       => 'colorpicker',
                'value'      => '#646464',
                'dependency' => array(
                    'element' => 'style',
                    'value'   => array( 'solid-bg' ),
                ),
            ),
            array(
                'type'        => 'textarea',
                'heading'     => esc_html__( 'Content', 'udetor' ),
                'param_name'  => 'quote_content',
                'description' => esc_html__( 'Enter the content.', 'udetor' ),
                'holder'      => 'blockquote'
            ),
            array(
                'param_name'       => 'text_color',
                'heading'          => esc_html__( 'Text Color', 'udetor' ),
                'type'             => 'colorpicker',
                'value'            => '#222',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
            ),
            array(
                'param_name'       => 'font_size',
                'heading'          => esc_html__( 'Font Size (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
            ),
            array(
                'param_name'       => 'line_height',
                'heading'          => esc_html__( 'Line Height (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
            ),
            array(
                'param_name'       => 'spacing',
                'heading'          => esc_html__( 'Letter Spacing (px)', 'udetor' ),
                'type'             => 'textfield',
                'edit_field_class' => 'vc_col-sm-3 vc_column',
            ),
            array(
                'heading'     => esc_html__( 'Author', 'udetor' ),
                'type'        => 'textfield',
                'param_name'  => 'author',
            ),
            array(
                'param_name'  => 'extra_class',
                'heading'     => esc_html__( 'Extra Class Name', 'udetor' ),
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'udetor' ),
                'type'        => 'textfield',
            ),
            array(
                'param_name'       => 'quote_custom_id',
                'heading'          => esc_html__( 'ID', 'udetor' ),
                'type'             => 'textfield',
                'value'            => 1122334455,
                'edit_field_class' => 'hidden',
            ),
        )
    )
);