<?php
/**
 * Created by PhpStorm.
 * User: duongnth
 * Date: 7/6/2017
 * Time: 2:25 PM
 */

// Map new Banner element.
vc_map(
    array(
        'base'     => 'udetor_banner',
        'name'     => esc_html__( 'Banner', 'udetor' ),
        //'icon'   => 'fa fa-picture-o',
        'category' => esc_html__( 'Udetor Elements', 'udetor' ),
        'params'   => array(
            array(
                'param_name' => 'hover_effects',
                'heading'    => esc_html__( 'Hover Effect', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Effect 1', 'udetor' )  => 'style-1',
                    esc_html__( 'Effect 2', 'udetor' )  => 'style-2',
                    esc_html__( 'Effect 3', 'udetor' )  => 'style-3',
                    esc_html__( 'Effect 4', 'udetor' )  => 'style-4',
                    esc_html__( 'Effect 5', 'udetor' )  => 'style-5',
                    esc_html__( 'Effect 6', 'udetor' )  => 'style-6',
                    esc_html__( 'Effect 7', 'udetor' )  => 'style-7',
                    esc_html__( 'Effect 8', 'udetor' )  => 'style-8',
                    esc_html__( 'Effect 9', 'udetor' )  => 'style-9',
                    esc_html__( 'Effect 10', 'udetor' ) => 'style-10',
                    esc_html__( 'Effect 11', 'udetor' ) => 'style-11',
                    esc_html__( 'Effect 12', 'udetor' ) => 'style-12',
                    esc_html__( 'Effect 13', 'udetor' ) => 'style-13',
                ),
                'admin_label' => true,
            ),
            array(
                'param_name' => 'image',
                'heading'    => esc_html__( 'Image', 'udetor' ),
                'type'       => 'attach_image',
            ),
            array(
                'param_name' => 'image_alignment',
                'heading'    => esc_html__( 'Banner Alignment', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Left', 'udetor' )   => 'tl',
                    esc_html__( 'Center', 'udetor' ) => 'tc',
                    esc_html__( 'Right', 'udetor' )  => 'tr',
                ),
            ),
            array(
                'param_name' => 'image_content',
                'heading'    => esc_html__( 'Content Inside Banner', 'udetor' ),
                'type'       => 'dropdown',
                'value'      => array(
                    esc_html__( 'Image', 'udetor' ) => 'content_image',
                    esc_html__( 'Text', 'udetor' )  => 'content_text',
                ),
            ),
            array(
                'param_name' => 'image_inner',
                'heading'    => esc_html__( 'Inner Image', 'udetor' ),
                'type'       => 'attach_image',
                'dependency' => array(
                    'element' => 'image_content',
                    'value'   => 'content_image',
                ),
            ),
            array(
                'param_name' => 'text_heading',
                'heading'    => esc_html__( 'Heading Text', 'udetor' ),
                'type'       => 'textarea',
                'dependency' => array(
                    'element' => 'image_content',
                    'value'   => 'content_text',
                ),
            ),
            array(
                'param_name' => 'text_heading_size',
                'heading'    => esc_html__( 'Heading Font Size (Number Only)', 'udetor' ),
                'type'       => 'textfield',
                'dependency' => array(
                    'element' => 'image_content',
                    'value'   => 'content_text',
                ),
            ),
            array(
                'param_name' => 'text_description',
                'heading'    => esc_html__( 'Description Text', 'udetor' ),
                'type'       => 'textarea',
                'dependency' => array(
                    'element' => 'image_content',
                    'value'   => 'content_text',
                ),
            ),
            array(
                'param_name' => 'text_description_size',
                'heading'    => esc_html__( 'Description Font Size (Number Only)', 'udetor' ),
                'type'       => 'textfield',
                'dependency' => array(
                    'element' => 'image_content',
                    'value'   => 'content_text',
                ),
            ),
            array(
                'param_name' => 'text_color',
                'heading'    => esc_html__( 'Text Color', 'udetor' ),
                'type'       => 'colorpicker',
                'value'      => '#fff',
                'dependency' => array(
                    'element' => 'image_content',
                    'value'   => 'content_text',
                ),
            ),
            array(
                'param_name' => 'mask_color',
                'heading'    => esc_html__( 'Mask Color', 'udetor' ),
                'type'       => 'colorpicker',
                'value'      => 'rgba(0,0,0,.5)',
                'dependency' => array(
                    'element' => 'hover_effects',
                    'value'   => 'style-13',
                ),
            ),
            array(
                'param_name' => 'link',
                'heading'    => esc_html__( 'Link To', 'udetor' ),
                'type'       => 'textfield',
            ),
            array(
                'param_name'  => 'extra_class',
                'heading'     => esc_html__( 'Extra Class Name', 'udetor' ),
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'udetor' ),
                'type'        => 'textfield',
            ),
            array(
                'param_name'       => 'banner_custom_id',
                'heading'          => esc_html__( 'Hidden ID', 'udetor' ),
                'type'             => 'textfield',
                'value'            => 1122334455,
                'edit_field_class' => 'hidden',
            ),
        )
    )
);