<?php
/**
 * @version    1.0
 * @package    Udetor
 * @author     Your Team <support@yourdomain.com>
 * @copyright  Copyright (C) 2014 yourdomain.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 */
class Udetor_Start {
	/**
	 * Variable to hold the initialization state.
	 *
	 * @var  boolean
	 */
	protected static $initialized = false;

	/**
	 * Initialize functions.
	 *
	 * @return  void
	 */
	public static function initialize() {
		// Do nothing if pluggable functions already initialized.
		if ( self::$initialized ) {
			return;
		}

		/**
         * Vendors
		*/
        Udetor_Start_Visual_Composer::initialize();        
		
		/**
         * Build-in
		*/
        Udetor_Assets::initialize();
        Udetor_Editor_Format::initialize();
		Udetor_Sidebars::initialize();		
        Udetor_Content_Width::initialize();
        Udetor_Nav_Menus::initialize();
        Udetor_Custom_Header::initialize();
        Udetor_Template_Tags::initialize();
        Udetor_Helper::initialize();
        Udetor_Jetpack::initialize();
        Udetor_Post_Formats::initialize();
        Udetor_Thumbnails::initialize();
        Udetor_Metabox::initialize();
        Udetor_Customizer::initialize();
        Udetor_HeaderDesigner::initialize();
		Udetor_AdminSetup::initialize();
		Udetor_Template_Helper::initialize();
		Udetor_Modal::initialize();
		Udetor_Layout_Designer::initialize();
		Udetor_Notification::initialize();
		Udetor_MegaMenu_Manager::initialize();
		Udetor_After_Setup::initialize();
		Udetor_Posttype_Admin_Tabs::initialize();
		Udetor_Widgets::initialize();
		Udetor_Woocommerce::initialize();
		Udetor_Filter_Courses::initialize();
		
		// State that initialization completed.
		self::$initialized = true;
	}
}