<?php
/**
 * @version    1.0
 * @package    Udetor
 * @author     Your Team <support@yourdomain.com>
 * @copyright  Copyright (C) 2014 yourdomain.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 */

class Udetor_Sidebars {
    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;
    
    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize() {
        // Do nothing if start functions already initialized.
        if ( self::$initialized ) {
            return;
        }

        // Register actions to do something.
        add_action( 'widgets_init', array( __CLASS__, 'udetor_widgets_init' ) );
        
        // State that initialization completed.
        self::$initialized = true;
    }
    
    /**
     * Register widget area.
     *
     * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
     */
    public static function udetor_widgets_init() {
        register_sidebar( array(
            'name'          => esc_html__( 'Sidebar', 'udetor' ),
            'id'            => 'sidebar-1',
            'description'   => esc_html__( 'Add widgets here.', 'udetor' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        ) );

        register_sidebar( array(
            'name'          => esc_html__( 'Courses Sidebar', 'udetor' ),
            'id'            => 'sidebar-courses',
            'description'   => esc_html__( 'Add widgets here.', 'udetor' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        ) );
        
        register_sidebar( array(
            'name'          => esc_html__( 'Woocommer Sidebar', 'udetor' ),
            'id'            => 'sidebar-woo',
            'description'   => esc_html__( 'Add widgets here.', 'udetor' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        ) );

        register_sidebar( array(
            'name'          => esc_html__( 'Footer 1', 'udetor' ),
            'id'            => 'sidebar-footer-1',
            'description'   => esc_html__( 'Add widgets here.', 'udetor' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        ) );

        register_sidebar( array(
            'name'          => esc_html__( 'Footer 2', 'udetor' ),
            'id'            => 'sidebar-footer-2',
            'description'   => esc_html__( 'Add widgets here.', 'udetor' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        ) );
        register_sidebar( array(
            'name'          => esc_html__( 'Footer 3', 'udetor' ),
            'id'            => 'sidebar-footer-3',
            'description'   => esc_html__( 'Add widgets here.', 'udetor' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        ) );
        register_sidebar( array(
            'name'          => esc_html__( 'Footer 4', 'udetor' ),
            'id'            => 'sidebar-footer-4',
            'description'   => esc_html__( 'Add widgets here.', 'udetor' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        ) );

        register_sidebar( array(
            'name'          => esc_html__( 'Custom Footer 1', 'udetor' ),
            'id'            => 'sidebar-custom-footer1',
            'description'   => esc_html__( 'Add widgets here.', 'udetor' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        ) );
    }
}