<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Start Class

class Udetor_Posttype_Admin_Tabs
{

    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;


    /**
     * Start things up - Initialize
     *
     * @since 1.0.0
     */
    public static function initialize()
    {
        // Do nothing if pluggable functions already initialized.
        if (self::$initialized) {
            return;
        }

        // Hooks
        add_action('all_admin_notices', array(__CLASS__, 'udetor_admin_tabs'));

        // State that initialization completed.
        self::$initialized = true;
    }

    /**
     * Admin Tabs
     */
    public static function udetor_admin_tabs(){
        if ( ! is_admin() ) {
            return;
        }

        $admin_tabs = array(
            0 => array(
                'link'	=> 'post-new.php',
                'name'	=> _x( 'Add New', 'Add New Post', 'udetor' ),
                'id'	=> 'post',
                'menu_link'	=> 'post-new.php',
            ),
            10 => array(
                'link'	=> 'edit.php',
                'name'	=> _x( 'All Posts', 'Posts', 'udetor' ),
                'id'	=> 'edit-post',
                'menu_link'	=> 'edit.php',
            ),
            20 => array(
                'link'	=> 'edit-tags.php?taxonomy=category',
                'name'	=> _x( 'Categories', 'Categories', 'udetor' ),
                'id'	=> 'edit-category',
                'menu_link'	=> 'edit-tags.php?taxonomy=category',
            ),
            30 => array(
                'link'	=> 'edit-tags.php?taxonomy=post_tag',
                'name'	=> _x( 'Tags', 'Tags', 'udetor' ),
                'id'	=> 'edit-post_tag',
                'menu_link'	=> 'edit-tags.php?taxonomy=post_tag',
            ),
            40 => array(
                'link'	=> 'post-new.php?post_type=page',
                'name'	=> _x( 'Add New', 'Add New Page', 'udetor' ),
                'id'	=> 'page',
                'menu_link'	=> 'post-new.php?post_type=page',
            ),
            50 => array(
                'link'	=> 'edit.php?post_type=page',
                'name'	=> _x( 'All Pages', 'Pages', 'udetor' ),
                'id'	=> 'edit-page',
                'menu_link'	=> 'edit.php?post_type=page',
            ),
            60 => array(
                'link'	=> 'upload.php',
                'name'	=> _x( 'Media Library', 'Library', 'udetor' ),
                'id'	=> 'upload',
                'menu_link'	=> 'upload.php',
            ),
            70 => array(
                'link'	=> 'media-new.php',
                'name'	=> _x( 'Upload', 'Add New', 'udetor' ),
                'id'	=> 'media',
                'menu_link'	=> 'media-new.php',
            ),
            80 => array(
                'link'	=> 'edit.php?post_type=netbase-faq',
                'name'	=> _x( 'FAQs', 'All FAQs', 'udetor' ),
                'id'	=> 'edit-netbase-faq',
                'menu_link'	=> 'edit.php?post_type=netbase-faq',
            ),
            90 => array(
                'link'	=> 'post-new.php?post_type=netbase-faq',
                'name'	=> _x( 'Add New FAQ', 'Add New', 'udetor' ),
                'id'	=> 'netbase-faq',
                'menu_link'	=> 'post-new.php?post_type=netbase-faq',
            ),
            100 => array(
                'link'	=> 'edit-tags.php?taxonomy=faq_cat&post_type=netbase-faq',
                'name'	=> _x( 'FAQ Categories', 'Categories', 'udetor' ),
                'id'	=> 'edit-faq_cat',
                'menu_link'	=> 'edit-tags.php?taxonomy=faq_cat&post_type=netbase-faq',
            ),
            110 => array(
                'link'	=> 'edit-tags.php?taxonomy=faq_tag&post_type=netbase-faq',
                'name'	=> _x( 'Tags', 'Tags', 'udetor' ),
                'id'	=> 'edit-faq_tag',
                'menu_link'	=> 'edit-tags.php?taxonomy=faq_tag&post_type=netbase-faq',
            ),
            120 => array(
                'link'	=> 'edit.php?post_type=netbase-gallery',
                'name'	=> _x( 'Gallery', 'All Gallery', 'udetor' ),
                'id'	=> 'edit-netbase-gallery',
                'menu_link'	=> 'edit.php?post_type=netbase-gallery',
            ),
            130 => array(
                'link'	=> 'post-new.php?post_type=netbase-gallery',
                'name'	=> _x( 'Add New Gallery', 'Add New', 'udetor' ),
                'id'	=> 'netbase-gallery',
                'menu_link'	=> 'post-new.php?post_type=netbase-gallery',
            ),
            140 => array(
                'link'	=> 'edit-tags.php?taxonomy=gallery_cat&post_type=netbase-gallery',
                'name'	=> _x( 'Gallery Categories', 'Categories', 'udetor' ),
                'id'	=> 'edit-gallery_cat',
                'menu_link'	=> 'edit-tags.php?taxonomy=gallery_cat&post_type=netbase-gallery',
            ),
            150 => array(
                'link'	=> 'edit-tags.php?taxonomy=gallery_tag&post_type=netbase-gallery',
                'name'	=> _x( 'Tags', 'Tags', 'udetor' ),
                'id'	=> 'edit-gallery_tag',
                'menu_link'	=> 'edit-tags.php?taxonomy=gallery_tag&post_type=netbase-gallery',
            ),
            160 => array(
                'link'	=> 'edit.php?post_type=netbase-portfolio',
                'name'	=> _x( 'Portfolio', 'All Portfolio', 'udetor' ),
                'id'	=> 'edit-netbase-portfolio',
                'menu_link'	=> 'edit.php?post_type=netbase-portfolio',
            ),
            170 => array(
                'link'	=> 'post-new.php?post_type=netbase-portfolio',
                'name'	=> _x( 'Add New Portfolio', 'Add New', 'udetor' ),
                'id'	=> 'netbase-portfolio',
                'menu_link'	=> 'post-new.php?post_type=netbase-portfolio',
            ),
            180 => array(
                'link'	=> 'edit-tags.php?taxonomy=portfolio_cat&post_type=netbase-portfolio',
                'name'	=> _x( 'Portfolio Categories', 'Categories', 'udetor' ),
                'id'	=> 'edit-portfolio_cat',
                'menu_link'	=> 'edit-tags.php?taxonomy=portfolio_cat&post_type=netbase-portfolio',
            ),
            190 => array(
                'link'	=> 'edit-tags.php?taxonomy=portfolio_tag&post_type=netbase-portfolio',
                'name'	=> _x( 'Tags', 'Tags', 'udetor' ),
                'id'	=> 'edit-portfolio_tag',
                'menu_link'	=> 'edit-tags.php?taxonomy=portfolio_tag&post_type=netbase-portfolio',
            ),
            200 => array(
                'link'	=> 'edit.php?post_type=netbase-team',
                'name'	=> _x( 'Team', 'All Team', 'udetor' ),
                'id'	=> 'edit-netbase-team',
                'menu_link'	=> 'edit.php?post_type=netbase-team',
            ),
            210 => array(
                'link'	=> 'post-new.php?post_type=netbase-team',
                'name'	=> _x( 'Add New Team', 'Add New', 'udetor' ),
                'id'	=> 'netbase-team',
                'menu_link'	=> 'post-new.php?post_type=netbase-team',
            ),
            220 => array(
                'link'	=> 'edit-tags.php?taxonomy=team_cat&post_type=netbase-team',
                'name'	=> _x( 'Team Categories', 'Categories', 'udetor' ),
                'id'	=> 'edit-team_cat',
                'menu_link'	=> 'edit-tags.php?taxonomy=team_cat&post_type=netbase-team',
            ),
            230 => array(
                'link'	=> 'edit-tags.php?taxonomy=team_tag&post_type=netbase-team',
                'name'	=> _x( 'Tags', 'Tags', 'udetor' ),
                'id'	=> 'edit-team_tag',
                'menu_link'	=> 'edit-tags.php?taxonomy=team_tag&post_type=netbase-team',
            ),
            240 => array(
                'link'	=> 'edit.php?post_type=netbase-testimonial',
                'name'	=> _x( 'Testimonial', 'All Testimonial', 'udetor' ),
                'id'	=> 'edit-netbase-testimonial',
                'menu_link'	=> 'edit.php?post_type=netbase-testimonial',
            ),
            250 => array(
                'link'	=> 'post-new.php?post_type=netbase-testimonial',
                'name'	=> _x( 'Add New Testimonial', 'Add New', 'udetor' ),
                'id'	=> 'netbase-testimonial',
                'menu_link'	=> 'post-new.php?post_type=netbase-testimonial',
            ),
            260 => array(
                'link'	=> 'edit-tags.php?taxonomy=testimonial_cat&post_type=netbase-testimonial',
                'name'	=> _x( 'Testimonial Categories', 'Categories', 'udetor' ),
                'id'	=> 'edit-testimonial_cat',
                'menu_link'	=> 'edit-tags.php?taxonomy=testimonial_cat&post_type=netbase-testimonial',
            ),
            270 => array(
                'link'	=> 'edit-tags.php?taxonomy=testimonial_tag&post_type=netbase-testimonial',
                'name'	=> _x( 'Tags', 'Tags', 'udetor' ),
                'id'	=> 'edit-testimonial_tag',
                'menu_link'	=> 'edit-tags.php?taxonomy=testimonial_tag&post_type=netbase-testimonial',
            ),
            280 => array(
                'link'	=> 'edit.php?post_type=page_header',
                'name'	=> _x( 'Page Header', 'All Page Header', 'udetor' ),
                'id'	=> 'edit-page_header',
                'menu_link'	=> 'edit.php?post_type=page_header',
            ),
            290 => array(
                'link'	=> 'post-new.php?post_type=page_header',
                'name'	=> _x( 'Add New Page Header', 'Add New', 'udetor' ),
                'id'	=> 'page_header',
                'menu_link'	=> 'post-new.php?post_type=page_header',
            ),
            300 => array(
                'link'	=> 'users.php',
                'name'	=> _x( 'All Users', 'All Users', 'udetor' ),
                'id'	=> 'users',
                'menu_link'	=> 'users.php',
            ),
            310 => array(
                'link'	=> 'user-new.php',
                'name'	=> _x( 'Add New User', 'Add New', 'udetor' ),
                'id'	=> 'user',
                'menu_link'	=> 'user-new.php',
            ),
            320 => array(
                'link'	=> 'profile.php',
                'name'	=> _x( 'Your Profile', 'Your Profile', 'udetor' ),
                'id'	=> 'profile',
                'menu_link'	=> 'user-new.php',
            ),
            330 => array(
                'link'	=> 'edit.php?post_type=sfwd-assignment',
                'name'	=> _x( 'Assignments', 'Assignments', 'udetor' ),
                'id'	=> 'edit-sfwd-assignment',
                'menu_link'	=> 'edit.php?post_type=sfwd-assignment',
            ),
            340 => array(
                'link'	=> 'edit.php?post_type=ld-notification',
                'name'	=> _x( 'Notifications', 'Notifications', 'udetor' ),
                'id'	=> 'edit-ld-notification',
                'menu_link'	=> 'edit.php?post_type=ld-notification',
            ),
            350 => array(
                'link'	=> 'edit.php?post_type=groups',
                'name'	=> _x( 'LearnDash Groups', 'Groups', 'udetor' ),
                'id'	=> 'edit-groups',
                'menu_link'	=> 'edit.php?post_type=groups',
            ),
            360 => array(
                'link'	=> 'post-new.php?post_type=ld-notification',
                'name'	=> _x( 'Add New Notification', 'Add New Notification', 'udetor' ),
                'id'	=> 'ld-notification',
                'menu_link'	=> 'post-new.php?post_type=ld-notification',
            ),
            370 => array(
                'link'	=> 'post-new.php?post_type=groups',
                'name'	=> _x( 'Add New LearnDash Group', 'Add New LearnDash Group', 'udetor' ),
                'id'	=> 'groups',
                'menu_link'	=> 'post-new.php?post_type=groups',
            ),
        );

        foreach ( $admin_tabs as $key => $admin_tab ) {
            if ( ! empty( $admin_tab['cap'] ) ) {
                if ( ! current_user_can( $admin_tab['cap'] ) ) {
                    unset( $admin_tabs[ $key ] );
                }
            }
        }

        $admin_tabs_on_page = array(
            'post'	=> array( 0, 10, 20, 30 ),
            'edit-post'	=> array( 0, 10, 20, 30 ),
            'edit-category'	=> array( 0, 10, 20, 30 ),
            'edit-post_tag'	=> array( 0, 10, 20, 30 ),
            'page'	=> array( 40, 50 ),
            'edit-page'	=> array( 40, 50 ),
            'upload'	=> array( 60, 70 ),
            'media'	=> array( 60, 70 ),
            'edit-faq_tag'	=> array( 80, 90, 100, 110 ),
            'edit-faq_cat'	=> array( 80, 90, 100, 110 ),
            'netbase-faq'	=> array( 80, 90, 100, 110 ),
            'edit-netbase-faq'	=> array( 80, 90, 100, 110 ),
            'edit-gallery_tag'	=> array( 120, 130, 140, 150 ),
            'edit-gallery_cat'	=> array( 120, 130, 140, 150 ),
            'netbase-gallery'	=> array( 120, 130, 140, 150 ),
            'edit-netbase-gallery'	=> array( 120, 130, 140, 190 ),
            'edit-portfolio_tag'	=> array( 160, 170, 180, 190 ),
            'edit-portfolio_cat'	=> array( 160, 170, 180, 190 ),
            'netbase-portfolio'	=> array( 160, 170, 180, 190 ),
            'edit-netbase-portfolio'	=> array( 160, 170, 180, 190 ),
            'edit-team_tag'	=> array( 200, 210, 220, 230 ),
            'edit-team_cat'	=> array( 200, 210, 220, 230 ),
            'netbase-team'	=> array( 200, 210, 220, 230 ),
            'edit-netbase-team'	=> array( 200, 210, 220, 230 ),
            'edit-testimonial_tag'	=> array( 240, 250, 260, 270 ),
            'edit-testimonial_cat'	=> array( 240, 250, 260, 270 ),
            'netbase-testimonial'	=> array( 240, 250, 260, 270 ),
            'edit-netbase-testimonial'	=> array( 240, 250, 260, 270 ),
            'page_header'	=> array( 280, 290 ),
            'edit-page_header'	=> array( 280, 290 ),
            'users'	=> array( 300, 310, 320 ),
            'user'	=> array( 300, 310, 320 ),
            'profile'	=> array( 300, 310, 320 ),
            'edit-sfwd-assignment'	=> array( 330, 340, 350 ),
            'edit-ld-notification'	=> array( 330, 340, 350, 360 ),
            'ld-notification'	=> array( 330, 340, 350, 360 ),
            'edit-groups'	=> array( 330, 340, 350, 370 ),
            'groups'	=> array( 330, 340, 350, 370 ),
        );

        if ( isset( $_GET['post_type'] ) && $_GET['post_type'] == 'post'  ) {
            $admin_tabs_on_page['edit-category'] = array( 0, 10, 20, 30 );
            $admin_tabs_on_page['edit-post_tag'] = array( 0, 10, 20, 30 );
        }

        // Not show on courses because that have
        if ( isset( $_GET['post_type'] ) && $_GET['post_type'] == 'sfwd-courses' ) {
            $admin_tabs_on_page['edit-category'] = array();
            $admin_tabs_on_page['edit-post_tag'] = array();
        }

        $current_page_id = get_current_screen()->id;
        
        $post_id = ! empty( $_GET['post_id'] ) ? $_GET['post_id'] : ( empty( $_GET['post'] ) ? 0 : $_GET['post'] );

        if ( empty( $admin_tabs_on_page[ $current_page_id ] ) ) {
            $admin_tabs_on_page[ $current_page_id ] = array();
        }

        if ( ! empty( $post_id ) ) {
            foreach ( $admin_tabs_on_page[ $current_page_id ] as $admin_tab_id ) {
                $admin_tabs[ $admin_tab_id ]['link'] = str_replace( '[post_id]', $post_id, $admin_tabs[ $admin_tab_id ]['link'] );
            }
        }

        if ( ! empty( $admin_tabs_on_page[ $current_page_id ] ) && count( $admin_tabs_on_page[ $current_page_id ] ) ) {
            echo '<h1 class="nav-tab-wrapper">';
            $tabid = 0;
            foreach ( $admin_tabs_on_page[ $current_page_id] as $admin_tab_id ) {
                if ( ! empty( $admin_tabs[ $admin_tab_id ]['id'] ) ) {
                    $class = ( $admin_tabs[ $admin_tab_id ]['id'] == $current_page_id ) ? 'nav-tab nav-tab-active' : 'nav-tab';
                    $url = ! empty( $admin_tabs[ $admin_tab_id ]['external_link'] ) ? $admin_tabs[ $admin_tab_id ]['external_link'] : admin_url( $admin_tabs[ $admin_tab_id ]['link'] );
                    $target = ! empty( $admin_tabs[ $admin_tab_id ]['target'] ) ? 'target="'.$admin_tabs[ $admin_tab_id ]['target'].'"':'';
                    echo '<a href="'.$url.'" class="'.$class.' nav-tab-'.$admin_tabs[ $admin_tab_id ]['id'].'"  '.$target.'>'.$admin_tabs[ $admin_tab_id ]['name'].'</a>';
                }
            }
            echo '</h1>';
        }


    }
}