<?php
/**
 * @version    1.0
 * @package    Udetor
 * @author     Your Team <support@yourdomain.com>
 * @copyright  Copyright (C) 2014 yourdomain.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 */

/**
 * Plug additional menu registration into Admin.
 *
 * @package  Udetor
 * @since    1.0
 */
class Udetor_Nav_Menus {
    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;
    
    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize() {
        // Do nothing if start functions already initialized.
        if ( self::$initialized ) {
            return;
        }
        
        // Register actions to do something.
        add_action( 'after_setup_theme', array( __CLASS__, 'udetor_menu_locations' ) );
        
        // State that initialization completed.
        self::$initialized = true;
    }
    
    /**
     * Register admin menu locations.
     * This theme uses wp_nav_menu() in one location.
     */
    public static function udetor_menu_locations() {
        register_nav_menus( array(
            'main-menu' => esc_html__( 'Primary', 'udetor' ),
            'footer-menu' => esc_html__( 'Footer', 'udetor' ),
        ) );
    }
   
}