<?php

/**
 * Class Udetor_Modal.
 *
 * @since 0.9.0
 */
class Udetor_Modal {

    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;

    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize() {
        // Do nothing if start functions already initialized.
        if ( self::$initialized ) {
            return;
        }

        // Register actions to do something.
        add_action( 'admin_footer', array( __CLASS__, 'add_iframe_template' ) );
        add_action( 'admin_enqueue_scripts', array( __CLASS__, 'enqueue_scripts' ) );
        add_action( 'admin_footer', array( __CLASS__, 'register_modal_place' ) );

        // State that initialization completed.
        self::$initialized = true;
    }

	/**
	 * Register modal place.
	 *
	 * @since 1.3.4
	 */
	public static function register_modal_place() {
		?>
        <div class="udetor-modals-wrapper">
			<?php
			do_action( 'udetor_core_list_modals' );
			?>
        </div>
		<?php
	}

	/**
	 * Enqueue scripts.
	 *
	 * @since 0.9.1
	 */
	public static function enqueue_scripts() {
        wp_enqueue_script( 'udetor-modal', Udetor_Assets::get_js_url() . 'admin/modal.js', array( 'jquery', 'backbone' ),Udetor_Core::VERSION, true );
	}

	/**
	 * Add iframe template.
	 *
	 * @since 0.9.0
	 */
	public static function add_iframe_template() {
		Udetor_Template_Helper::template( 'modals/iframe.php', array(), true );
	}

	/**
	 * Add modal.
	 *
	 * @since 0.9.0
	 *
	 * @param array $args
	 *
	 * @return bool
	 */
	public static function render_modal( $args ) {
		$args = wp_parse_args( $args, array(
			'template' => '',
			'id'       => '',
		) );

		$html = Udetor_Template_Helper::template( $args['template'], $args );
		if ( ! $html ) {
			return false;
		}
		$args['html'] = $html;

		return Udetor_Template_Helper::template( 'modals/master.php', $args, true );
	}

	/**
	 * Enqueue script udetor modal. You need call this function if you want to add modal.
	 *
	 * @since 0.9.0
	 */
	public static function enqueue_modal() {
		wp_enqueue_script( 'udetor-modal' );
	}
}