<?php
/**
 * @version    1.0
 * @package    Udetor
 * @author     Your Team <support@yourdomain.com>
 * @copyright  Copyright (C) 2014 yourdomain.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 */

/**
 * Plug additional sidebars into Admin.
 *
 * @package  Udetor
 * @since    1.0
 */
class Udetor_Metabox
{
    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;

    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Do nothing if start functions already initialized.
        if (self::$initialized) {
            return;
        }

        // Load all addon for ACF
        self::load_all_addons();

        // Load all settings
        self::load_all_files();

        // State that initialization completed.
        self::$initialized = true;
    }

    /**
     * Load all meta box settings.
     *
     * @return void
     */
    public static function load_all_files()
    {
        $files = glob(Udetor_Core::get_core_path() . 'metabox/settings/*.php');
        foreach ($files as $filename) {
            if (file_exists($filename)) {
                include_once $filename;
            }
        }
    }

    /**
     * Load add ACF addons
     * @return void
     */
    public static function load_all_addons()
    {

        // Using ACF
        $udetor_acf_files = array(
            Udetor_Core::get_core_path() . 'metabox/addons/acf-sidebar-selector/acf-sidebar_selector.php',                // Sidebar Selector Field
            Udetor_Core::get_core_path() . 'metabox/addons/acf-image-select/acf-image-select.php',                        // Image Select Field
            Udetor_Core::get_core_path() . 'metabox/addons/advanced-custom-fields-nav-menu/fz-acf-nav-menu.php',          // Nav Menu Selector Field
        );

        foreach ($udetor_acf_files as $file) {
            require $file;                                            // loading acf extensions
        }

    }


}