<?php
/**
 * Plug additional sidebars into Admin.
 *
 * @package  Udetor
 * @since    1.0
 */
class Udetor_Megamenu {
    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;
    
    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize() {
        // Do nothing if start functions already initialized.
        if (self::$initialized) {
            return;
        }
        
        // Load Mega Menu
	    self::load_megamenu();
        
        // State that initialization completed.
        self::$initialized = true;
    }
	
	/**
	 * Load megamenu libs.
	 *
	 * @return void
	 */
	public static function load_megamenu() {

		$filename = Udetor_Core::get_libs_path() . 'nb-mega-menu/nb-mega-menu.php';
		if( file_exists( $filename ) ) {
			include_once $filename;
		}
	}
 
}