<?php
/**
 * @version    1.0
 * @package    Udetor
 * @author     Your Team <support@yourdomain.com>
 * @copyright  Copyright (C) 2014 yourdomain.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 */

/**
 * Jetpack Compatibility File
 *
 * @link https://jetpack.com/
 *
 * @package  Udetor
 * @since    1.0
 */
class Udetor_Jetpack {
    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;
    
    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize() {
        // Do nothing if start functions already initialized.
        if ( self::$initialized ) {
            return;
        }
        
        // Register actions to do something.
        add_action( 'after_setup_theme', array( __CLASS__, 'udetor_jetpack_setup' ) );
        
        // State that initialization completed.
        self::$initialized = true;
    }
    
    /**
     * Jetpack setup function.
     *
     * See: https://jetpack.com/support/infinite-scroll/
     * See: https://jetpack.com/support/responsive-videos/
     */
    public static function udetor_jetpack_setup() {
        // Add theme support for Infinite Scroll.
        add_theme_support( 'infinite-scroll', array(
            'container' => 'main',
            'render'    => array(__CLASS__, 'udetor_infinite_scroll_render'),
            'footer'    => 'page',
        ) );
        
        // Add theme support for Responsive Videos.
        add_theme_support( 'jetpack-responsive-videos' );
    }

    
    /**
     * Custom render function for Infinite Scroll.
     */
    public static function udetor_infinite_scroll_render() {
        while ( have_posts() ) {
            the_post();
            if ( is_search() ) :
                get_template_part( 'template-parts/content', 'search' );
            else :
                get_template_part( 'template-parts/content', get_post_format() );
            endif;
        }
    }

}