<?php
class Udetor_Editor_Format{

    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;


    /* Main editor format menu */
    private static $eformat_menu;

    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Do nothing if pluggable functions already initialized.
        if (self::$initialized) {
            return;
        }        

        // Load editor configs
        self::$eformat_menu = self::get_eformat_menus();

        // Attach editor styles into Admin WordPress.
        add_action( 'admin_init', array( __CLASS__, 'editor_custom_styles' ) );

        // Load Toolbar Menus
        add_filter('tiny_mce_before_init', array(__CLASS__, 'mce_before_init_insert_formats' ));
        add_filter( 'tiny_mce_before_init', array(__CLASS__,'inline_customize_text_sizes' ));
        add_filter('mce_buttons_2', array(__CLASS__,'mce_buttons_2'));
        add_filter( 'mce_buttons_2', array(__CLASS__,'inline_mce_buttons' ));

        // State that initialization completed.
        self::$initialized = true;
    }


    /*-------------------------------------------------------------------------------*/
    /* [ TinyMCE Inline ]
    /*-------------------------------------------------------------------------------*/

    /**
     * Enable font size buttons in the editor
     *
     * @since 1.0.0
     */

    static function inline_mce_buttons( $buttons ) {
        array_unshift( $buttons, 'fontselect' );
        array_unshift( $buttons, 'fontsizeselect' );
        return $buttons;
    }

    /**
     * Enable TinyMCE font sizes
     *
     * @since 1.0.0
     */
    static function inline_customize_text_sizes( $initArray ){
        $initArray['fontsize_formats'] = "9px 10px 12px 13px 14px 16px 18px 21px 24px 28px 32px 36px";
        return $initArray;
    }

    /*-------------------------------------------------------------------------------*/
    /* [ TinyMCE Classes ]
    /*-------------------------------------------------------------------------------*/

    /* Add Styles to Dropdown */
    static function mce_before_init_insert_formats( $init_array ) {
        $style_formats = self::$eformat_menu;
        $init_array['style_formats'] = json_encode( $style_formats );
        return $init_array;
    }

    /* Add to MCE */
    static function mce_buttons_2($buttons) {
        array_unshift($buttons, 'styleselect');
        return $buttons;
    }

    /**
     * Get array of config editor style configs
     *
     * @return array;
     *
     */
    static public function get_eformat_menus(){
        $format_menu = array();

        // get $format_menu from config files
        foreach (glob(Udetor_Core::get_core_templates_path() . 'editor_format/*.php') as $filename){
            include_once $filename;
        }

        return $format_menu;
    }

    // Add custom style to editor
    public static function editor_custom_styles() {
        add_editor_style( Udetor_Assets::get_css_url() . 'admin/eformat.css' );
    }

}