<?php
/**
 * Add the layout section
 */

$priority = 60;
Kirki::add_panel( 'udetor_panel_woo', array(
    'priority'    => $priority++,
    'title'       => esc_html__( 'WC Shop', 'udetor' ),
    'description' => esc_html__( 'Shop WooCommerce', 'udetor' ),
) );

/**
 * Add the Woocommerce List section
 */
Kirki::add_section( 'udetor_section_woo_general', array(
    'title'      => esc_attr__( 'Product General', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_woo',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_woo_general_show_page_title',
    'label'       => esc_html__( 'Show Page Title', 'udetor' ),
    'section'     => 'udetor_section_woo_general',
    'default'     => '1',
    'priority'    => $priority++,
) );
Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_woo_general_hidden_breadcrumb',
    'label'       => esc_html__( 'Hidden Breadcrumb', 'udetor' ),
    'section'     => 'udetor_section_woo_general',
    'default'     => '0',
    'priority'    => $priority++,
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_woo_general_show_page_title',
            'operator' => '==',
            'value'    => '1',
        ),
    )
) );
Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_woo_general_header_trans',
    'label'       => esc_html__( 'Header transparent', 'udetor' ),
    'section'     => 'udetor_section_woo_general',
    'default'     => '1',
    'priority'    => $priority++,
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_woo_general_show_page_title',
            'operator' => '==',
            'value'    => '1',
        ),
    )
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'image',
    'settings'    => 'udetor_woo_general_headerbg_img',
    'label'       => esc_html__( 'Page Title Background Image', 'udetor' ),        
    'section'     => 'udetor_section_woo_general',
    'default'     => '',
    'priority'   => $priority++,
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_woo_general_show_page_title',
            'operator' => '==',
            'value'    => '1',
        ),
    )
) );
Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_woo_general_pagetitle_color',
    'label'       => esc_html__( 'Page Title Color', 'udetor' ),
    'section'     => 'udetor_section_woo_general',
    'default'     => '#ffffff',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
            
            array(
                'element' => '.woocommerce .udetor-page-title .udetor-breadcrumbs li,.woocommerce .udetor-page-title h1,.woocommerce .udetor-page-title .udetor-breadcrumbs li a',
                'property' => 'color',
            ),
           
        ),
    
    
) );
/*
Kirki::add_field( 'udetor_config', array(
    'type'     => 'text',
    'settings' => 'udetor_woo_general_page_title_content',
    'label'    => esc_html__( 'Page Title Content', 'udetor' ),
    'section'  => 'udetor_section_woo_general',
    'default'  => '',
    'priority' => $priority++,
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_woo_general_show_page_title',
            'operator' => '==',
            'value'    => '1',
        ),
    )
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_woo_general_show_breadcrumb',
    'label'       => esc_html__( 'Show Breadcrumb?', 'udetor' ),
    'section'     => 'udetor_section_woo_general',
    'default'     => '1',
    'priority'    => $priority++,
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_woo_general_show_page_title',
            'operator' => '==',
            'value'    => '1',
        ),
    )
) );*/
/**
 * Add the Woocommerce List section
 */
Kirki::add_section( 'udetor_section_woo_archive', array(
    'title'      => esc_attr__( 'Product Category', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_woo',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-image',
    'settings'    => 'udetor_woo_archive_layout',
    'label'       => esc_html__( 'Layouts', 'udetor' ),
    'section'     => 'udetor_section_woo_archive',
    'default'     => 'right-sidebar',
    'priority'    => $priority++,
    'choices'     => array(
        'right-sidebar'   => get_template_directory_uri() . '/assets/udetor/images/admin/layout/sidebar-right.svg',
        'left-sidebar'   => get_template_directory_uri() . '/assets/udetor/images/admin/layout/sidebar-left.svg',
        'no-sidebar'   => get_template_directory_uri() . '/assets/udetor/images/admin/layout/body-full.svg',
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'select',
    'settings'    => 'udetor_woo_archive_grid_columns',
    'label'       => esc_html__( 'Grid Columns', 'udetor' ),
    'section'     => 'udetor_section_woo_archive',
    'default'     => 'three-columns',
    'priority'    => $priority++,
    'multiple'    => 1,
    'choices'     => array(        
        'two-columns' => esc_attr__( '2', 'udetor' ),
        'three-columns' => esc_attr__( '3', 'udetor' ),      
        'four-columns' => esc_attr__( '4', 'udetor' ),   
    ),
) );
/*
Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_woo_archive_show_wishlist',
    'label'       => esc_html__( 'Show Wishlist Button?', 'udetor' ),
    'section'     => 'udetor_section_woo_archive',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_woo_archive_show_quick_view ',
    'label'       => esc_html__( 'Show Quick View Button?', 'udetor' ),
    'section'     => 'udetor_section_woo_archive',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_woo_archive_show_addtocart',
    'label'       => esc_html__( 'Show Add To Cart Button?', 'udetor' ),
    'section'     => 'udetor_section_woo_archive',
    'default'     => '1',
    'priority'    => $priority++,
) );*/

/*Kirki::add_field( 'udetor_config', array(
    'type'        => 'select',
    'settings'    => 'udetor_woo_archive_item_hover_effect',
    'label'       => esc_html__( 'Images Hover Effect', 'udetor' ),
    'section'     => 'udetor_section_woo_archive',
    'default'     => '2',
    'priority'    => $priority++,
    'multiple'    => 1,
    'choices'     => array(
        '1' => esc_attr__( 'None', 'udetor' ),
        '2' => esc_attr__( 'Zoom In', 'udetor' ),                     
    ),
) );*/

/**
 * Add the Woocommerce Detail section
 */
Kirki::add_section( 'udetor_section_woo_detail', array(
    'title'      => esc_attr__( 'Product Detail', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_woo',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-image',
    'settings'    => 'udetor_woo_detail_layout',
    'label'       => esc_html__( 'Layouts', 'udetor' ),
    'section'     => 'udetor_section_woo_detail',
    'default'     => 'right-sidebar',
    'priority'    => $priority++,
    'choices'     => array(
        'right-sidebar'   => get_template_directory_uri() . '/assets/udetor/images/admin/layout/sidebar-right.svg',
        'left-sidebar'   => get_template_directory_uri() . '/assets/udetor/images/admin/layout/sidebar-left.svg',
        'no-sidebar'   => get_template_directory_uri() . '/assets/udetor/images/admin/layout/body-full.svg',
    ),
    
) );
/*
Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-image',
    'settings'    => 'udetor_woo_detail_layout_tab_extra',
    'label'       => esc_html__( 'Layout of Tabs Extra', 'udetor' ),
    'section'     => 'udetor_section_woo_detail',
    'default'     => 'tabs-vertical',
    'priority'    => $priority++,
    'choices'     => array(
        'tabs-vertical'   => get_template_directory_uri() . '/assets/udetor/images/admin/tab/tab_tab_1.svg',
        'tabs-horizontal' => get_template_directory_uri() . '/assets/udetor/images/admin/tab/tab_tab_2.svg',
        'full-content'  => get_template_directory_uri() . '/assets/udetor/images/admin/tab/tab_tab_3.svg',
    ),
    
) );*/
