<?php
/**
 * Add the typography section
 */

$priority = 35;

Kirki::add_panel( 'udetor_panel_typography', array(
    'priority'    => $priority++,
    'title'       => esc_html__( 'Typography', 'udetor' ),
    'description' => esc_html__( 'typography', 'udetor' ),
) );

/**
 * Add the Typography General control
 */

Kirki::add_section( 'udetor_section_typography_general', array(
    'title'      => esc_attr__( 'General', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_typography',
) );

Kirki::add_field( 'udetor_config', array(
	'type'        => 'custom',
	'settings'    => 'udetor_typography_heading1',
	'label'       => '',
	'section'     => 'udetor_section_typography_general',
	'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Body Font', 'udetor' ) . '</div>',
	'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom-typography',
    'settings'    => 'udetor_body_font_type',
    'label'       => esc_html__( 'Body Font Type', 'udetor' ),
    'section'     => 'udetor_section_typography_general',    
    'priority'    => $priority++,   
    
) );


Kirki::add_field( 'udetor_config', array(
	'type'        => 'typography',
	'settings'    => 'udetor_body_typography_font_family',
	'label'       => esc_attr__( 'Body Font Family', 'udetor' ),
	'description' => esc_attr__( 'Select the main typography options for your site.', 'udetor' ),	
	'section'     => 'udetor_section_typography_general',
    'priority'    => $priority++,
	'default'     => array(
		'font-family'    => 'Raleway',		
	),
	'output' => array(
		array(
			'element' => 'body,button, input, optgroup, select, textarea,.tt_tabs_navigation li a',
		),
	),
	'active_callback'  => array(        
        array(
            'setting'  => 'udetor_body_font_type',
            'operator' => '==',
            'value'    => 'select-google-font',
        ),
    )
) );


Kirki::add_field( 'udetor_config', array(
	'type'        => 'typography',
	'settings'    => 'udetor_body_typography',
	'label'       => esc_attr__( 'Body Typography', 'udetor' ),
	'description' => esc_attr__( 'Select the main typography options for your site.', 'udetor' ),	
	'section'     => 'udetor_section_typography_general',
    'priority'   => $priority++,
	'default'     => array(
		'variant'        => '400',
		'font-size'      => '14px',
		'line-height'    => '1.5',		
		'color'          => '#333333',
	),
	'output' => array(
		array(
			'element' => 'body',
		),
	),
	
) );


Kirki::add_field( 'udetor_config', array(
	'type'        => 'custom',
	'settings'    => 'udetor_typography_heading2',
	'label'       => '',
	'section'     => 'udetor_section_typography_general',
	'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Headings Font', 'udetor' ) . '</div>',
	'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom-typography',
    'settings'    => 'udetor_heading_font_type',
    'label'       => esc_html__( 'Heading Font Type (H1, H2)', 'udetor' ),
    'section'     => 'udetor_section_typography_general',    
    'priority'    => $priority++,    
    
) );


Kirki::add_field( 'udetor_config', array(
	'type'        => 'typography',
	'settings'    => 'udetor_heading_content_font',
	'label'       => esc_attr__( 'H1, H2 Font Family', 'udetor' ),	
	'section'     => 'udetor_section_typography_general',
    'priority'   => $priority++,
	'default'     => array(
		'font-family'    => 'Bitter',		
	),
	'output' => array(
		array(
			'element' => 'h1,h2,.sidebar-detail-event .espresso-venue-dv strong,.sidebar-detail-event span,.widget-lst-title,#reply-title, .relatedposts-title,.udetor-event-meta .left-meta-event,.udetor-date-event, .education-event-header .education-event-time-countdown .education-time-countdown>div>span, .sidebar-title, .font-h1, #learndash_lessons a.font-h1, .main-footer .widget_nav_menu ul li a,.dropcap,.course-single-payment .nbt-date-price,.woocommerce-tabs ul.tabs li a,.woocommerce .product p.price, .woocommerce .product span.price,.udetor-page-cart thead th,.woocommerce table.shop_table.wishlist_table thead th,.fitness-classes-timetable table.tt_timetable tbody tr td .event_container .before_hour_text',
		),
	),
	
	'active_callback'  => array(        
        array(
            'setting'  => 'udetor_heading_font_type',
            'operator' => '==',
            'value'    => 'select-google-font',
        ),
    )
) );



Kirki::add_field( 'udetor_config', array(
	'type'        => 'typography',
	'settings'    => 'udetor_heading_1',
	'label'       => esc_attr__( 'Heading 1', 'udetor' ),
	'description' => esc_attr__( 'Select the main typography options for your site.', 'udetor' ),
	'section'     => 'udetor_section_typography_general',
    'priority'   => $priority++,
	'default'     => array(
		'font-size'      => '46px',
		'line-height'    => '1.5',		
		'color'          => '#333333',
		'text-transform'=>'none',
	),
	'output' => array(
		array(
			'element' => 'h1',
		),
	),	
	
) );

Kirki::add_field( 'udetor_config', array(
	'type'        => 'typography',
	'settings'    => 'udetor_heading_2',
	'label'       => esc_attr__( 'Heading 2', 'udetor' ),
	'description' => esc_attr__( 'Select the main typography options for your site.', 'udetor' ),
	'section'     => 'udetor_section_typography_general',
    'priority'   => $priority++,
	'default'     => array(
		'font-size'      => '35px',
		'line-height'    => '1.5',		
		'color'          => '#333333',
		'text-transform'=>'none',
	),
	'output' => array(
		array(
			'element' => 'h2, h2 a',
		),
	),
	
	
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom-typography',
    'settings'    => 'udetor_heading_font_type_2',
    'label'       => esc_html__( 'Heading Font Type (H3, H4, H5, H6)', 'udetor' ),
    'section'     => 'udetor_section_typography_general',    
    'priority'    => $priority++,    
    
) );


Kirki::add_field( 'udetor_config', array(
	'type'        => 'typography',
	'settings'    => 'udetor_heading_content_font_2',
	'label'       => esc_attr__( 'H3, H4, H5, H6 Font Family', 'udetor' ),	
	'section'     => 'udetor_section_typography_general',
    'priority'   => $priority++,
	'default'     => array(
		'font-family'    => 'Raleway',		
	),
	'output' => array(
		array(
			'element' => 'h3,h4,h5,h6,.course-features-item .udetor-label,.course-features-item .udetor-value,.numb-certificate,.des-certificate,.udetor-certificate h3,.heading-certificate',
		),
	),
	
	'active_callback'  => array(        
        array(
            'setting'  => 'udetor_heading_font_type_2',
            'operator' => '==',
            'value'    => 'select-google-font',
        ),
    )
) );


Kirki::add_field( 'udetor_config', array(
	'type'        => 'typography',
	'settings'    => 'udetor_heading_3',
	'label'       => esc_attr__( 'Heading 3', 'udetor' ),
	'description' => esc_attr__( 'Select the main typography options for your site.', 'udetor' ),
	'section'     => 'udetor_section_typography_general',
    'priority'   => $priority++,
	'default'     => array(
		'font-size'      => '18px',
		'line-height'    => '1.5',		
		'color'          => '#333333',
		'text-transform'=>'none',
	),
	'output' => array(
		array(
			'element' => 'h3',
		),
	),	
	
) );

Kirki::add_field( 'udetor_config', array(
	'type'        => 'typography',
	'settings'    => 'udetor_heading_4',
	'label'       => esc_attr__( 'Heading 4', 'udetor' ),
	'description' => esc_attr__( 'Select the main typography options for your site.', 'udetor' ),
	'section'     => 'udetor_section_typography_general',
    'priority'   => $priority++,
	'default'     => array(
		'font-size'      => '16px',
		'line-height'    => '1.5',		
		'color'          => '#333333',
		'text-transform'=>'none',
	),
	'output' => array(
		array(
			'element' => 'h4',
		),
	),
	
	
) );

Kirki::add_field( 'udetor_config', array(
	'type'        => 'typography',
	'settings'    => 'udetor_heading_5',
	'label'       => esc_attr__( 'Heading 5', 'udetor' ),
	'description' => esc_attr__( 'Select the main typography options for your site.', 'udetor' ),
	'section'     => 'udetor_section_typography_general',
    'priority'   => $priority++,
	'default'     => array(
		'font-size'      => '14px',
		'line-height'    => '1.5',		
		'color'          => '#333333',
		'text-transform'=>'none',
	),
	'output' => array(
		array(
			'element' => 'h5',
		),
	),
	
	
) );

Kirki::add_field( 'udetor_config', array(
	'type'        => 'typography',
	'settings'    => 'udetor_heading_6',
	'label'       => esc_attr__( 'Heading 6', 'udetor' ),
	'description' => esc_attr__( 'Select the main typography options for your site.', 'udetor' ),
	'section'     => 'udetor_section_typography_general',
    'priority'   => $priority++,
	'default'     => array(
		'font-size'      => '12px',
		'line-height'    => '1.5',		
		'color'          => '#333333',
		'text-transform'=>'none',
	),
	'output' => array(
		array(
			'element' => 'h6',
		),
	),
	
	
) );
