<?php
/**
 * Add the layout section
 */

$priority = 50;
Kirki::add_panel( 'udetor_panel_sidebars', array(
    'priority'    => $priority++,
    'title'       => esc_html__( 'Sidebars', 'udetor' ),
    'description' => esc_html__( 'Sidebars', 'udetor' ),
) );


/**
 * Add the color sidebar pages section
 */

Kirki::add_section( 'udetor_section_sidebars_pages', array(
    'title'      => esc_attr__( 'Pages', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_sidebars',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_sidebars_pages_below_title',
    'label'       => esc_html__( 'Sidebar Below Page Title', 'udetor' ),
    'section'     => 'udetor_section_sidebars_pages',
    'default'     => '1',
    'priority'    => $priority++,
    
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_sidebars_pages_above_title',
    'label'       => esc_html__( 'Sidebar Above Page Title', 'udetor' ),
    'section'     => 'udetor_section_sidebars_pages',
    'default'     => '1',
    'priority'    => $priority++,
    
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_sidebars_pages_below_content',
    'label'       => esc_html__( 'Sidebar Below Page Content', 'udetor' ),
    'section'     => 'udetor_section_sidebars_pages',
    'default'     => '1',
    'priority'    => $priority++,
    
    
) );

/**
 * Add the color sidebar blog section
 */

Kirki::add_section( 'udetor_section_sidebars_blog', array(
    'title'      => esc_attr__( 'Blog', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_sidebars',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_sidebars_heading',
    'label'       => '',
    'section'     => 'udetor_section_sidebars_blog',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Blog List', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );



Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_sidebars_blog_above',
    'label'       => esc_html__( 'Sidebar Above Blog', 'udetor' ),
    'section'     => 'udetor_section_sidebars_blog',    
    'priority'    => $priority++,    
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_sidebars_blog_below',
    'label'       => esc_html__( 'Sidebar Below Blog', 'udetor' ),
    'section'     => 'udetor_section_sidebars_blog',    
    'priority'    => $priority++,    
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_sidebars_heading1',
    'label'       => '',
    'section'     => 'udetor_section_sidebars_blog',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Blog Detail', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_sidebars_blog_detail_above',
    'label'       => esc_html__( 'Sidebar Above Post', 'udetor' ),
    'section'     => 'udetor_section_sidebars_blog',    
    'priority'    => $priority++,    
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_sidebars_blog_detail_below',
    'label'       => esc_html__( 'Sidebar Below Post', 'udetor' ),
    'section'     => 'udetor_section_sidebars_blog',    
    'priority'    => $priority++,    
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_sidebars_blog_detail_below_comment',
    'label'       => esc_html__( 'Sidebar Below Comment Area', 'udetor' ),
    'section'     => 'udetor_section_sidebars_blog',    
    'priority'    => $priority++,    
    
) );


/**
 * Add the color sidebar blog section
 */

Kirki::add_section( 'udetor_section_sidebars_footer', array(
    'title'      => esc_attr__( 'Footer', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_sidebars',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_sidebars_footer_above',
    'label'       => esc_html__( 'Sidebar Above Footer Widget', 'udetor' ),
    'section'     => 'udetor_section_sidebars_footer',    
    'priority'    => $priority++,    
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_sidebars_footer_below',
    'label'       => esc_html__( 'Sidebar Below Footer Widget', 'udetor' ),
    'section'     => 'udetor_section_sidebars_footer',    
    'priority'    => $priority++,    
    
) );
