<?php
/**
 * Add the Pages section
 */

$priority = 50;
Kirki::add_panel( 'udetor_panel_pages', array(
    'priority'    => $priority++,
    'title'       => esc_html__( 'Pages', 'udetor' ),
    'description' => esc_html__( 'Pages', 'udetor' ),
) );

/**
 * Add the Standard Page section
 */
Kirki::add_section( 'udetor_section_standard_page', array(
    'title'      => esc_attr__( 'Standard Page', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_pages',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-image',
    'settings'    => 'udetor_standard_page_sidebar_layout',
    'label'       => esc_html__( 'Sidebar Layouts', 'udetor' ),
    'section'     => 'udetor_section_standard_page',
    'default'     => 'no-sidebar',
    'priority'    => $priority++,
    'choices'     => array(        
        'right-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/sidebar-right.svg',
        'left-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/sidebar-left.svg',
        'no-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/body-full.svg',
    ),
    
) );

/**
 * Add the 404 Page section
 */
Kirki::add_section( 'udetor_section_404_page', array(
    'title'      => esc_attr__( '404 Page', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_pages',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_pages_heading',
    'label'       => '',
    'section'     => 'udetor_section_404_page',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Content', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'     => 'textarea',
    'settings' => 'udetor_pages_404_main_txt1',
    'label'    => esc_html__( 'Textt 1', 'udetor' ),
    'section'  => 'udetor_section_404_page',
    'priority' => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'     => 'textarea',
    'settings' => 'udetor_pages_404_main_txt2',
    'label'    => esc_html__( 'Text 2', 'udetor' ),
    'section'  => 'udetor_section_404_page',
    'priority' => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'image',
    'settings'    => 'udetor_pages_404_img_content',
    'label'       => esc_html__( 'Image Left Content', 'udetor' ),
    'description' => '',
    'section'     => 'udetor_section_404_page',
    'default'     => '',
    'priority'   => $priority++,    
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_pages_heading2',
    'label'       => '',
    'section'     => 'udetor_section_404_page',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Custom Styling', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_pages_404_bg_color',
    'label'       => esc_html__( 'Background Color', 'udetor' ),
    'section'     => 'udetor_section_404_page',
    'default'     => '#ffffff',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
        array(
            'element'  => '.error-404',
            'property' => 'background-color',
            
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.error-404',
            'function' => 'css',
            'property' => 'background-color',            
        ),       
    ),
    
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_pages_404_txt_size',
    'label'       => esc_html__( '404 Text Size', 'udetor' ),
    'section'     => 'udetor_section_404_page',
    'default'     => 70,
    'choices'     => array(
        'min'  => '10',
        'max'  => '70',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'transport' => 'postMessage',
    'output' => array(
        array(
            'element'  => '.error-404 .page-title',
            'property' => 'font-size',
            'units'    => 'px',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.error-404 .page-title',
            'function' => 'css',
            'property' => 'font-size',    
            'units'    => 'px',        
        ),       
    ),
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_pages_404_color',
    'label'       => esc_html__( '404 Color', 'udetor' ),
    'section'     => 'udetor_section_404_page',
    'default'     => '#999999',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
        array(
            'element'  => '.error-404 .sub-content',
            'property' => 'color',
            
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.error-404 .sub-content',
            'function' => 'css',
            'property' => 'color',            
        ),       
    ),
    
) );


/**
 * Add the Search Page
 */
Kirki::add_section( 'udetor_section_search_page', array(
    'title'      => esc_attr__( 'Search Page', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_pages',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-image',
    'settings'    => 'udetor_search_page_grid_col',
    'label'       => esc_html__( 'Search Grid Columns', 'udetor' ),
    'section'     => 'udetor_section_search_page',
    'default'     => '4',
    'priority'    => $priority++,
    'choices'     => array(
        '1'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/cols-1.jpg',
        '2' => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/cols-2.png',
        '3'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/cols-3.png',
        '4'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/cols-4.png',
    ),    
) );