<?php
/**
 * Add the layout section
 */

$priority = 30;
Kirki::add_panel( 'udetor_panel_layout', array(
    'priority'    => $priority++,
    'title'       => esc_html__( 'Layout', 'udetor' ),
    'description' => esc_html__( 'Layout', 'udetor' ),
) );
/**
 * Add the general layout control
 */

Kirki::add_section( 'udetor_section_layout_general', array(
    'title'      => esc_attr__( 'General', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_layout',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-image',
    'settings'    => 'udetor_site_layout',
    'label'       => esc_html__( 'Site Layout', 'udetor' ),
    'section'     => 'udetor_section_layout_general',
    'default'     => 'content-full',
    'priority'    => $priority++,
    'choices'     => array(
        'content-boxed'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/content-boxed.svg',
        'content-full' => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/content-full.svg',        
    ),    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_layout_offset_width',
    'label'       => esc_html__( 'Offset Width', 'udetor' ),
    'section'     => 'udetor_section_layout_general',
    'default'     => 0,
    'transport' => 'postMessage',
    'choices'     => array(
        'min'  => '0',
        'max'  => '100',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'output' => array(
        array(
            'element'  => '.udetor-offset',
            'property' => 'padding',
            'units'    => 'px',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.udetor-offset',
            'function' => 'css',
            'property' => 'padding',
            'units'    => 'px',
        ),
       
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-buttonset',
    'settings'    => 'udetor_layout_unit',
    'label'       => esc_html__( 'Unit', 'udetor' ),
    'section'     => 'udetor_section_layout_general',
    'default'     => 'unit-px',
    'priority'    => $priority++,
    'choices'     => array(
        'unit-px'   => esc_attr__( 'PX', 'udetor' ),
        'unit-percent' => esc_attr__( '%', 'udetor' ),        
    ),
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_layout_content_width',
    'label'       => esc_html__( 'Content Width', 'udetor' ),
    'section'     => 'udetor_section_layout_general',
    'transport' => 'postMessage',
    'default'     => 1170,
    'choices'     => array(
        'min'  => '760',
        'max'  => '1920',
        'step' => '10',
    ),
    'priority'   => $priority++,
    'active_callback'    => array(
        array(
            'setting'  => 'udetor_layout_unit',
            'operator' => '==',
            'value'    => 'unit-px',
        ),
    ),
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_layout_content_width_percentage',
    'label'       => esc_html__( 'Content Width Percentage', 'udetor' ),
    'section'     => 'udetor_section_layout_general',
    'default'     => 100,
    'transport' => 'postMessage',
    'choices'     => array(
        'min'  => '20',
        'max'  => '100',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'active_callback'    => array(
        array(
            'setting'  => 'udetor_layout_unit',
            'operator' => '==',
            'value'    => 'unit-percent',
        ),
    ),
    'output' => array(
        array(
            'element'  => '.site-content,.udetor-page-title .entry-header',
            'property' => 'max-width',
            'units'    => '%',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.site-content,.udetor-page-title .entry-header',
            'function' => 'css',
            'property' => 'max-width',
            'units'    => '%',
        ),
       
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_layout_content_padding',
    'label'       => esc_html__( 'Content Padding', 'udetor' ),
    'section'     => 'udetor_section_layout_general',
    'transport' => 'postMessage',
    'default'     => 0,
    'choices'     => array(
        'min'  => '0',
        'max'  => '50',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'output' => array(
        array(
            'element'  => '.site-content,.udetor-page-title .entry-header',
            'property' => 'padding',
            'units'    => 'px',
        ),        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.site-content,.udetor-page-title .entry-header',
            'function' => 'css',
            'property' => 'padding',
            'units'    => 'px',
        ),       
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_layout_gutter_width',
    'label'       => esc_html__( 'Gutter Width', 'udetor' ),
    'section'     => 'udetor_section_layout_general',
    'default'     => 100,
    'choices'     => array(
        'min'  => '20',
        'max'  => '50',
        'step' => '1',
    ),
    'priority'   => $priority++,    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_layout_frame_width',
    'label'       => esc_html__( 'Boxed Frame Width', 'udetor' ),
    'section'     => 'udetor_section_layout_general',
    'default'     => 1171,
    'choices'     => array(
        'min'  => '980',
        'max'  => '1171',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_site_layout',
            'operator' => '==',
            'value'    => 'content-boxed',
        ),
    )
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'select',
    'settings'    => 'udetor_layout_bgtype',
    'label'       => esc_html__( 'Background Type', 'udetor' ),
    'section'     => 'udetor_section_layout_general',
    'default'     => 'color',
    'priority'    => $priority++,
    'multiple'    => 1,
    'choices'     => array(
        'color' => esc_attr__( 'Color', 'udetor' ),
        'img' => esc_attr__( 'Image', 'udetor' ),
    ),
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_site_layout',
            'operator' => '==',
            'value'    => 'content-boxed',
        ),
    )
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_layout_bgcolor',
    'label'       => esc_html__( 'Background Color', 'udetor' ),
    'section'     => 'udetor_section_layout_general',
    'default'     => '#DDDDDD',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
        array(
            'element'  => '.content-boxed',
            'property' => 'background-color',            
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.content-boxed',
            'function' => 'css',
            'property' => 'background-color',            
        ),
       
    ),
    'active_callback'  => array(     
        array(
            'setting'  => 'udetor_site_layout',
            'operator' => '==',
            'value'    => 'content-boxed',
        ),   
        array(
            'setting'  => 'udetor_layout_bgtype',
            'operator' => '==',
            'value'    => 'color',
        ),
    )
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'image',
    'settings'    => 'udetor_layout_bgimage',
    'label'       => esc_html__( 'Background Image', 'udetor' ),
    'description' => '',

    'help'        => esc_html__( 'This is some extra help text.', 'udetor' ),
    'section'     => 'udetor_section_layout_general',
    'default'     => '',
    'priority'   => $priority++,
    'active_callback'  => array(  
        array(
            'setting'  => 'udetor_site_layout',
            'operator' => '==',
            'value'    => 'content-boxed',
        ),      
        array(
            'setting'  => 'udetor_layout_bgtype',
            'operator' => '==',
            'value'    => 'img',
        ),
    )
) );

/**
 * Add the Page Title control
 */

Kirki::add_section( 'udetor_section_page_title', array(
    'title'      => esc_attr__( 'Page Title', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_layout',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_show_page_title',
    'label'       => esc_html__( 'Show Page Title', 'udetor' ),
    'section'     => 'udetor_section_page_title',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_page_title_full',
    'label'       => esc_html__( 'Enable Full Width', 'udetor' ),
    'section'     => 'udetor_section_page_title',
    'default'     => '1',
    'priority'    => $priority++,
    'active_callback'  => array(     
        array(
            'setting'  => 'udetor_show_page_title',
            'operator' => '==',
            'value'    => '1',
        ),   
        
    ),
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_show_breadcrumb',
    'label'       => esc_html__( 'Show Breadcrumb', 'udetor' ),
    'section'     => 'udetor_section_page_title',
    'default'     => '1',
    'priority'    => $priority++,
     'active_callback'  => array(     
        array(
            'setting'  => 'udetor_show_page_title',
            'operator' => '==',
            'value'    => '1',
        ),   
        
    ),
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_page_title_padding_top',
    'label'       => esc_html__( 'Content Padding Top', 'udetor' ),
    'section'     => 'udetor_section_page_title',
    'transport' => 'postMessage',
    'default'     => 15,
    'choices'     => array(
        'min'  => '0',
        'max'  => '500',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'output' => array(
        array(
            'element'  => '.page .entry-header',
            'property' => 'padding-top',
            'units'    => 'px',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.page .entry-header',
            'function' => 'css',
            'property' => 'padding-top',
            'units'    => 'px',
        ),
       
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_page_title_padding_bottom',
    'label'       => esc_html__( 'Content Padding Bottom', 'udetor' ),
    'section'     => 'udetor_section_page_title',
    'transport' => 'postMessage',
    'default'     => 15,
    'choices'     => array(
        'min'  => '0',
        'max'  => '500',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'output' => array(
        array(
            'element'  => '.page .entry-header',
            'property' => 'padding-bottom',
            'units'    => 'px',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.page .entry-header',
            'function' => 'css',
            'property' => 'padding-bottom',
            'units'    => 'px',
        ),
       
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_page_title_min_height',
    'label'       => esc_html__( 'Min Height', 'udetor' ),
    'section'     => 'udetor_section_page_title',
    'default'     => 30,
    'choices'     => array(
        'min'  => '0',
        'max'  => '1000',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'transport' => 'postMessage',
    'output' => array(
        array(
            'element'  => '.page .entry-header',
            'property' => 'min-height',
            'units'    => 'px',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.page .entry-header',
            'function' => 'css',
            'property' => 'min-height',
            'units'    => 'px',
        ),
       
    ),
     'active_callback'  => array(     
        array(
            'setting'  => 'udetor_show_page_title',
            'operator' => '==',
            'value'    => '1',
        ),   
        
    ),
   
) );

/**
 * Add the Button Styles control
 */

Kirki::add_section( 'udetor_section_button', array(
    'title'      => esc_attr__( 'Button Styles', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_layout',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_button_left_right',
    'label'       => esc_html__( 'Padding (Left+ Right)', 'udetor' ),
    'section'     => 'udetor_section_button',
    'default'     => '10',
    'choices'     => array(
        'min'  => '5',
        'max'  => '50',
        'step' => '1',
    ),
    'priority'   => $priority++,   
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_button_top_bottom',
    'label'       => esc_html__( 'Padding (Top+ Bottom)', 'udetor' ),
    'section'     => 'udetor_section_button',
    'default'     => '5',
    'choices'     => array(
        'min'  => '5',
        'max'  => '50',
        'step' => '1',
    ),
    'priority'   => $priority++,
   
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_button_border_width',
    'label'       => esc_html__( 'Border Width', 'udetor' ),
    'section'     => 'udetor_section_button',
    'default'     => '1',
    'choices'     => array(
        'min'  => '0',
        'max'  => '10',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'transport' => 'postMessage',
    'output' => array(
        array(
            'element'  => 'input.search-submit,.btn, button,input[type="submit"],.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,.woocommerce.widget_shopping_cart .buttons a,.woocommerce .widget_price_filter .price_slider_amount .button,.woocommerce ul.products.udetor-layout-list li.product .u-buttons .add_to_cart_button, .udetor-page-cart tbody tr td.actions button,.netbase-toolkit-mini-cart .widget_shopping_cart_content .buttons a,.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button',
            'property' => 'border-width',
            'units'    => 'px',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => 'input.search-submit,.btn, button,input[type="submit"],',
            'property' => 'border-width',
            'function' => 'css',            
            'units'    => 'px',
        ),
       
    ),
   
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_button_border_radius',
    'label'       => esc_html__( 'Border Radius', 'udetor' ),
    'section'     => 'udetor_section_button',
    'default'     => '19',
    'choices'     => array(
        'min'  => '0',
        'max'  => '50',
        'step' => '1',
    ),
    'priority'   => $priority++,
   'transport' => 'postMessage',
    'output' => array(
        array(
            'element'  => 'input.search-submit,.btn, button,input[type="submit"],#comments input[type="submit"],.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,.woocommerce.widget_shopping_cart .buttons a, .woocommerce .widget_price_filter .price_slider_amount .button, .udetor-page-cart tbody tr td.actions  button,.netbase-toolkit-mini-cart .widget_shopping_cart_content .buttons a, .entry-content .udetor-page-cart tbody tr td.actions .coupon #coupon_code,.btn-wap-update a.btn-continue-shop, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button',
            'property' => 'border-radius',
            'units'    => 'px',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => 'input.search-submit,.btn, button,input[type="submit"],#comments input[type="submit"],.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt',
            'property' => 'border-radius',
            'function' => 'css',            
            'units'    => 'px',
        ),
       
    ),
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_button_font_size',
    'label'       => esc_html__( 'Font Size', 'udetor' ),
    'section'     => 'udetor_section_button',
    'default'     => '16',
    'choices'     => array(
        'min'  => '0',
        'max'  => '50',
        'step' => '1',
    ),
    'priority'   => $priority++,
   'transport' => 'postMessage',
    'output' => array(
        array(
            'element'  => 'input.search-submit,.btn, button,input[type="submit"],#comments input[type="submit"],.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,.woocommerce.widget_shopping_cart .buttons a, .woocommerce .widget_price_filter .price_slider_amount .button, .udetor-page-cart tbody tr td.actions  button,.netbase-toolkit-mini-cart .widget_shopping_cart_content .buttons a, .entry-content .udetor-page-cart tbody tr td.actions .coupon #coupon_code,.btn-wap-update a.btn-continue-shop, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button',
            'property' => 'font-size',
            'units'    => 'px',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => 'input.search-submit,.btn, button,input[type="submit"],#comments input[type="submit"],.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt',
            'property' => 'font-size',
            'function' => 'css',            
            'units'    => 'px',
        ),
       
    ),
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_button_heading1',
    'label'       => '',
    'section'     => 'udetor_section_button',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Secondary Button', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_button_secondary_left_right',
    'label'       => esc_html__( 'Padding (Left+ Right)', 'udetor' ),
    'section'     => 'udetor_section_button',
    'default'     => '36',
    'choices'     => array(
        'min'  => '5',
        'max'  => '50',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'transport' => 'postMessage',
    'output' => array(
        array(
            'element'  => '.secondary_btn',
            'property' => 'padding-left',
            'units'    => 'px',
        ),
        array(
            'element'  => '.secondary_btn',
            'property' => 'padding-right',
            'units'    => 'px',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.secondary_btn',
            'property' => 'padding-left',
            'function' => 'css',            
            'units'    => 'px',
        ),
        array(
            'element'  => '.secondary_btn',
            'property' => 'padding-right',
            'function' => 'css',            
            'units'    => 'px',
        ),
       
    ),
   
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_button_secondary_top_bottom',
    'label'       => esc_html__( 'Padding (Top+ Bottom)', 'udetor' ),
    'section'     => 'udetor_section_button',
    'default'     => '5',
    'choices'     => array(
        'min'  => '3',
        'max'  => '50',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'transport' => 'postMessage',
    'output' => array(
        array(
            'element'  => '.secondary_btn',
            'property' => 'padding-top',
            'units'    => 'px',
        ),
        array(
            'element'  => '.secondary_btn',
            'property' => 'padding-bottom',
            'units'    => 'px',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.secondary_btn',
            'property' => 'padding-top',
            'function' => 'css',            
            'units'    => 'px',
        ),
        array(
            'element'  => '.secondary_btn',
            'property' => 'padding-bottom',
            'function' => 'css',            
            'units'    => 'px',
        ),
       
    ),
   
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_button_secondary_border_width',
    'label'       => esc_html__( 'Border Width', 'udetor' ),
    'section'     => 'udetor_section_button',
    'default'     => '1',
    'choices'     => array(
        'min'  => '0',
        'max'  => '10',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'transport' => 'postMessage',
    'output' => array(
        array(
            'element'  => '.secondary_btn',
            'property' => 'border-width',
            'units'    => 'px',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.secondary_btn',
            'property' => 'border-width',
            'function' => 'css',            
            'units'    => 'px',
        ),
       
    ),
   
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_button_secondary_border_radius',
    'label'       => esc_html__( 'Border Radius', 'udetor' ),
    'section'     => 'udetor_section_button',
    'default'     => '18',
    'choices'     => array(
        'min'  => '0',
        'max'  => '50',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'transport' => 'postMessage',
    'output' => array(
        array(
            'element'  => '.secondary_btn',
            'property' => 'border-radius',
            'units'    => 'px',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.secondary_btn',
            'property' => 'border-radius',
            'function' => 'css',            
            'units'    => 'px',
        ),
       
    ),
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_button_secondary_icon',
    'label'       => esc_html__( 'Show icon', 'udetor' ),
    'section'     => 'udetor_section_button',
    'default'     => '1',
    'priority'    => $priority++,
) );