<?php
/**
 * Add the layout section
 */

$priority = 45;
Kirki::add_panel( 'udetor_panel_header', array(
    'priority'    => $priority++,
    'title'       => esc_html__( 'Header', 'udetor' ),
    'description' => esc_html__( 'Header', 'udetor' ),
) );

Kirki::add_section( 'udetor_section_header_setting_default', array(
    'title'      => esc_attr__( 'Header Default', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_header',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'image',
    'settings'    => 'udetor_header_default_logo',
    'label'       => esc_html__( 'Logo Header Default', 'udetor' ),      
    'section'     => 'udetor_section_header_setting_default',
    'default'     => '',
    'priority'   => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_header_default_custom_color',
    'label'       => esc_html__( 'Set Header Custom Color', 'udetor' ),
    'section'     => 'udetor_section_header_setting_default',
    'description' => 'Set default color for element menus and icons',
    'default'     => '0',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_header_color_df',
    'label'       => esc_html__( 'Header Color ', 'udetor' ),
    'section'     => 'udetor_section_header_setting_default',
    'default'     => '#ffffff',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'active_callback'  => array(     
        array(
            'setting'  => 'udetor_header_default_custom_color',
            'operator' => '==',
            'value'    => '1',
        ),
    ),
    'output' => array(
            array(
                'element'  => 'header .text-right i',
                'property' => 'color',                
            ),
    ),    
    
) );

Kirki::add_section( 'udetor_section_header_presets', array(
    'title'      => esc_attr__( 'Presets', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_header',
) );

// Get all headers.
$list_header = new WP_Query(array(
    'posts_per_page' => -1,
    'post_type' => 'page_header',
    'post_status' => 'publish',
    'suppress_filters' => true,
));

$header_layout = array();

// Set to normal headers default
if ($list_header->post_count) {
    foreach ($list_header->posts as $val) {
        $image = get_the_post_thumbnail($val->ID, 'thumbnail');
        $post_thumbnail_id = get_post_thumbnail_id($val->ID);
        $image_url = wp_get_attachment_image_url($post_thumbnail_id, 'thumbnail');
        $header_layout[$val->ID] = $image_url;
    }
};

Kirki::add_field('udetor_config', array(
    'type' => 'radio-image',
    'settings' => 'udetor_global_header',
    'label' => esc_html__('Header Presets', 'udetor'),
    'section' => 'udetor_section_header_presets',
    'priority' => $priority++,
    'choices' => $header_layout,
));
