<?php
$priority = 10;
Kirki::add_panel( 'udetor_panel_general', array(
    'priority'    => $priority++,
    'title'       => esc_html__( 'General', 'udetor' ),
    'description' => esc_html__( 'General', 'udetor' ),
) );

/**
 * Add the Social control
 */
Kirki::add_section( 'udetor_section_social', array(
    'title'      => esc_attr__( 'Social- Share', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_general',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sortable',
    'settings'    => 'udetor_social_on',
    'label'       => esc_html__( 'Social Sharing', 'udetor' ),
    'section'     => 'udetor_section_social',
    'default'     => array(
        'facebook',
        'twitter',
        'google'
    ),
    'choices'     => array(
        'facebook' => esc_attr__( 'Facebook', 'udetor' ),
        'twitter' => esc_attr__( 'Twitter', 'udetor' ),
        'google' => esc_attr__( 'Google Plus', 'udetor' ),        
    ),
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_social_heading1',
    'label'       => '',
    'section'     => 'udetor_section_social',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Social Account', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'     => 'text',
    'settings' => 'udetor_acc_facebook',
    'label'    => esc_html__( 'Facebook', 'udetor' ),
    'section'  => 'udetor_section_social',
    'default'  => '',
    'priority' => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'     => 'text',
    'settings' => 'udetor_acc_twitter',
    'label'    => esc_html__( 'Twitter', 'udetor' ),
    'section'  => 'udetor_section_social',
    'default'  => '',
    'priority' => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'     => 'text',
    'settings' => 'udetor_acc_google',
    'label'    => esc_html__( 'Googel Plus', 'udetor' ),
    'section'  => 'udetor_section_social',
    'default'  => '',
    'priority' => $priority++,
) );

/**
 * Add the Page Loading Effect control
 */
Kirki::add_section( 'udetor_section_page_effect', array(
    'title'      => esc_attr__( 'Page Loading Effect', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_general',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'select',
    'settings'    => 'udetor_effect_type',
    'label'       => esc_html__( 'Effect Type', 'udetor' ),
    'section'     => 'udetor_section_page_effect',
    'default'     => 'none',
    'priority'    => $priority++,
    'multiple'    => 1,
    'choices'     => array(
        'none' => esc_attr__( 'None', 'udetor' ),
        'css' => esc_attr__( 'CSS Animation', 'udetor' ),
        'image' => esc_attr__( 'Image', 'udetor' ),        
    ),
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio',
    'settings'    => 'udetor_css_animation_type',
    'label'       => esc_html__( 'Animation Type', 'udetor' ),
    'section'     => 'udetor_section_page_effect',
    'default'     => '1',
    'priority'    => $priority++,
    'choices'     => array(
        '1'   => esc_attr__( 'Animation 1', 'udetor' ),        
        '2' => esc_attr__( 'Animation 2', 'udetor' ),
        '3'  => esc_attr__( 'Animation 3', 'udetor' ),
    ),
   
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_effect_type',
            'operator' => '==',
            'value'    => 'css',
        ),
    )
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_css_icon_color',
    'label'       => esc_html__( 'Icon Color', 'udetor' ),
    'section'     => 'udetor_section_page_effect',
    'default'     => '#1ba590',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_effect_type',
            'operator' => '==',
            'value'    => 'css',
        ),
    )
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'image',
    'settings'    => 'udetor_page_effect_image',
    'label'       => esc_html__( 'Image', 'udetor' ),
    'description' => '',

    'help'        => esc_html__( 'This is some extra help text.', 'udetor' ),
    'section'     => 'udetor_section_page_effect',
    'default'     => '',
    'priority'   => $priority++,
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_effect_type',
            'operator' => '==',
            'value'    => 'image',
        ),
    )
) );

/**
 * Add the Back To Top control
 */
Kirki::add_section( 'udetor_section_back_to_top', array(
    'title'      => esc_attr__( 'Back To Top Button', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_general',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_backtotop_enable',
    'label'       => esc_html__( 'Back To Top Button Enable', 'udetor' ),
    'section'     => 'udetor_section_back_to_top',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'select',
    'settings'    => 'udetor_backtotop_shape',
    'label'       => esc_html__( 'Shape', 'udetor' ),
    'section'     => 'udetor_section_back_to_top',
    'default'     => '100',
    'priority'    => $priority++,
    'multiple'    => 1,
    'transport' => 'postMessage',
    'choices'     => array(
        '100' => esc_attr__( 'Circle', 'udetor' ),
        '0' => esc_attr__( 'Square', 'udetor' ),
        '18' => esc_attr__( 'Rounded', 'udetor' ),       
           
    ),
    'output' => array(
        array(
            'element'  => '#btt',
            'property' => 'border-radius',
            'units'    => '%',
        ),
       
    ),
    'js_vars'   => array(
        array(
            'element'  => '#btt',
            'function' => 'css',
            'property' => 'border-radius',
            'units'    => '%',
        ),
        
    ),
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_backtotop_enable',
            'operator' => '==',
            'value'    => '1',
        ),
    )
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_backtotop_button_bg',
    'label'       => esc_html__( 'Button Background', 'udetor' ),
    'section'     => 'udetor_section_back_to_top',
    'default'     => '#fff',
    'priority'    => $priority++,
    'transport' => 'postMessage',
    'choices'     => array(
        'alpha' => true,
    ),
    'output' => array(
        array(
            'element'  => '#btt',
            'property' => 'background-color',            
        ),
        
    ),
     'js_vars'   => array(
        array(
            'element'  => '#btt',
            'function' => 'css',
            'property' => 'background-color',            
        ),       
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_backtotop_button_size',
    'label'       => esc_html__( 'Button Size', 'udetor' ),
    'section'     => 'udetor_section_back_to_top',
    'default'     => 40,
    
    'choices'     => array(
        'min'  => '20',
        'max'  => '60',
        'step' => '1',
    ),
    'transport' => 'postMessage',
    'priority'   => $priority++,
    'output' => array(
        array(
            'element'  => '#btt',
            'property' => 'height',
            'units'    => 'px',
        ),
        array(
            'element'  => '#btt',
            'property' => 'width',
            'units'    => 'px',
        ),
    ),
    'js_vars'   => array(
        array(
            'element'  => '#btt',
            'function' => 'css',
            'property' => 'height',
            'units'    => 'px',
        ),
        array(
            'element'  => '#btt',
            'function' => 'css',
            'property' => 'width',
            'units'    => 'px',
        ),
    ),
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_backtotop_enable',
            'operator' => '==',
            'value'    => '1',
        ),
    )
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_backtotop_icon_color',
    'label'       => esc_html__( 'Icon Color', 'udetor' ),
    'section'     => 'udetor_section_back_to_top',
    'default'     => '#676c77',
    'priority'    => $priority++,
    'transport' => 'postMessage',
    'choices'     => array(
        'alpha' => true,
    ),
    'output' => array(
        array(
            'element'  => '#btt i',
            'property' => 'color',
            
        ),
        
    ),
     'js_vars'   => array(
        array(
            'element'  => '#btt i',
            'function' => 'css',
            'property' => 'color',
            
        ),
       
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_backtotop_icon_size',
    'label'       => esc_html__( 'Icon Size', 'udetor' ),
    'section'     => 'udetor_section_back_to_top',
    'default'     => 10,
    'transport' => 'postMessage',
    'choices'     => array(
        'min'  => '10',
        'max'  => '50',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'output' => array(
        array(
            'element'  => '#btt i',
            'property' => 'font-size',
            'units'    => 'px',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '#btt i',
            'function' => 'css',
            'property' => 'font-size',
            'units'    => 'px',
        ),
       
    ),
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_backtotop_enable',
            'operator' => '==',
            'value'    => '1',
        ),
    )
) );

/**
 * Add the ajaxsearch
 */
Kirki::add_section( 'udetor_section_ajaxsearch', array(
    'title'      => esc_attr__( 'Ajax Search', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_general',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'multicheck',
    'settings'    => 'udetor_ajaxsearch_posttype',
    'label'       => esc_html__( 'Select Post Type', 'udetor' ),
    'section'     => 'udetor_section_ajaxsearch',
    'default'     => array('sfwd-courses', 'post'),
    'priority'    => $priority++,
    'choices'     => array(
        'post' => esc_html__( 'Posts', 'udetor' ),
        'page' => esc_html__( 'Pages', 'udetor' ),
        'product' => esc_html__( 'Products', 'udetor' ),
        'sfwd-courses' => esc_html__( 'Courses', 'udetor' ),
        'sfwd-lessons' => esc_html__( 'Lessons', 'udetor' ),
    ),
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'number',
    'settings'    => 'udetor_ajaxsearch_suggestionitem',
    'label'       => esc_html__( 'Number of Suggestion Items', 'udetor' ),
    'section'     => 'udetor_section_ajaxsearch',
    'priority'    => $priority++,
    'default'     => 5,
    'choices'     => array(
        'min'  => 0,
        'max'  => 80,
        'step' => 1,
    ),
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'checkbox',
    'settings'    => 'udetor_ajaxsearch_searchcontent',
    'label'       => esc_html__( 'Search content?', 'udetor' ),
    'description' => '',
    'section'     => 'udetor_section_ajaxsearch',
    'default'     => true,
    'priority'    => $priority++,
) );

/*Kirki::add_field( 'udetor_config', array(
    'type'        => 'select',
    'settings'    => 'udetor_ajaxsearch_tempsform',
    'label'       => esc_html__( 'Allow you to override the default search form', 'udetor' ),
    'section'     => 'udetor_section_ajaxsearch',
    'default'     => 'no',
    'priority'    => $priority++,
    'multiple'    => 1,
    'choices'     => array(
        'no' => esc_attr__( 'No', 'udetor' ),
        'yes' => esc_attr__( 'Yes', 'udetor' ),
             
    ),
) );*/

Kirki::add_field( 'udetor_config', array(
    'type'        => 'select',
    'settings'    => 'udetor_ajaxsearch_showimg',
    'label'       => esc_html__( 'Show images in results', 'udetor' ),
    'section'     => 'udetor_section_ajaxsearch',
    'default'     => 'yes',
    'priority'    => $priority++,
    'multiple'    => 1,
    'choices'     => array(
        'yes' => esc_attr__( 'Yes', 'udetor' ),
        'no' => esc_attr__( 'No', 'udetor' ),        
             
    ),
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'select',
    'settings'    => 'udetor_ajaxsearch_showmeta',
    'label'       => esc_html__( 'Show meta in results.', 'udetor' ),
    'section'     => 'udetor_section_ajaxsearch',
    'default'     => 'yes',
    'priority'    => $priority++,
    'multiple'    => 1,
    'choices'     => array(
        'yes' => esc_attr__( 'Yes', 'udetor' ),
        'no' => esc_attr__( 'No', 'udetor' ),        
             
    ),
) );

/*Kirki::add_field( 'udetor_config', array(
    'type'        => 'select',
    'settings'    => 'udetor_ajaxsearch_showexcerpts',
    'label'       => esc_html__( 'Show excerpts in results.', 'udetor' ),
    'section'     => 'udetor_section_ajaxsearch',
    'default'     => 'yes',
    'priority'    => $priority++,
    'multiple'    => 1,
    'choices'     => array(
        'yes' => esc_attr__( 'Yes', 'udetor' ),
        'no' => esc_attr__( 'No', 'udetor' ),        
             
    ),
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'number',
    'settings'    => 'udetor_ajaxsearch_numbexcerpt',
    'label'       => esc_html__( 'Limit number of words in excerpt', 'udetor' ),
    'section'     => 'udetor_section_ajaxsearch',
    'priority'    => $priority++,
    'default'     => 35,
    'choices'     => array(
        'min'  => 0,
        'max'  => 300,
        'step' => 1,
    ),
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_ajaxsearch_showexcerpts',
            'operator' => '==',
            'value'    => 'yes',
        ),
    )
) );*/