<?php
/**
 * Add the layout section
 */
$priority = 55;
Kirki::add_panel( 'udetor_panel_footer', array(
    'priority'    => $priority++,
    'title'       => esc_html__( 'Footer', 'udetor' ),
    'description' => esc_html__( 'Footer', 'udetor' ),
) );
/**
 * Add the footer top section
 */
Kirki::add_section( 'udetor_section_footer_top', array(
    'title'      => esc_attr__( 'Top Footer', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_footer',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_footer_top_full_width_enable',
    'label'       => esc_html__( 'Enable Full Width', 'udetor' ),
    'section'     => 'udetor_section_footer_top',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-image',
    'settings'    => 'udetor_footer_top_sidebar_layout',
    'label'       => esc_html__( 'Sidebar Layout', 'udetor' ),
    'section'     => 'udetor_section_footer_top',
    'default'     => 'f1',
    'description' => esc_html__( 'Select the layout type for the footer. The content is added via Appearance Widgets', 'udetor' ),
    'priority'    => $priority++,
    'choices'     => array(
        'f1'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-01.png',
        'f2'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-02.png',
        'f3'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-03.png',
        'f4'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-04.png',
        'f5'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-05.png',
        'f6'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-06.png',
        'f7'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-07.png',
        'f8'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-08.png',
        'f9'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-09.png',
    ),
    
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_footer_top_1content',
    'label'       => esc_html__( 'Sidebar 1 Content', 'udetor' ),
    'section'     => 'udetor_section_footer_top',    
    'priority'    => $priority++,    
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_footer_top_2content',
    'label'       => esc_html__( 'Sidebar 2 Content', 'udetor' ),
    'section'     => 'udetor_section_footer_top',    
    'priority'    => $priority++,   
    'active_callback'    => array(
        array(
            'setting'  => 'udetor_footer_top_sidebar_layout',
            'operator' => '!=',
            'value'    => 'f1',
        ),
    ), 
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_footer_top_3content',
    'label'       => esc_html__( 'Sidebar 3 Content', 'udetor' ),
    'section'     => 'udetor_section_footer_top',    
    'priority'    => $priority++, 
    'active_callback'    => array(
        array(
            'setting'  => 'udetor_footer_top_sidebar_layout',
            'operator' => '<=',
            'value'    => 'f5',
        ),
        
    ),  
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_footer_top_4content',
    'label'       => esc_html__( 'Sidebar 4 Content', 'udetor' ),
    'section'     => 'udetor_section_footer_top',    
    'priority'    => $priority++, 
    'active_callback'    => array(
        array(
            'setting'  => 'udetor_footer_top_sidebar_layout',
            'operator' => '==',
            'value'    => 'f9',
        ),
    ),   
    
) );

/**
 * Add the footer main section
 */
Kirki::add_section( 'udetor_section_footer_main', array(
    'title'      => esc_attr__( 'Main Footer', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_footer',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_footer_main_full_width_enable',
    'label'       => esc_html__( 'Enable Full Width', 'udetor' ),
    'section'     => 'udetor_section_footer_main',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-image',
    'settings'    => 'udetor_footer_main_sidebar_layout',
    'label'       => esc_html__( 'Sidebar Layout', 'udetor' ),
    'section'     => 'udetor_section_footer_main',
    'default'     => 'f9',
    'priority'    => $priority++,
    'choices'     => array(
        'f1'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-01.png',
        'f2'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-02.png',
        'f3'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-03.png',
        'f4'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-04.png',
        'f5'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-05.png',
        'f6'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-06.png',
        'f7'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-07.png',
        'f8'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-08.png',
        'f9'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/footer-09.png',
    ),
    
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_footer_main_1content',
    'label'       => esc_html__( 'Sidebar 1 Content', 'udetor' ),
    'section'     => 'udetor_section_footer_main',    
    'priority'    => $priority++,    
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_footer_main_2content',
    'label'       => esc_html__( 'Sidebar 2 Content', 'udetor' ),
    'section'     => 'udetor_section_footer_main',    
    'priority'    => $priority++,    
    'active_callback'    => array(
        array(
            'setting'  => 'udetor_footer_main_sidebar_layout',
            'operator' => '!=',
            'value'    => 'f1',
        ),
    ), 
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_footer_main_3content',
    'label'       => esc_html__( 'Sidebar 3 Content', 'udetor' ),
    'section'     => 'udetor_section_footer_main',    
    'priority'    => $priority++, 
    'active_callback'    => array(
        array(
            'setting'  => 'udetor_footer_main_sidebar_layout',
            'operator' => '<=',
            'value'    => 'f5',
        ),
        
    ), 
       
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_footer_main_4content',
    'label'       => esc_html__( 'Sidebar 4 Content', 'udetor' ),
    'section'     => 'udetor_section_footer_main',    
    'priority'    => $priority++,  
    'active_callback'    => array(
        array(
            'setting'  => 'udetor_footer_main_sidebar_layout',
            'operator' => '==',
            'value'    => 'f9',
        ),
        
    ),   
    
) );

/**
 * Add the footer main section
 */
Kirki::add_section( 'udetor_section_footer_copyright', array(
    'title'      => esc_attr__( 'Copyright - Footer', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_footer',
) );


Kirki::add_field( 'udetor_config', array(
    'type'     => 'textarea',
    'settings' => 'udetor_footer_copyright_txt',
    'label'    => esc_html__( 'Copyright Text', 'udetor' ),
    'section'  => 'udetor_section_footer_copyright',
    'priority' => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'image',
    'settings'    => 'udetor_footer_copyright_logo',
    'label'       => esc_html__( 'Footer Logo', 'udetor' ),
    'description' => '',
    'section'     => 'udetor_section_footer_copyright',
    'default'     => '',
    'priority'   => $priority++,    
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'     => 'menu-dropdown',
    'settings' => 'udetor_footer_copyright_select_menu',
    'label'    => esc_html__( 'Select Menu', 'udetor' ),
    'section'  => 'udetor_section_footer_copyright',
    'priority' => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sortable',
    'settings'    => 'udetor_footer_copyright_social',
    'label'       => esc_html__( 'Social Icons', 'udetor' ),
    'section'     => 'udetor_section_footer_copyright',
    'default'     => array(
        'udetorfacebook',
        'udetortwitter',
        'udetorgoogle'
    ),
    'choices'     => array(
        'facebook' => esc_attr__( 'Facebook', 'udetor' ),
        'twitter' => esc_attr__( 'Twitter', 'udetor' ),
        'google' => esc_attr__( 'Google Plus', 'udetor' ),        
    ),
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'     => 'textarea',
    'settings' => 'udetor_footer_copyright_google_analytics',
    'label'    => esc_html__( 'Google Analytics Code', 'udetor' ),
    'section'  => 'udetor_section_footer_copyright',    
    'priority' => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'goto-section',
    'settings'    => 'udetor_footer_copyright_go_color',
    'label'       => 'Customizer Color',
    'choices'     =>  array('udetor_section_color_footer'),
    'section'     => 'udetor_section_footer_copyright',
    'priority'    => $priority++,
) );