<?php
/**
 * Add the Events section
 */

$priority = 50;
Kirki::add_panel( 'udetor_panel_events', array(
    'priority'    => $priority++,
    'title'       => esc_html__( 'Events', 'udetor' ),
    'description' => esc_html__( 'Events', 'udetor' ),
) );

/**
 * Add the Standard Page section
 */
Kirki::add_section( 'udetor_section_event_list', array(
    'title'      => esc_attr__( 'General', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_events',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_event_list_sidebar_content',
    'label'       => esc_html__( 'Sidebar Content', 'udetor' ),
    'section'     => 'udetor_section_event_list',
    'default'     => 'sidebar-1',
    'priority'    => $priority++,
    'multiple'    => 1,    
) );

Kirki::add_field( 'udetor_config', array(
    'type'     => 'text',
    'settings' => 'udetor_event_list_sub_heading',
    'label'    => esc_html__( 'Sub Heading', 'udetor' ),
    'section'  => 'udetor_section_event_list',
    'default'  => '',
    'priority' => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'image',
    'settings'    => 'udetor_event_list_head_img',
    'label'       => esc_html__( 'Head Image', 'udetor' ),
    'description' => '',
    'section'     => 'udetor_section_event_list',
    'default'     => '',
    'priority'   => $priority++,    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_event_header_trans',
    'label'       => esc_html__( 'Header transparent', 'udetor' ),
    'section'     => 'udetor_section_event_list',
    'default'     => '0',
    'priority'    => $priority++,    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_event_details_show_social_sharing',
    'label'       => esc_html__( 'Show Social Sharing', 'udetor' ),
    'section'     => 'udetor_section_event_list',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'     => 'text',
    'settings' => 'udetor_event_detail_info_title',
    'label'    => esc_html__( 'Custom Detail Event Infomation Title', 'udetor' ),
    'section'  => 'udetor_section_event_list',
    'default'  => '',
    'priority' => $priority++,
) );