<?php
/**
 * Add the layout section
 */

$priority = 45;
Kirki::add_panel( 'udetor_panel_courses', array(
    'priority'    => $priority++,
    'title'       => esc_html__( 'Courses - Learndash', 'udetor' ),
    'description' => esc_html__( 'Courses - Learndash', 'udetor' ),
) );

Kirki::add_section( 'udetor_section_courses_list', array(
    'title'      => esc_attr__( 'List Courses', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_courses',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-image',
    'settings'    => 'udetor_courses_sidebar_layout',
    'label'       => esc_html__( 'Sidebar Layout', 'udetor' ),
    'section'     => 'udetor_section_courses_list',
    'default'     => 'left-sidebar',
    'priority'    => $priority++,
    'choices'     => array(
        'right-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/sidebar-right.svg',
        'left-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/sidebar-left.svg',
        'no-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/body-full.svg',
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_courses_show_page_title',
    'label'       => esc_html__( 'Show Page Title', 'udetor' ),
    'section'     => 'udetor_section_courses_list',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'     => 'text',
    'settings' => 'udetor_courses_page_title_content',
    'label'    => esc_html__( 'Page Title Content', 'udetor' ),
    'section'  => 'udetor_section_courses_list',
    'default'  => '',
    'priority' => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'     => 'text',
    'settings' => 'udetor_courses_sub_heading',
    'label'    => esc_html__( 'Sub Heading', 'udetor' ),
    'section'  => 'udetor_section_courses_list',
    'default'  => '',
    'priority' => $priority++,
) );
/*Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_courses_use_ajax',
    'label'       => esc_html__( 'Use Ajax', 'udetor' ),
    'section'     => 'udetor_section_courses_list',
    'default'     => '1',
    'priority'    => $priority++,
) );*/
Kirki::add_field( 'udetor_config', array(
    'type'        => 'select',
    'settings'    => 'udetor_courses_grid_columns',
    'label'       => esc_html__( 'Grid Columns', 'udetor' ),
    'section'     => 'udetor_section_courses_list',
    'default'     => '3',
    'priority'    => $priority++,
    'multiple'    => 1,
    'choices'     => array(
        '1' => esc_attr__( '1', 'udetor' ),
        '2' => esc_attr__( '2', 'udetor' ),
        '3' => esc_attr__( '3', 'udetor' ),      
        '4' => esc_attr__( '4', 'udetor' ),   
    ),
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_courses_heading1',
    'label'       => '',
    'section'     => 'udetor_section_courses_list',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Course Item', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'select',
    'settings'    => 'udetor_courses_item_hover_effect',
    'label'       => esc_html__( 'Images Hover Effect', 'udetor' ),
    'section'     => 'udetor_section_courses_list',
    'default'     => '2',
    'priority'    => $priority++,
    'multiple'    => 1,
    'choices'     => array(
        '1' => esc_attr__( 'None', 'udetor' ),
        '2' => esc_attr__( 'Zoom In', 'udetor' ),                     
    ),
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'select',
    'settings'    => 'udetor_courses_item_grid_style',
    'label'       => esc_html__( 'Item Grid Style', 'udetor' ),
    'section'     => 'udetor_section_courses_list',
    'default'     => 'default',
    'priority'    => $priority++,
    'multiple'    => 1,
    'choices'     => array(
        'default' => esc_attr__( 'Default', 'udetor' ),
        'style-1' => esc_attr__( 'Style 1', 'udetor' ), 
        'style-2' => esc_attr__( 'Style 2', 'udetor' ), 
        'style-3' => esc_attr__( 'Multi color', 'udetor' ),                     
    ),
) );



/**
 * Add the Courses Detail section
 */

Kirki::add_section( 'udetor_section_courses_detail', array(
    'title'      => esc_attr__( 'Courses Detail', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_courses',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_courses_heading2',
    'label'       => '',
    'section'     => 'udetor_section_courses_detail',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'General', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'image',
    'settings'    => 'udetor_courses_detail_headerbg_img',
    'label'       => esc_html__( 'Header Background Image', 'udetor' ),
    'description' => esc_html__( 'This is the control description', 'udetor' ),

    'help'        => esc_html__( 'This is some extra help text.', 'udetor' ),
    'section'     => 'udetor_section_courses_detail',
    'default'     => '',
    'priority'   => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_courses_detail_show_page_title',
    'label'       => esc_html__( 'Show Page Title', 'udetor' ),
    'section'     => 'udetor_section_courses_detail',
    'default'     => '1',
    'priority'    => $priority++,
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_courses_detail_show_breadcrumb',
    'label'       => esc_html__( 'Show Breadcrumb', 'udetor' ),
    'section'     => 'udetor_section_courses_detail',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_courses_detail_show_features',
    'label'       => esc_html__( 'Show Course Features', 'udetor' ),
    'section'     => 'udetor_section_courses_detail',
    'default'     => '1',
    'priority'    => $priority++,
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_courses_detail_show_social_share',
    'label'       => esc_html__( 'Show Social Share', 'udetor' ),
    'section'     => 'udetor_section_courses_detail',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_courses_heading3',
    'label'       => '',
    'section'     => 'udetor_section_courses_detail',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Main Information', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_courses_detail_show_goals',
    'label'       => esc_html__( 'Show Course Goals', 'udetor' ),
    'section'     => 'udetor_section_courses_detail',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_courses_detail_show_intro',
    'label'       => esc_html__( 'Show Intro Video/Media', 'udetor' ),
    'section'     => 'udetor_section_courses_detail',
    'default'     => '1',
    'priority'    => $priority++,
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-image',
    'settings'    => 'udetor_courses_detail_sidebar_layout',
    'label'       => esc_html__( 'Sidebar Layout', 'udetor' ),
    'section'     => 'udetor_section_courses_detail',
    'default'     => 'right-sidebar',
    'priority'    => $priority++,
    'choices'     => array(
        'right-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/sidebar-right.svg',
        'left-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/sidebar-left.svg',
        'no-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/body-full.svg',
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_courses_heading4',
    'label'       => '',
    'section'     => 'udetor_section_courses_detail',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Extra information', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_courses_detail_extra_show_des',
    'label'       => esc_html__( 'Show Description', 'udetor' ),
    'section'     => 'udetor_section_courses_detail',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_courses_detail_extra_show_curriculum',
    'label'       => esc_html__( 'Show Curriculum', 'udetor' ),
    'section'     => 'udetor_section_courses_detail',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_courses_detail_extra_show_instructor',
    'label'       => esc_html__( 'Show Instructor', 'udetor' ),
    'section'     => 'udetor_section_courses_detail',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_courses_detail_extra_show_reviews',
    'label'       => esc_html__( 'Show Reviews', 'udetor' ),
    'section'     => 'udetor_section_courses_detail',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-image',
    'settings'    => 'udetor_courses_detail_layout_tab_extra',
    'label'       => esc_html__( 'Layout of Extra', 'udetor' ),
    'section'     => 'udetor_section_courses_detail',
    'default'     => 'vertical',
    'priority'    => $priority++,
    'choices'     => array(
        'vertical'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/tab/tab_tab_1.svg',
        'horizontal' => get_parent_theme_file_uri() . '/assets/udetor/images/admin/tab/tab_tab_2.svg',
        'full-content'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/tab/tab_tab_3.svg',
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_courses_heading5',
    'label'       => '',
    'section'     => 'udetor_section_courses_detail',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Other Courses', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_courses_detail_other_show_related',
    'label'       => esc_html__( 'Show Related Courses', 'udetor' ),
    'section'     => 'udetor_section_courses_detail',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'     => 'textarea',
    'settings' => 'udetor_courses_detail_related_txt_heading',
    'label'    => esc_html__( 'Related Text Heading', 'udetor' ),
    'section'  => 'udetor_section_courses_detail',
    'default'  => esc_attr__( 'We have different educations that you can be interested in', 'udetor' ),
    'priority' => $priority++,
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_courses_detail_other_show_related',
            'operator' => '==',
            'value'    => '1',
        ),
    )
) );


/**
 * Add the Lesson/Topic Page section
 */

Kirki::add_section( 'udetor_section_courses_lesson', array(
    'title'      => esc_attr__( 'Lesson/Topic Page', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_courses',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-image',
    'settings'    => 'udetor_courses_lesson_layouts',
    'label'       => esc_html__( 'Layouts', 'udetor' ),
    'section'     => 'udetor_section_courses_lesson',
    'default'     => 'left-sidebar',
    'priority'    => $priority++,
    'choices'     => array(        
        'right-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/sidebar-right.svg',
        'left-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/sidebar-left.svg',
        'no-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/body-full.svg',
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'     => 'text',
    'settings' => 'udetor_courses_lesson_subheading',
    'label'    => esc_html__( 'Sub Heading', 'udetor' ),
    'section'  => 'udetor_section_courses_lesson',
    'default'  => '',
    'priority' => $priority++,
) );
