<?php
$priority = 40;

Kirki::add_panel( 'udetor_panel_color', array(
    'priority'    => $priority++,
    'title'       => esc_html__( 'Color', 'udetor' ),
    'description' => esc_html__( 'Color', 'udetor' ),
) );

/**
 * Add the color general control
 */

Kirki::add_section( 'udetor_section_color_general', array(
    'title'      => esc_attr__( 'General', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_color',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_primary',
    'label'       => esc_html__( 'Primary Color', 'udetor' ),
    'section'     => 'udetor_section_color_general',
    'default'     => '#1ba590',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
            array(
                'element'  => '#espresso-thank-you-page-ajax-payment-dv .section-heading:before, #espresso-thank-you-page-ajax-transaction-dv > h3:before, .ee-registration-details-h3:before,.spco-ticket-info-dv h5:before, .spco-attendee-panel-dv fieldset.ee-reg-form-attendee-dv .spco-attendee-lgnd:before, #buddypress span.activity,#buddypress div.item-list-tabs#object-nav li.current.selected a,.udetor-detail-title:after,.single-course-social a,.udetor-carousel .owl-dots .owl-dot.active,.udetor-counter-box .counter-label:before,.udetor-social-link-widget li:hover, .udetor-social-share a:hover, .widget_udetor_contact_info .social-link-footer a:hover, .social-share-icon li:hover,.dots-big.udetor-carousel .owl-dots .owl-dot.active span,.home-edusite-contact .contact-title, .sidebar .widget .widget-title,.rtl .learndash_course_tabs .udetor-tab-menu a.active,.learndash_course_tabs .udetor-tab-menu a.active,.switch-layout-container,.sidebar-title, .edu-element-hmenu-mega .menu-mobile-effect span,.owl-theme .owl-dots .owl-dot.active span, .owl-theme .owl-dots .owl-dot:hover span, .dropcap-bg-primary-color, .netbase-toolkit.our_team.dots-line.udetor-carousel .owl-dots .owl-dot.active,.list2-upcoming-event .e-thumb .l2-date-event,.post-style-wave .featured-date,.comment .left-item-wap .left-item:hover,.nbauthor-bio ul li:hover,body.wpb-js-composer .vc_tta-color-grey.vc_tta-style-outline .vc_tta-panel .vc_tta-panel-heading:hover,body.wpb-js-composer .vc_tta-color-grey.vc_tta-style-outline .vc_active.vc_tta-panel .vc_tta-panel-heading,.about-txt1:before,.about-us-icon .vc_icon_element-inner:hover,.btn-style2:hover,.btn-our-team,.blog-pagination span,.blog-pagination a:hover span,.wpnetbase_review_row .wpnetbase_perc_rating,.wpb-js-composer .vc_tta-color-white.tabs-edusite-style .vc_tta-tab.vc_active>a, .wpb-js-composer .vc_tta-color-white.vc_tta-style-classic.tabs-edusite-style .vc_tta-tab.vc_active>a, .ui-accordion .ui-state-default.ui-accordion-header-active,
                .ui-accordion .ui-state-default.ui-accordion-header:hover,.bg-color-primary,
                .package_featured .pricetable .plan.planedu .price, .package_featured .pricetable .plan.planedu a.built-in-btn, .udetor-pricetable:hover .pricetable .plan.planedu a.built-in-btn, .udetor-pricetable:hover .pricetable .plan.planedu .price,.woocommerce ul.products li.product .u-buttons .add_to_cart_button, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .woocommerce .widget_price_filter .ui-slider .ui-slider-range, .netbase-toolkit-mini-cart a.cart-contents .count,.woocommerce span.onsale, .woocommerce ul.products li.product .onsale,.udetor-filter-courses-widget li.cat_current a:before, .udetor-filter-courses-widget li.type_current a:before,.udetor-filter-courses-widget li.skill_current a:before, .spinner:not(:required):before',
                'property' => 'background-color',
                
            ),
            array(
                'element' => '.learndash_course_tabs.vertical .udetor-tab-menu >a.active:after, .wpb-js-composer .vc_tta-tabs-position-left.tabs-edusite-style .vc_tta-tab.vc_active:after',
                'property' => 'border-left-color',
            ),
            array(
                'element' => '.rtl .learndash_course_tabs.vertical .udetor-tab-menu >a.active:after, .rtl.wpb-js-composer .vc_tta-tabs-position-left.tabs-edusite-style .vc_tta-tab.vc_active:after',
                'property' => 'border-right-color',
            ),
            array(
                'element' => '#buddypress div.item-list-tabs#object-nav li.current.selected a:after,.learndash_course_tabs.horizontal .udetor-tab-menu >a.active:after,.netbase-toolkit-mini-cart .widget_shopping_cart_content,.woocommerce-info',
                'property' => 'border-top-color',
            ),
            array(
                'element' => '#buddypress div.item-list-tabs ul li.current a, #buddypress div.item-list-tabs ul li.selected a,.udetor-simplemodal-login .simplemodal-login-box:before,.woocommerce div.product .woocommerce-tabs ul.tabs li.active',
                'property' => 'border-bottom-color',
            ),
            array(
                'element' => '.ee-attention,#buddypress div.item-list-tabs#object-nav li.current.selected a,.simplemodal-login-box,.list-post-grid-btn a,.dots-big.udetor-carousel .owl-dots .owl-dot.active,.rtl .learndash_course_tabs .udetor-tab-menu a.active, .learndash_course_tabs .udetor-tab-menu a.active,.btn-style2,.widget_mc4wp_form_widget .mc4wp-form-fields input[type="email"],.nbauthor-bio ul li,.blog-pagination span,.blog-pagination a:hover span,.avage-rating-box,.wpb-js-composer .vc_tta-color-white.tabs-edusite-style .vc_tta-tab.vc_active>a, .wpb-js-composer .vc_tta-color-white.vc_tta-style-classic.tabs-edusite-style .vc_tta-tab.vc_active>a,.ui-accordion .ui-state-default.ui-accordion-header-active,
                .ui-accordion .ui-state-default.ui-accordion-header:hover,.package_featured .pricetable .plan.planedu,.built-in-btn,.udetor-pricetable:hover .pricetable .plan.planedu,.countdown-green .education-time-countdown>div,#activity-kindergarten .services:hover',
                'property' => 'border-color',
            ),
            array(
                'element' => '
                .tkt-slctr-tbl .tckt-slctr-tbl-td-price, .entry-content .spco-ticket-info-dv table tbody tr td,  .entry-content .spco-step-dv tbody tr.spco-grand-total td:last-child, .entry-content .spco-step-dv .spco-payment-info-dv tbody .item td:first-child,
                #buddypress div.item-list-tabs ul li a:hover,#buddypress div.item-list-tabs#object-nav li a:hover,.learndash_topic_dots .topic_title i,.sidebar .widget a:hover,.learndash_course_tabs .udetor-tab-menu a .fa,.course-features-item .fa,.current-menu-ancestor>a, .current-menu-parent>a, .current-menu-item>a,.color-green,.list-post.post-style-grid .blog-item .blog-author .author-wap .author a:hover,.grid-event-date .day-event,.testimonials.style-3 .testimonial-item .fa-quote-right,#Coursetab-edu6 .vc-tab-product-header li.active a,#Coursetab-edu6 .vc-tab-product-header li a:hover,footer .widget_udetor_contact_info .info li:hover i,.site-footer .txt-copyright a,.course-item-wap .gird-course-price a,.course-item-wap .meta-author a,.post-style-wave ~ .netbase-toolkit > a:hover,.comment .view-all-comment a:hover,.average-rating-value,.tckt-slctr-tbl-td-name strong,.udetor-sidebar-datetimes h3:before,.sidebar-detail-event .espresso-venue-dv h3:before,.sidebar-detail-event .espresso-venue-dv a,.small-text ~ a,.comments-area .comment-respond form.comment-form p a:hover,.nbauthor-bio ul li i,.posted-on time,.author.vcard .url,.post-footer-tag a,.udetor-event-meta .left-meta-event,.udetor-date-event, .blog-pagination a span,.comment-metadata a,.reply a,.espresso_events .entry-title a:hover,.gallery-title ul li a:hover,.custom-lst-style li:before,a.built-in-btn,.countdown-green .education-time-countdown>div, a:focus, a:hover, a,.wishlist_table td.product-price span,.wishlist_table .product-name a:hover,.woocommerce ul.products li.product .udetor-product-info .price,.u-buttons .udetor-quick-view:hover,.u-buttons .udetor-wishlist-btn:hover i,.widget_shopping_cart li .quantity .amount, .cart-product-info .amount,.woocommerce .udetor-page-cart .cart_totals table.shop_table td .amount,.woocommerce div.product p.price, .woocommerce div.product span.price,.woocommerce ul.products li.product .udetor-product-info h2:hover, .single-product div.product .summary .product_meta > span a:hover, .woocommerce div.product .woocommerce-tabs ul.tabs li.active a, .woocommerce .woocommerce-product-rating .woocommerce-review-link:hover, .woocommerce table.shop_table.woocommerce-checkout-review-order-table .order-total td span,.woocommerce-info::before, .woocommerce-MyAccount-navigation ul li a:hover, .woocommerce-MyAccount-navigation ul li.is-active a,.woocommerce .udetor-page-cart table.shop_table td.product-subtotal,.netbase-toolkit-mini-cart .widget_shopping_cart_content .total .amount, .netbase-toolkit-mini-cart .widget_shopping_cart_content ul.product_list_widget li .amount,.widget_top_rated_products .product_list_widget .amount, #fitness-tes-count .testimonial-item .name:hover',
                'property' => 'color',
            ),
           
        ),
    'js_vars'   => array(
            array(
                'element'  => '.sidebar .widget .widget-title,.learndash_course_tabs .udetor-tab-menu a.active,.switch-layout-container,.sidebar-title, .edu-element-hmenu-mega .menu-mobile-effect span, .owl-theme .owl-dots .owl-dot.active span, .owl-theme .owl-dots .owl-dot:hover span',
                'function' => 'css',
                'property' => 'background-color',
                
            ),
            array(
                'element' => '.learndash_course_tabs.vertical .udetor-tab-menu >a.active:after',
                'function' => 'css',
                'property' => 'border-left-color',
            ),
            array(
                'element' => '.learndash_course_tabs.horizontal .udetor-tab-menu >a.active:after',
                'function' => 'css',
                'property' => 'border-top-color',
            ),
            array(
                'element' => '.learndash_course_tabs .udetor-tab-menu a.active',
                'function' => 'css',
                'property' => 'border-color',
            ),
            
    ),
    
) );


Kirki::add_field( 'udetor_config', array(
	'type'        => 'custom',
	'settings'    => 'udetor_color_heading1',
	'label'       => '',
	'section'     => 'udetor_section_color_general',
	'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Bacground', 'udetor' ) . '</div>',
	'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_inner_body_bg',
    'label'       => esc_html__( 'Inner Body BG', 'udetor' ),
    'section'     => 'udetor_section_color_general',
    'default'     => '#ffffff',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
            array(
                'element'  => '.site.wrapper',
                'property' => 'background-color',
                
            ),
        ),
    'js_vars'   => array(
            array(
                'element'  => '.site.wrapper',
                'function' => 'css',
                'property' => 'background-color',                
            ),           
            
    ),
    
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_form_fields_bg',
    'label'       => esc_html__( 'Form Fields BG', 'udetor' ),
    'section'     => 'udetor_section_color_general',
    'default'     => '#f8f8f8',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
            array(
                'element'  => '#comments textarea, #comments input',
                'property' => 'background-color',                
            ),
            array(
                'element' => '#comments textarea, #comments input',
                'property' => 'border-color',
            ),
           
           
        ),
    'js_vars'   => array(
            array(
                'element'  => '#comments textarea, #comments input',
                'function' => 'css',
                'property' => 'background-color',
                
            ),
             array(
                'element' => '#comments textarea, #comments input',
                'function' => 'css',
                'property' => 'border-color',
            ),            
            
    ),
    
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_color_heading2',
    'label'       => '',
    'section'     => 'udetor_section_color_general',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Body Content', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_link',
    'label'       => esc_html__( 'Link Color', 'udetor' ),
    'section'     => 'udetor_section_color_general',
    'default'     => '#444444',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
            array(
                'element'  => '.course-item .entry-title a, .blog-item .entry-title a,.lst_upcoming_events .entry-title a,.sidebar ul li a,
                .relatedposts-title a, .simplemodal-login-box a, .entry-course .lst-author a,#Event-edu6 .lst_upcoming_events > a',
                'property' => 'color',
                
            ),
           
        ),
    'js_vars'   => array(
            array(
                'element'  => '.course-item .entry-title a, .blog-item .entry-title a,.lst_upcoming_events .entry-title a,.sidebar ul li a,
                .relatedposts-title a, .simplemodal-login-box a, .entry-course .lst-author a',
                'function' => 'css',
                'property' => 'color',
                
            ),
            
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_link_hover',
    'label'       => esc_html__( 'Link Hover Color', 'udetor' ),
    'section'     => 'udetor_section_color_general',
    'default'     => '#1ba590',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
            array(
                'element'  => '.course-item .entry-title a:hover, .blog-item .entry-title a:hover,.lst_upcoming_events .entry-title a:hover,
                .sidebar ul li a:hover, .relatedposts-title a:hover, .post-meta a:hover, .simplemodal-login-box a:hover, .entry-course .lst-author a:hover, #learndash_course_content .expand_collapse a:hover, #learndash_course_content .topic_item a:hover span, #lessons_list > div  h4 > a:hover,#Event-edu6 .lst_upcoming_events > a:hover',
                'property' => 'color',
                
            ),
           
    ),
    'js_vars'   => array(
            array(
                'element'  => '.course-item .entry-title a:hover, .blog-item .entry-title a:hover,.lst_upcoming_events .entry-title a:hover,
                .sidebar ul li a:hover, .relatedposts-title a:hover, .post-meta a:hover, .simplemodal-login-box a:hover,.entry-course .lst-author a:hover, #learndash_course_content .expand_collapse a:hover, #learndash_course_content .topic_item a:hover span, #lessons_list > div  h4 > a:hover',
                'function' => 'css',
                'property' => 'color',
                
            ),
            
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_text',
    'label'       => esc_html__( 'Text', 'udetor' ),
    'section'     => 'udetor_section_color_general',
    'default'     => '#444444',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_entry_meta',
    'label'       => esc_html__( 'Entry Meta', 'udetor' ),
    'section'     => 'udetor_section_color_general',
    'default'     => '#999999',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
            array(
                'element'  => '.post-meta a, .post-meta',
                'property' => 'color',
                
            ),
           
        ),
    'js_vars'   => array(
            array(
                'element'  => '.post-meta a, .post-meta',
                'function' => 'css',
                'property' => 'color',
                
            ),
            
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_line',
    'label'       => esc_html__( 'Line', 'udetor' ),
    'section'     => 'udetor_section_color_general',
    'default'     => '#eeeeee',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
            array(
                'element'  => '.udetor-course-meta, .widget_rss ul li, .datetimes-wap, .row.review-bar-wap',
                'property' => 'border-color',                
            ),
           
        ),
    'js_vars'   => array(
            array(
                'element'  => '.udetor-course-meta, .widget_rss ul li, .datetimes-wap, .row.review-bar-wap',
                'function' => 'css',
                'property' => 'border-color',                
            ),            
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_border',
    'label'       => esc_html__( 'Border', 'udetor' ),
    'section'     => 'udetor_section_color_general',
    'default'     => '#eeeeee',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'output' => array(
            array(
                'element'  => '.udetor-tab-content,.learndash_course_tabs .udetor-tab-menu a',
                'property' => 'border-color',
                
            ),
           
    ),
    
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'goto-panel',
    'settings'    => 'udetor_color_go_layout',
    'label'       => 'Customize Layout',
    'choices'     =>  array('udetor_panel_layout'),
    'section'     => 'udetor_section_color_general',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'goto-panel',
    'settings'    => 'udetor_color_go_typography',
    'label'       => 'Customize Typography',
    'choices'     =>  array('udetor_panel_typography'),
    'section'     => 'udetor_section_color_general',
    'priority'    => $priority++,
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_nav_icon',
    'label'       => esc_html__( 'Navigation Icon ( Prev / Next )', 'udetor' ),
    'section'     => 'udetor_section_color_general',
    'default'     => '#1ba590',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
            array(
                'element'  => '.nav-links .page-numbers.current, .udetor-paging-navigation .pagination .page-numbers.current,
                .nav-links .page-numbers:hover, .udetor-paging-navigation .pagination .page-numbers:hover',
                'property' => 'color',
                
            ),
            array(
                'element' => '.nav-links .page-numbers.current, .udetor-paging-navigation .pagination .page-numbers.current,
                .nav-links .page-numbers:hover, .udetor-paging-navigation .pagination .page-numbers:hover',
                'property' => 'border-color',
            ),
           
           
        ),
    'js_vars'   => array(
            array(
                'element'  => '.nav-links .page-numbers.current, .udetor-paging-navigation .pagination .page-numbers.current,
                .nav-links .page-numbers:hover, .udetor-paging-navigation .pagination .page-numbers:hover',
                'function' => 'css',
                'property' => 'color',
                
            ),
             array(
                'element' => '.nav-links .page-numbers.current, .udetor-paging-navigation .pagination .page-numbers.current,
                .nav-links .page-numbers:hover, .udetor-paging-navigation .pagination .page-numbers:hover',
                'function' => 'css',
                'property' => 'border-color',
            ),
            
            
    ),
    
) );


/**
 * Add the color page title section
 */

Kirki::add_section( 'udetor_section_color_page_title', array(
    'title'      => esc_attr__( 'Page Title', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_color',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_color_heading5',
    'label'       => '',
    'section'     => 'udetor_section_color_page_title',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Background', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_pagetitle_bg',
    'label'       => esc_html__( 'Background Color', 'udetor' ),
    'section'     => 'udetor_section_color_page_title',
    'default'     => '#3D3F3E',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'output' => array(
            array(
                'element'  => '.udetor-page-title',
                'property' => 'background-color',
                
            ),
           
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'image',
    'settings'    => 'udetor_color_pagetitle_bg_img',
    'label'       => esc_html__( 'Background Image', 'udetor' ),
    'description' => esc_html__( 'This is the control description', 'udetor' ),
    
    'section'     => 'udetor_section_color_page_title',
    'default'     => '',
    'priority'   => $priority++,
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_color_heading6',
    'label'       => '',
    'section'     => 'udetor_section_color_page_title',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Content page title', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_pagetitle_txt',
    'label'       => esc_html__( 'Text', 'udetor' ),
    'section'     => 'udetor_section_color_page_title',
    'default'     => '#f8f8f8',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    
    'transport' => 'postMessage',
    'output' => array(
            array(
                'element'  => '.udetor-page-title .entry-title,.udetor-page-title .udetor-breadcrumbs li, .udetor-page-title .udetor-breadcrumbs a, .ld-subheading',
                'property' => 'color',                
            ),
           
        ),
    'js_vars'   => array(
            array(
                'element'  => '.udetor-page-title .entry-title,.udetor-page-title .udetor-breadcrumbs li, .udetor-page-title .udetor-breadcrumbs a,.ld-subheading',
                'function' => 'css',
                'property' => 'color',                
            ),            
    ),
    
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_pagetitle_link_hover',
    'label'       => esc_html__( 'Link Hover', 'udetor' ),
    'section'     => 'udetor_section_color_page_title',
    'default'     => '#1ba590',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'output' => array(
            array(
                'element'  => '.udetor-page-title .udetor-breadcrumbs a:hover, .info-header-page a:hover',
                'property' => 'color',                
            ),
           
        ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'goto-panel',
    'settings'    => 'udetor_color_pagetitle_go_layout',
    'label'       => 'Customize Layout',
    'choices'     =>  array('udetor_panel_layout'),
    'section'     => 'udetor_section_color_page_title',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'goto-panel',
    'settings'    => 'udetor_color_pagetitle_go_typography',
    'label'       => 'Customize Typography',
    'choices'     =>  array('udetor_panel_typography'),
    'section'     => 'udetor_section_color_page_title',
    'priority'    => $priority++,
) );

/**
 * Add the color Element button section
 */

Kirki::add_section( 'udetor_section_color_element_button', array(
    'title'      => esc_attr__( 'Element Button', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_color',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_color_element_btn_prestyle',
    'label'       => esc_html__( 'User Prestyle Color', 'udetor' ),
    'section'     => 'udetor_section_color_element_button',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_color_heading9',
    'label'       => '',
    'section'     => 'udetor_section_color_element_button',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Primary', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_element_btn_bg',
    'label'       => esc_html__( 'Background', 'udetor' ),
    'section'     => 'udetor_section_color_element_button',
    'default'     => '#1BA590',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),

    'transport' => 'postMessage',
    'output' => array(
            array(
                'element'  => '
                #buddypress .comment-reply-link, #buddypress .generic-button a, #buddypress .standard-form button, #buddypress a.button, #buddypress input[type=button], #buddypress input[type=reset], #buddypress input[type=submit], #buddypress ul.button-nav li a, a.bp-title-button,
                .ld-entry-content.course-item.style-1 .course-apply a,.btn,.udetor-course-meta .udetor-course-price a,input[type="submit"],.secondary_btn,#comments input[type="submit"],.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,.woocommerce.widget_shopping_cart .buttons a,.woocommerce .widget_price_filter .price_slider_amount .button,.woocommerce ul.products.udetor-layout-list li.product .u-buttons .add_to_cart_button,.udetor-page-cart tbody tr td.actions  button,.netbase-toolkit-mini-cart .widget_shopping_cart_content .buttons a,.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,.btn-color',
                'property' => 'background-color',
                
            ),
           
        ),
    'js_vars'   => array(
            array(
                'element'  => '
                #buddypress .comment-reply-link, #buddypress .generic-button a, #buddypress .standard-form button, #buddypress a.button, #buddypress input[type=button], #buddypress input[type=reset], #buddypress input[type=submit], #buddypress ul.button-nav li a, a.bp-title-button,
                .ld-entry-content.course-item.style-1 .course-apply a,.btn,.udetor-course-meta .udetor-course-price a,input[type="submit"],.secondary_btn,#comments input[type="submit"],.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt ',
                'function' => 'css',
                'property' => 'background-color',
                
            ),
            
    ),  
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_element_btn_bg_hover',
    'label'       => esc_html__( 'Background Hover', 'udetor' ),
    'section'     => 'udetor_section_color_element_button',
    'default'     => '#155d6d',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
            array(
                'element'  => '
                #buddypress .comment-reply-link:hover, #buddypress .generic-button a:hover, #buddypress .standard-form button:hover, #buddypress a.button:hover, #buddypress input[type=button]:hover, #buddypress input[type=reset]:hover, #buddypress input[type=submit]:hover, #buddypress ul.button-nav li a:hover, a.bp-title-button:hover,
                .ld-entry-content.course-item.style-1 .course-apply a:hover,.btn:hover,input[type="submit"]:hover,.secondary_btn:hover,#comments input[type="submit"]:hover,.udetor-course-meta .udetor-course-price a:hover,.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover,.woocommerce.widget_shopping_cart .buttons a:hover,.woocommerce .widget_price_filter .price_slider_amount .button:hover, .woocommerce ul.products.udetor-layout-list li.product .u-buttons .add_to_cart_button:hover, .udetor-page-cart tbody tr td.actions  button:hover,.netbase-toolkit-mini-cart .widget_shopping_cart_content .buttons a:hover,.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover,.btn-color:hover ',
                'property' => 'background-color',
                
            ),
           
        ),
    'js_vars'   => array(
            array(
                'element'  => '.ld-entry-content.course-item.style-1 .course-apply a:hover,.btn:hover,input[type="submit"]:hover,.secondary_btn:hover,#comments input[type="submit"]:hover,.udetor-course-meta .udetor-course-price a:hover ',
                'function' => 'css',
                'property' => 'background-color',
                
            ),            
    ), 
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_element_btn_txt',
    'label'       => esc_html__( 'Text', 'udetor' ),
    'section'     => 'udetor_section_color_element_button',
    'default'     => '#f8f8f8',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
            array(
                'element'  => '
                #buddypress .comment-reply-link, #buddypress .generic-button a, #buddypress .standard-form button, #buddypress a.button, #buddypress input[type=button], #buddypress input[type=reset], #buddypress input[type=submit], #buddypress ul.button-nav li a, a.bp-title-button,
                .ld-entry-content.course-item.style-1 .course-apply a,.btn,input[type="submit"],.secondary_btn,#comments input[type="submit"],.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,.woocommerce.widget_shopping_cart .buttons a, .woocommerce .widget_price_filter .price_slider_amount .button,.woocommerce ul.products.udetor-layout-list li.product .u-buttons .add_to_cart_button,.udetor-page-cart tbody tr td.actions button, .netbase-toolkit-mini-cart .widget_shopping_cart_content .buttons a,.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,.btn-color ',
                'property' => 'color',
                
            ),           
        ),
    'js_vars'   => array(
            array(
                'element'  => '.ld-entry-content.course-item.style-1 .course-apply a,.btn,input[type="submit"],.secondary_btn,#comments input[type="submit"] ',
                'function' => 'css',
                'property' => 'color',
                
            ),            
    ), 
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_element_btn_txt_hover',
    'label'       => esc_html__( 'Text Hover', 'udetor' ),
    'section'     => 'udetor_section_color_element_button',
    'default'     => '#f8f8f8',
    'priority'    => $priority++,
    'choices'     => array(
    'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
            array(
                'element'  => '
                #buddypress .comment-reply-link:hover, #buddypress .generic-button a:hover, #buddypress .standard-form button:hover, #buddypress a.button:hover, #buddypress input[type=button]:hover, #buddypress input[type=reset]:hover, #buddypress input[type=submit]:hover, #buddypress ul.button-nav li a:hover, a.bp-title-button:hover,
                .ld-entry-content.course-item.style-1 .course-apply a:hover,.btn:hover,input[type="submit"]:hover,.secondary_btn:hover,#comments input[type="submit"]:hover, .udetor-course-meta .udetor-course-price:hover a,.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover,.woocommerce.widget_shopping_cart .buttons a:hover, .woocommerce .widget_price_filter .price_slider_amount .button:hover,.woocommerce ul.products.udetor-layout-list li.product .u-buttons .add_to_cart_button:hover, .udetor-page-cart tbody tr td.actions button:hover,.netbase-toolkit-mini-cart .widget_shopping_cart_content .buttons a:hover,.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover,.btn-color:hover',
                'property' => 'color',
                
            ),           
        ),
    'js_vars'   => array(
            array(
                'element'  => '.ld-entry-content.course-item.style-1 .course-apply a:hover,.btn:hover,input[type="submit"]:hover,.secondary_btn:hover,#comments input[type="submit"]:hover, .udetor-course-meta .udetor-course-price:hover a ',
                'function' => 'css',
                'property' => 'color',
                
            ),            
    ), 
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_element_btn_border',
    'label'       => esc_html__( 'Border', 'udetor' ),
    'section'     => 'udetor_section_color_element_button',
    'default'     => '#1BA590',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
            array(
                'element'  => '
                #buddypress .comment-reply-link, #buddypress .generic-button a, #buddypress .standard-form button, #buddypress a.button, #buddypress input[type=button], #buddypress input[type=reset], #buddypress input[type=submit], #buddypress ul.button-nav li a, a.bp-title-button,
                .btn,input[type="submit"],.secondary_btn,#comments input[type="submit"],.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,.woocommerce.widget_shopping_cart .buttons a, .woocommerce .widget_price_filter .price_slider_amount .button,.woocommerce ul.products.udetor-layout-list li.product .u-buttons .add_to_cart_button, .udetor-page-cart tbody tr td.actions button,.netbase-toolkit-mini-cart .widget_shopping_cart_content .buttons a,.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,.btn-color ',
                'property' => 'border-color',
                
            ),           
        ),
    'js_vars'   => array(
            array(
                'element'  => '.btn,input[type="submit"],.secondary_btn,#comments input[type="submit"] ',
                'function' => 'css',
                'property' => 'border-color',
                
            ),            
    ), 
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_element_btn_border_hover',
    'label'       => esc_html__( 'Border Hover', 'udetor' ),
    'section'     => 'udetor_section_color_element_button',
    'default'     => '#155d6d',
    'priority'    => $priority++,
    'choices'     => array(
    'alpha' => true,
    ),
    'transport' => 'postMessage',
    'output' => array(
            array(
                'element'  => '
                #buddypress .comment-reply-link:hover, #buddypress .generic-button a:hover, #buddypress .standard-form button:hover, #buddypress a.button:hover, #buddypress input[type=button]:hover, #buddypress input[type=reset]:hover, #buddypress input[type=submit]:hover, #buddypress ul.button-nav li a:hover, a.bp-title-button:hover,
                .btn:hover,input[type="submit"]:hover,.secondary_btn:hover,#comments input[type="submit"]:hover,.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover,.woocommerce.widget_shopping_cart .buttons a:hover, .woocommerce .widget_price_filter .price_slider_amount .button:hover, .woocommerce ul.products.udetor-layout-list li.product .u-buttons .add_to_cart_button:hover, .udetor-page-cart tbody tr td.actions button:hover,.netbase-toolkit-mini-cart .widget_shopping_cart_content .buttons a:hover,.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover,.btn-color:hover',
                'property' => 'border-color',
                
            ),           
        ),
    'js_vars'   => array(
            array(
                'element'  => '.btn:hover,input[type="submit"]:hover,.secondary_btn:hover,#comments input[type="submit"]:hover ',
                'function' => 'css',
                'property' => 'border-color',
                
            ),            
    ), 
    
) );


/**
 * Add the color Footer section
 */

Kirki::add_section( 'udetor_section_color_footer', array(
    'title'      => esc_attr__( 'Footer- Copyright', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_color',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_color_footer_global_enable',
    'label'       => esc_html__( 'User Global Color', 'udetor' ),
    'section'     => 'udetor_section_color_footer',
    'default'     => '0',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_color_heading17',
    'label'       => '',
    'section'     => 'udetor_section_color_footer',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Footer', 'udetor' ) . '</div>',
    'priority'    => $priority++,
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_color_footer_global_enable',
            'operator' => '==',
            'value'    => '0',
        ),
    ),
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_footer_bg',
    'label'       => esc_html__( 'Background Color', 'udetor' ),
    'section'     => 'udetor_section_color_footer',
    'default'     => '#111111',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'output' => array(
        array(
            'element'  => '.site-footer',
            'property' => 'background-color',            
        ),       
    ),
    'js_vars'   => array(
        array(
            'element'  => '.site-footer',
            'function' => 'css',
            'property' => 'background-color',            
        ),        
    ),
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_color_footer_global_enable',
            'operator' => '==',
            'value'    => '0',
        ),
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'image',
    'settings'    => 'udetor_color_footer_bg_img',
    'label'       => esc_html__( 'Background Image', 'udetor' ),
    'description' => esc_html__( 'This is the control description', 'udetor' ),

    'help'        => esc_html__( 'This is some extra help text.', 'udetor' ),
    'section'     => 'udetor_section_color_footer',
    'default'     => '',
    'priority'   => $priority++,
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_color_footer_global_enable',
            'operator' => '==',
            'value'    => '0',
        ),
    ),
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_color_footer_bg_parallax',
    'label'       => esc_html__( 'Background Parallax', 'udetor' ),
    'section'     => 'udetor_section_color_footer',
    'default'     => '0',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_footer_txt',
    'label'       => esc_html__( 'Text', 'udetor' ),
    'section'     => 'udetor_section_color_footer',
    'default'     => '#999999',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'output' => array(
        array(
            'element'  => '.site-footer,.widget_udetor_contact_info .info li',
            'property' => 'color',
            
        ),
       
    ),
    'js_vars'   => array(
        array(
            'element'  => '.site-footer',
            'function' => 'css',
            'property' => 'color',
            
        ),
        
    ),
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_color_footer_global_enable',
            'operator' => '==',
            'value'    => '0',
        ),
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_footer_heading',
    'label'       => esc_html__( 'Heading', 'udetor' ),
    'section'     => 'udetor_section_color_footer',
    'default'     => '#FFFFFF',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_color_footer_global_enable',
            'operator' => '==',
            'value'    => '0',
        ),
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_footer_link',
    'label'       => esc_html__( 'Link', 'udetor' ),
    'section'     => 'udetor_section_color_footer',
    'default'     => '#999999',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'output' => array(
        array(
            'element'  => '.site-footer a',
            'property' => 'color',
            
        ),
       
    ),
    'js_vars'   => array(
        array(
            'element'  => '.site-footer a',
            'function' => 'css',
            'property' => 'color',
            
        ),
        
    ),
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_color_footer_global_enable',
            'operator' => '==',
            'value'    => '0',
        ),
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_footer_link_hover',
    'label'       => esc_html__( 'Link Hover', 'udetor' ),
    'section'     => 'udetor_section_color_footer',
    'default'     => '#1BA590',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'output' => array(
        array(
            'element'  => '.site-footer a:hover',
            'property' => 'color',
            
        ),
       
    ),
    'js_vars'   => array(
        array(
            'element'  => '.site-footer a:hover',
            'function' => 'css',
            'property' => 'color',
            
        ),
        
    ),
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_color_footer_global_enable',
            'operator' => '==',
            'value'    => '0',
        ),
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_color_footer_heading1',
    'label'       => '',
    'section'     => 'udetor_section_color_footer',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Bottom Footer', 'udetor' ) . '</div>',
    'priority'    => $priority++,
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_footer_copyright_txt',
    'label'       => esc_html__( 'Copyright Text Color', 'udetor' ),
    'section'     => 'udetor_section_color_footer',
    'default'     => '#1BA590',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'output' => array(
        array(
            'element'  => '.bottom-footer',
            'property' => 'color',
            
        ),
       
    ),
    'js_vars'   => array(
        array(
            'element'  => '.bottom-footer',
            'function' => 'css',
            'property' => 'color',
            
        ),
        
    ),
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_color_footer_global_enable',
            'operator' => '==',
            'value'    => '0',
        ),
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'color',
    'settings'    => 'udetor_color_footer_bottom_bg',
    'label'       => esc_html__( 'Background Color', 'udetor' ),
    'section'     => 'udetor_section_color_footer',
    'default'     => '#000000',
    'priority'    => $priority++,
    'choices'     => array(
        'alpha' => true,
    ),
    'output' => array(
        array(
            'element'  => '.bottom-footer',
            'property' => 'background-color',
            
        ),
       
    ),
    'js_vars'   => array(
        array(
            'element'  => '.bottom-footer',
            'function' => 'css',
            'property' => 'background-color',
            
        ),
        
    ),
    'active_callback'  => array(        
        array(
            'setting'  => 'udetor_color_footer_global_enable',
            'operator' => '==',
            'value'    => '0',
        ),
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'goto-panel',
    'settings'    => 'udetor_color_footer_go_layout',
    'label'       => 'Customize Layout',
    'choices'     =>  array('udetor_panel_layout'),
    'section'     => 'udetor_section_color_footer',
    'priority'    => $priority++,

) );
