<?php
/**
 * Add the layout section
 */

$priority = 50;
Kirki::add_panel( 'udetor_panel_blog', array(
    'priority'    => $priority++,
    'title'       => esc_html__( 'Blog', 'udetor' ),
    'description' => esc_html__( 'Blog', 'udetor' ),
) );

/**
 * Add the Blog List section
 */
Kirki::add_section( 'udetor_section_blog_list', array(
    'title'      => esc_attr__( 'Blog List', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_blog',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-image',
    'settings'    => 'udetor_blog_list_layout',
    'label'       => esc_html__( 'Layouts', 'udetor' ),
    'section'     => 'udetor_section_blog_list',
    'default'     => 'right-sidebar',
    'priority'    => $priority++,
    'choices'     => array(
        'right-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/sidebar-right.svg',
        'left-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/sidebar-left.svg',
        'no-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/body-full.svg',
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-image',
    'settings'    => 'udetor_blog_list_grid_columns',
    'label'       => esc_html__( 'Grid Columns', 'udetor' ),
    'section'     => 'udetor_section_blog_list',
    'default'     => '3',
    'priority'    => $priority++,
    'choices'     => array(
        '1'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/cols-1.jpg',
        '2' => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/cols-2.png',
        '3'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/cols-3.png',
        '4'  => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/cols-4.png',
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'sidebar-dropdown',
    'settings'    => 'udetor_blog_list_sidebar_content',
    'label'       => esc_html__( 'Sidebar Content', 'udetor' ),
    'section'     => 'udetor_section_blog_list',
    'default'     => 'sidebar-1',
    'priority'    => $priority++,    
    
) );

 

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_blog_list_hidden_page_title',
    'label'       => esc_html__( 'Hidden Page Title', 'udetor' ),
    'section'     => 'udetor_section_blog_list',
    'default'     => '0',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_blog_list_hidden_breadcrumb',
    'label'       => esc_html__( 'Hidden Breadcrumb', 'udetor' ),
    'section'     => 'udetor_section_blog_list',
    'default'     => '0',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'     => 'text',
    'settings' => 'udetor_blog_list_sub_heading',
    'label'    => esc_html__( 'Sub Heading', 'udetor' ),
    'section'  => 'udetor_section_blog_list',
    'default'  => '',
    'priority' => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_blog_list_excerpt_length',
    'label'       => esc_html__( 'Excerpt Length', 'udetor' ),
    'section'     => 'udetor_section_blog_list',
    'default'     => 20,
    'choices'     => array(
        'min'  => '0',
        'max'  => '50',
        'step' => '5',
    ),
    'priority'   => $priority++,
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_blog_list_show_post_nav',
    'label'       => esc_html__( 'Show Post Navigation', 'udetor' ),
    'section'     => 'udetor_section_blog_list',
    'default'     => '1',
    'priority'    => $priority++,
) );


/**
 * Add the Blog List section
 */
Kirki::add_section( 'udetor_section_blog_single', array(
    'title'      => esc_attr__( 'Single Post', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_blog',
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_blog_heading',
    'label'       => '',
    'section'     => 'udetor_section_blog_single',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Post Title', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_blog_single_padding_top',
    'label'       => esc_html__( 'Padding Top', 'udetor' ),
    'section'     => 'udetor_section_blog_single',
    'default'     => 16,
    'choices'     => array(
        'min'  => '0',
        'max'  => '50',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'transport' => 'postMessage',
    'output' => array(
        array(
            'element'  => '.single-post .entry-header',
            'property' => 'padding-top',
            'units'    => 'px',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.single-post .entry-header',
            'function' => 'css',
            'property' => 'padding-top',
            'units'    => 'px',
        ),
       
    ),
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_blog_single_padding_bottom',
    'label'       => esc_html__( 'Padding Bottom', 'udetor' ),
    'section'     => 'udetor_section_blog_single',
    'default'     => 30,
    'choices'     => array(
        'min'  => '0',
        'max'  => '50',
        'step' => '1',
    ),
    'priority'   => $priority++,
    'transport' => 'postMessage',
    'output' => array(
        array(
            'element'  => '.single-post .entry-header',
            'property' => 'padding-bottom',
            'units'    => 'px',
        ),
        
    ),
    'js_vars'   => array(
        array(
            'element'  => '.single-post .entry-header',
            'function' => 'css',
            'property' => 'padding-bottom',
            'units'    => 'px',
        ),
       
    ),
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'custom',
    'settings'    => 'udetor_blog_heading1',
    'label'       => '',
    'section'     => 'udetor_section_blog_single',
    'default'     => '<div class="udetor-customize-heading">' . esc_html__( 'Post Content', 'udetor' ) . '</div>',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'radio-image',
    'settings'    => 'udetor_blog_single_content_layout',
    'label'       => esc_html__( 'Sidebar Layout', 'udetor' ),
    'section'     => 'udetor_section_blog_single',
    'default'     => 'right-sidebar',
    'priority'    => $priority++,
    'choices'     => array(
        'right-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/sidebar-right.svg',
        'left-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/sidebar-left.svg',
        'no-sidebar'   => get_parent_theme_file_uri() . '/assets/udetor/images/admin/layout/body-full.svg',
    ),
    
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_blog_single_show_social_sharing',
    'label'       => esc_html__( 'Show Social Sharing', 'udetor' ),
    'section'     => 'udetor_section_blog_single',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_blog_single_show_post_nav',
    'label'       => esc_html__( 'Show Post Navigation', 'udetor' ),
    'section'     => 'udetor_section_blog_single',
    'default'     => '1',
    'priority'    => $priority++,
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_blog_single_show_comment_area',
    'label'       => esc_html__( 'Show Comment Area', 'udetor' ),
    'section'     => 'udetor_section_blog_single',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_blog_single_show_related_posts',
    'label'       => esc_html__( 'Show Related Posts', 'udetor' ),
    'section'     => 'udetor_section_blog_single',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'slider',
    'settings'    => 'udetor_blog_single_numbers_related_post',
    'label'       => esc_html__( 'Numbers of Related Post', 'udetor' ),
    'section'     => 'udetor_section_blog_single',
    'default'     => 4,
    'choices'     => array(
        'min'  => '0',
        'max'  => '50',
        'step' => '1',
    ),
    'priority'   => $priority++,
) );

/**
 * Add the Blog List section
 */
Kirki::add_section( 'udetor_section_blog_meta_tags', array(
    'title'      => esc_attr__( 'Meta Tags', 'udetor' ),
    'priority'   => $priority++,
    'capability' => 'edit_theme_options',
    'panel'          => 'udetor_panel_blog',
) );


Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_blog_tags_show_author_info',
    'label'       => esc_html__( 'Show Author Info', 'udetor' ),
    'section'     => 'udetor_section_blog_meta_tags',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_blog_tags_show_Date',
    'label'       => esc_html__( 'Show Date', 'udetor' ),
    'section'     => 'udetor_section_blog_meta_tags',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_blog_tags_show_category',
    'label'       => esc_html__( 'Show Category', 'udetor' ),
    'section'     => 'udetor_section_blog_meta_tags',
    'default'     => '1',
    'priority'    => $priority++,
) );

Kirki::add_field( 'udetor_config', array(
    'type'        => 'toggle',
    'settings'    => 'udetor_blog_tags_show_comment_number',
    'label'       => esc_html__( 'Show Comment Number', 'udetor' ),
    'section'     => 'udetor_section_blog_meta_tags',
    'default'     => '1',
    'priority'    => $priority++,
) );
