<?php
class Udetor_Customizer {
    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;
    
    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize() {
        // Do nothing if start functions already initialized.
        if ( self::$initialized ) {
            return;
        }
    
        // Register actions to do something.
        add_action( 'customize_register'   , array( __CLASS__, 'udetor_customize_register'    ) );
        add_action( 'customize_preview_init'   , array( __CLASS__, 'udetor_customize_preview_js'    ) );
        add_filter( 'kirki/config', array( __CLASS__, 'udetor_kirki_update_url' ));
        add_action('customize_register', array( __CLASS__, 'remove_default_customize_register' ));

        /**
         * Add Kirki into theme
        */
        include_once( Udetor_Core::get_libs_path() . 'kirki/kirki.php' );

        /**
         * Load All custom Controls
        */
        self::load_all_controls();

        /**
         * Load all options
        */
        self::load_all_files();

        /**
         * Add config for theme
         */
        Kirki::add_config( 'udetor_config', array(
            'capability'    => 'edit_theme_options',
            'option_type'   => 'theme_mod',
        ) );


        /**
         * Customizer Extends
         */
        add_action( 'customize_controls_print_styles', array( __CLASS__, 'udetor_enqueue_customizer_stylesheet' ));

        // Register action to print controls.
        add_action( 'customize_controls_print_footer_scripts', array( __CLASS__, 'print_footer_scripts' ), 10, 1 );

        // State that initialization completed.
        self::$initialized = true;
    }

    /**
     * Kirki update URL config
    */
    public static function udetor_kirki_update_url( $config ) {
        $config['url_path'] = Udetor_Core::get_libs_path_url() . '/kirki/';
        return $config;
    }

    /**
     * Print inline script including but not limited to  controls dependencies data.
     *
     * @return  void
     */
    public static function print_footer_scripts() {
        // Print template for search box.
        ?>
        <!-- <div id="udetor_customize_spotlight_search" style="display: none">
            <input class="search-for" type="text" value="" placeholder="<?php echo esc_attr( esc_html_e( 'Search...', 'udetor' ) ); ?>" />
            <div class="search-results"></div>
        </div> -->
        <?php
        wp_enqueue_script( 'udetor_custom_customizer', Udetor_Assets::get_js_url() . 'admin/custom-script.js', array( 'customize-preview' ), Udetor_Core::VERSION, true );
    }


    /**
     * Load all custom controls.
     *
     * @return void
     */
    public static function load_all_controls() {
        $files = glob(Udetor_Core::get_core_path() . 'customizer/controls/*.php');
        foreach ($files as $filename){

            if( file_exists( $filename ) ) {
                include_once $filename;
            }
        }
    }

    
    /**
     * Load all customizer options.
     *
     * @return void
     */
    public static function load_all_files() {
        $files = glob(Udetor_Core::get_core_path() . 'customizer/options/*.php');
        foreach ($files as $filename){
            
            if( file_exists( $filename ) ) {
                include_once $filename;
            }
        }
    }
    
    /**
     * Add postMessage support for site title and description for the Theme Customizer.
     *
     * @param WP_Customize_Manager $wp_customize Theme Customizer object.
     */
    public static function udetor_customize_register( $wp_customize ) {
        $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
        $wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
        $wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
    }
    
    /**
     * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
     */
    public static function udetor_customize_preview_js() {        
        wp_enqueue_script( 'udetor_customizer', Udetor_Assets::get_js_url() . 'admin/customizer.js', array( 'customize-preview' ), Udetor_Core::VERSION, true );
    }

    /**
     * Binds style into Customizer
    */
    public static function udetor_enqueue_customizer_stylesheet() {

        wp_register_style( 'udetor_customizer', Udetor_Assets::get_css_url() . 'admin/customizer.css', NULL, NULL, 'all' );
        wp_enqueue_style( 'udetor_customizer' );

    }

    public static function select_contact_form7_page(){
        $cf7 = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' );

        $contact_forms = array();
        if ( $cf7 ) {
            foreach ( $cf7 as $cform ) {
                $contact_forms[ $cform->ID ] = $cform->post_title;
            }
        } else {
            $contact_forms[ esc_html__( 'No contact forms found', 'udetor' ) ] = 0;
        }
        return $contact_forms;
    }

    public static function remove_default_customize_register($wp_customize) {
        $wp_customize->remove_section( 'colors' );
        $wp_customize->remove_section( 'static_front_page' );
        $wp_customize->remove_section( 'header_image' );
        $wp_customize->remove_section( 'background_image' );        
        
    }    

}