<?php
/**
 * Add control Controls
 */

function register_sidebar_dropdown_control( $wp_customize ) {

    class Kirki_Controls_Sidebar_Dropdown extends WP_Customize_Control{
    public $type = 'sidebar-dropdown';
    public function render_content(){
    ?>
        <label class="customize_dropdown_input">
            <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
            <p><?php echo wp_kses_post($this->description); ?></p>
            <?php
            global $wp_registered_sidebars;
             ?>
            <select id="<?php echo esc_attr($this->id); ?>" name="<?php echo esc_attr($this->id); ?>" data-customize-setting-link="<?php echo esc_attr($this->id); ?>">
            <option value="0">--Select Sidebar--</option>
            <?php
            $sidebar_shop = $wp_registered_sidebars;
            
            if(is_array($sidebar_shop) && !empty($sidebar_shop)){
                foreach($sidebar_shop as $sidebar){
                    echo '<option value="'.$sidebar['id'].'" ' . selected( $this->value(), $sidebar['name'], false ) . '>'.$sidebar['name'].'</option>';
                }
            }
            ?>
            </select>
            <br>
        </label>
    <?php
    }
}

}
add_action( 'customize_register', 'register_sidebar_dropdown_control' );

/**
 * Register our custom control with Kirki
 */
function sidebar_dropdown_controls( $controls ) {
    $controls['sidebar-dropdown'] = 'Kirki_Controls_Sidebar_Dropdown';
    return $controls;
}
add_action( 'kirki/control_types', 'sidebar_dropdown_controls' );

?>