<?php
/**
 * Add control Controls
 */

function register_pages_dropdown_control( $wp_customize ) {

    class Kirki_Controls_Pages_Dropdown extends WP_Customize_Control{

        public $type = 'pages-dropdown';
        public function render_content(){
            $latest = new WP_Query( array(
            'post_type'   => 'page',
            'post_status' => 'publish',
            'orderby'     => 'date',
            'order'       => 'DESC'
            )); ?>
            <label>
                <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
                <select <?php $this->link(); ?>>
                    <?php 
                    while( $latest->have_posts() ) {
                        $latest->the_post();
                        echo "<option " . selected( $this->value(), get_the_ID() ) . " value='" . get_the_ID() . "'>" . the_title( '', '', false ) . "</option>";
                    }
                    ?>
                </select>
            </label>

        <?php
        }
    }

}
add_action( 'customize_register', 'register_pages_dropdown_control' );

/**
 * Register our custom control with Kirki
 */
function lstpages_dropdown_controls( $controls ) {
    $controls['pages-dropdown'] = 'Kirki_Controls_Pages_Dropdown';
    return $controls;
}
add_action( 'kirki/control_types', 'lstpages_dropdown_controls' );

?>