<?php
/**
 * Add control Controls
 */

function register_menu_dropdown_control( $wp_customize ) {

    class Kirki_Controls_Menu_Dropdown extends WP_Customize_Control{
    
        private $menus = false;
        public function __construct($manager, $id, $args = array(), $options = array())
        {
            $this->menus = wp_get_nav_menus($options);
            parent::__construct( $manager, $id, $args );
        }

        public $type = 'menu-dropdown';
        public function render_content(){
            if(!empty($this->menus))
            {                
                ?>
                    <label>
                        <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>                    
                        <select id="<?php echo esc_attr($this->id); ?>" name="<?php echo esc_attr($this->id); ?>" data-customize-setting-link="<?php echo esc_attr($this->id); ?>">
                        <option value="0">--Select Sidebar--</option>
                        <?php
                            foreach ( $this->menus as $menu )
                            {
                                echo "<option " . selected( $this->value(), $menu->slug) . " value='" . $menu->slug . "'>" . $menu->name . "</option>";
                            }
                        ?>
                        </select>
                    </label>
                <?php
            }
        
        }
    }

}
add_action( 'customize_register', 'register_menu_dropdown_control' );

/**
 * Register our custom control with Kirki
 */
function menu_dropdown_controls( $controls ) {
    $controls['menu-dropdown'] = 'Kirki_Controls_Menu_Dropdown';
    return $controls;
}
add_action( 'kirki/control_types', 'menu_dropdown_controls' );

?>