<?php
/**
 * Add Button Controls
 */

function register_goto_button_control( $wp_customize ) {

    /**
     * The custom control class
     */
    class Kirki_Controls_GotoSection_Control extends WP_Customize_Control {
        public $type = 'goto-section';

        public function render_content() { ?>
            <div class="btn-goto-section">
                <?php if ( ! empty( $this->description ) ) : ?>
                    <span class="description goto-section-control-description"><?php echo esc_attr($this->description); ?></span>
                <?php endif; ?>
                <a class="button button-secondary goto-section" id="<?php echo esc_attr($this->id) . '-' . $this->type; ?>" data-section="<?php echo esc_attr($this->choices[0]); ?>" ><?php echo esc_attr($this->label); ?></a>
            </div>
            <?php $this->value(); ?>
            <?php
        }
    }

}
add_action( 'customize_register', 'register_goto_button_control' );

/**
 * Register our custom control with Kirki
 */
function goto_section_controls( $controls ) {
    $controls['goto-section'] = 'Kirki_Controls_GotoSection_Control';
    return $controls;
}
add_action( 'kirki/control_types', 'goto_section_controls' );

?>