<?php
/**
 * Add Button Controls
 */

function register_goto_panel_control( $wp_customize ) {

    /**
     * The custom control class
     */
    class Kirki_Controls_GotoPanel_Control extends WP_Customize_Control {
        public $type = 'goto-panel';

        public function render_content() { ?>
            <div class="btn-goto-panel">
                <?php if ( ! empty( $this->description ) ) : ?>
                    <span class="description goto-panel-control-description"><?php echo esc_attr($this->description); ?></span>
                <?php endif; ?>
                <a class="button button-secondary goto-panel" id="<?php echo esc_attr($this->id) . '-' . $this->type; ?>" data-panel="<?php echo esc_attr($this->choices[0]); ?>" ><?php echo esc_attr($this->label); ?></a>
            </div>
            <?php $this->value(); ?>
            <?php
        }
    }

}
add_action( 'customize_register', 'register_goto_panel_control' );

/**
 * Register our custom control with Kirki
 */
function goto_panel_controls( $controls ) {
    $controls['goto-panel'] = 'Kirki_Controls_GotoPanel_Control';
    return $controls;
}
add_action( 'kirki/control_types', 'goto_panel_controls' );

?>