<?php
/**
 * Add control Controls
 */

function register_goto_control( $wp_customize ) {

    /**
     * The custom control class
     */
    class Kirki_Controls_Goto_Control extends WP_Customize_Control {
        public $type = 'goto-control';

        public function render_content() { ?>
            <div class="btn-goto-control">
                <?php if ( ! empty( $this->description ) ) : ?>
                    <span class="description goto-control-description"><?php echo esc_attr($this->description); ?></span>
                <?php endif; ?>
                <a class="button button-secondary goto-control" id="<?php echo esc_attr($this->id) . '-' . $this->type; ?>" data-control="<?php echo esc_attr($this->choices[0]); ?>" ><?php echo esc_attr($this->label); ?></a>
            </div>
            <?php $this->value(); ?>
            <?php
        }
    }

}
add_action( 'customize_register', 'register_goto_control' );

/**
 * Register our custom control with Kirki
 */
function goto_controls( $controls ) {
    $controls['goto-control'] = 'Kirki_Controls_Goto_Control';
    return $controls;
}
add_action( 'kirki/control_types', 'goto_controls' );

?>