<?php
/**
 * Add control Controls
 */

function register_custom_typography( $wp_customize ) {    

    /**
     * The custom control class
     */
    class Kirki_Controls_Custom_Typography extends WP_Customize_Control {
        public $type = 'custom-typography';
        public $dependency;
        public function enqueue()
        {
            static $enqueued;            
            if( !isset($enqueued) ) {
               
                wp_enqueue_script(
                    'nb-customize-typography',
                    get_parent_theme_file_uri() . '/assets/udetor/js/admin/typography.js',
                    array('jquery'),
                    '1.6.2',
                    true
                );
                wp_localize_script('nb-customize-typography', 'nbUpload', array(
                    'form_heading' => esc_html__('Select Font', 'udetor'),
                    'button' => esc_html__('Select', 'udetor'),
                    'error_message' => esc_html__('Please choose only ONE font', 'udetor'),    
                ));

                $enqueued = true;
            }

        }        

        public function render_content() { 

            $font_args = !is_array( $this->value() ) ? explode( ',', $this->value() ) : $this->value();
            
            $standard_fonts = array(
                    'Verdana', 'Georgia', 'Courier New', 'Arial', 'Tahoma', 'Trebuchet MS'
            );
            ?>
            <div class="customize-control-content customize-control-typography" id="nb-<?php echo esc_attr($this->type)?>-<?php echo esc_attr($this->id)?>">
            <?php if( !empty($this->label) ): ?>
            <span class="customize-control-title">
                <?php echo esc_html($this->label); ?>
            </span>
            <?php endif;
            if( !empty($this->description) ): ?>
            <span class="description customize-control-description">
                <?php echo esc_html($this->description); ?>
            </span>
            <?php endif; ?>
            <div class="nb-select-type-wrap">
                <select name="select-font-type" class="nb-select">
                    <option value="google" <?php selected($font_args[0], 'google'); ?>><?php esc_html_e('Google fonts', 'udetor'); ?></option>
                    <option value="custom" <?php selected($font_args[0], 'custom'); ?>><?php esc_html_e('Custom fonts', 'udetor'); ?></option>
                    
                </select>
            </div>
            
            <div class="nb-custom-fonts">
                <button type="button" class="button upload-font"><?php esc_html_e('Select fonts', 'udetor'); ?></button>
                <p class="custom-font-message">
                    <span class="custom-font-info"><?php esc_html_e('Info:', 'udetor'); ?></span>
                </p>
            </div>
            
            <input class="font-holder" type="hidden" <?php $this->link(); ?> value="<?php echo esc_attr( implode( ',', $font_args ) ); ?>" data-dependency="<?php echo esc_attr($this->dependency); ?>"/>
        </div>
            <?php
        }
    }

}
add_action( 'customize_register', 'register_custom_typography' );


function upload_mimes($t){
    // Add supported font extensions and MIME types.
    $t['eot'] = 'application/vnd.ms-fontobject';
    $t['otf'] = 'application/x-font-opentype';
    $t['ttf'] = 'application/x-font-ttf';
    $t['woff'] = 'application/font-woff';
    $t['woff2'] = 'application/font-woff2';

            return $t;
        }
add_filter('upload_mimes',  'upload_mimes');

/**
 * Register our custom control with Kirki
 */
function custom_typography_controls( $controls ) {
    $controls['custom-typography'] = 'Kirki_Controls_Custom_Typography';
    return $controls;
}
add_action( 'kirki/control_types', 'custom_typography_controls' );

?>