<?php
/**
 * @version    1.0
 * @package    Udetor
 * @author     Netbase Team <support@netbaseteam.com>
 * @copyright  Copyright (C) 2014 Netbase.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 */

/**
 * Sample implementation of the Custom Header feature
 *
 * You can add an optional custom header image to header.php like so ...
 *
<?php the_header_image_tag(); ?>
 *
 * @link https://developer.wordpress.org/themes/functionality/custom-headers/
 *
 * @package  Udetor
 * @since    1.0
 */
class Udetor_Custom_Header {
    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;
    
    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize() {
        // Do nothing if start functions already initialized.
        if ( self::$initialized ) {
            return;
        }
        
        // Register actions to do something.
        add_action( 'after_setup_theme', array( __CLASS__, 'udetor_custom_header_setup') );
        
        
        // State that initialization completed.
        self::$initialized = true;
    }
    
    /**
     * Set up the WordPress core custom header feature.
     *
     * @uses udetor_header_style()
     */
    public static function udetor_custom_header_setup() {
        add_theme_support( 'custom-header', apply_filters( 'udetor_custom_header_args', array(
            'default-image'          => '',
            'default-text-color'     => '000000',
            'width'                  => 1000,
            'height'                 => 250,
            'flex-height'            => true,
            'wp-head-callback'       => array(__CLASS__, 'udetor_header_style'),
            0
        ) ) );
    }
    
    /**
     * Styles the header image and text displayed on the blog.
     *
     * @see udetor_custom_header_setup().
     */
    
    public static function udetor_header_style() {
        $header_text_color = get_header_textcolor();
        
        /*
         * If no custom options for text are set, let's bail.
         * get_header_textcolor() options: Any hex value, 'blank' to hide text. Default: add_theme_support( 'custom-header' ).
         */
        if ( get_theme_support( 'custom-header', 'default-text-color' ) === $header_text_color ) {
            return;
        }
        ?>
        <style type="text/css">
            <?php
                // Has the text been hidden?
                if ( ! display_header_text() ) :
            ?>
            .site-title,
            .site-description {
                position: absolute;
                clip: rect(1px, 1px, 1px, 1px);
            }
            <?php
                // If the user has set a custom color for the text use that.
                else :
            ?>
            .site-title a,
            .site-description {
                color: #<?php echo esc_attr( $header_text_color ); ?>;
            }
            <?php endif; ?>
        </style>
        <?php
    }
}