<?php
/**
 * @version    1.0
 * @package    Udetor
 * @author     Your Team <support@yourdomain.com>
 * @copyright  Copyright (C) 2014 yourdomain.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 */
class Udetor_Content {
    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;
    
    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize() {
        // Do nothing if start functions already initialized.
        if (self::$initialized) {
            return;
        }
              
        // State that initialization completed.
        self::$initialized = true;
    }

    public static function udetor_get_related($id,$post_type){
        global $post;

        $relateds = get_posts(array(
                'post_type' => $post_type,                
                'category__in' => wp_get_post_categories($id),
                'numberposts' => 4,
                'post__not_in' => array($id))
            );
        echo '<div class="related-course">';
            echo '<div class="headline-container text-center">';
                echo '<h4 class="headline font-h1">'.esc_html__('RELATED COURSE', 'udetor').'</h4>';
                echo '<h5 class="sub-headline">'. get_theme_mod('udetor_courses_detail_related_txt_heading', 'We have different educations that you can be interested in' ) .'</h5>';
            echo '</div>';
            echo '<div class="row">';

            foreach ( $relateds as $post ) :
            setup_postdata( $post ); 
                get_template_part( 'learndash/course_list_template');
            
            endforeach;
            echo '</div>';
        echo '</div>';

    }

    public static function udetor_get_related_post($id){

        global $relatedcatargs, $relatedargs;
        
        if(get_theme_mod('udetor_blog_single_numbers_related_post')){
            $limit_post= get_theme_mod('udetor_blog_single_numbers_related_post');
        }else{
            $limit_post=3;
        }        

        $rel_tagnames = '';
        $rel_catnames = '';
        
        $rel_tags = get_the_tags($id);

        if ($rel_tags) {
            // Get list of tag names and set arguments for loop
            foreach($rel_tags as $rel_tag) {
                $rel_tagnames .= $rel_tag->slug . ',';
            }
            $relatedargs = array(
                'ignore_sticky_posts' => 1,
                'tag' => $rel_tagnames,
                'post__not_in' => array($id),
                'showposts' => $limit_post,
                'orderby' => 'rand'
            );
        }

        // Get list of category names and set arguments for loop
        $post_cats = wp_get_post_categories($id);

        $relatedcatargs = array(
            'ignore_sticky_posts' => 1,
            'category__in' => $post_cats,
            'post__not_in' => array($id),
            'showposts' => $limit_post,
            'orderby' => 'rand'
        );
        
        $my_query = new WP_Query($relatedargs);

        // If no related posts by tag, query by category
        if ( !($my_query->have_posts()) ) {
            wp_reset_postdata(); $my_query = new WP_Query($relatedcatargs);
        }

        //If there are posts
        if( $my_query->have_posts()) { ?>
            <!-- Related Posts -->
            <div class="relatedposts row">
                <h3 class="related-articles-title"><?php esc_html_e('You May Also Like', 'udetor'); ?></h3>
                <div class="carousel-wap owl-carousel owl-theme udetor-related">
                <?php while ($my_query->have_posts()) : $my_query->the_post(); ?>
                    <div class="related-item">
                            <?php
                            if(has_post_thumbnail()):
                                echo '<div class="post-thumbnail">';
                                ?>
                                <a href="<?php the_permalink(); ?>">
                                <?php
                                the_post_thumbnail('udetor-blog-thumb');
                                echo '</a>';
                                echo '</div>';
                            else:
                                ?>
                                <a href="<?php the_permalink(); ?>">
                                <?php
                                echo '<div class="post-thumbnail-placeholder"></div>';
                                ?>
                                </a>
                                <?php
                            endif; ?>
                            <div class="udetor-blog-info text-center">
                                <div class="entry-meta post-meta heading3">
                                    <?php Udetor_Template_Tags::udetor_posted_meta(); ?>
                                </div>
                                <h4 class="relatedposts-title"><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h4>
                                <a href="<?php the_permalink(); ?>" class="read-more btn"><span><?php echo esc_html__('Read more','udetor'); ?></span></a>
                            </div>
                        
                    </div>
                <?php endwhile;  ?>
                </div>
                <div class="clear"></div>
            </div>
        <?php } wp_reset_postdata(); 
    }
    
    public static function udetor_get_certificate_detail($postid, $sizeimg = 'full'){
        ob_start(); 
        $args = array(
        // Arguments for your query.
            'post_type' => 'sfwd-certificates',
            'p' => $postid,
            'post_status'    => 'publish',
        );
         
        // Custom query.
        $query = new WP_Query( $args );        
        // Check that we have query results.
        if ( $query->have_posts() ) {
            echo '<div class="udetor-certificate row">';
            // Start looping over the query results.
            while ( $query->have_posts() ) {         
                $query->the_post();

                // Contents of the queried post results go here.
                if(has_post_thumbnail()):
                    echo '<div class="col-md-7 col-sp-12">';                    
                            the_post_thumbnail($sizeimg);                    
                    echo '</div>';
                    echo '<div class="col-md-5 col-sp-12">';
                else:
                    echo '<div class="col-md-12 col-sp-12">';
                
                endif;
                
                    echo '<span class="heading-certificate">' . esc_html__('Type:', 'udetor') .'</span>';
                    echo '<h3>' . get_the_title() . '</h3>';
                    echo '<span class="heading-certificate">' . esc_html__('Description:', 'udetor').'</span>';
                    echo '<div class="des-certificate">';
                        the_content();
                    echo '</div>';

                echo '</div>';
         
            }
            echo '</div>';
        }        
        
        wp_reset_postdata(); 
        $certificate = ob_get_contents();
        ob_end_clean();
        
        return $certificate;       
         
    }
    public static function udetor_espresso_list_of_event_dates( $EVT_ID = 0, $date_format = '', $time_format = '', $echo = TRUE, $show_expired = NULL, $format = TRUE, $add_breaks = TRUE, $limit = NULL ) {

        $date_format = ! empty( $date_format ) ? $date_format : get_option( 'date_format' );
        $time_format = ! empty( $time_format ) ? $time_format : get_option( 'time_format' );
        $date_format = apply_filters( 'FHEE__espresso_list_of_event_dates__date_format', $date_format );
        $time_format = apply_filters( 'FHEE__espresso_list_of_event_dates__time_format', $time_format );
        $datetimes = EEH_Event_View::get_all_date_obj( $EVT_ID, $show_expired, FALSE, $limit );
        if ( ! $format ) {
            return apply_filters( 'FHEE__espresso_list_of_event_dates__datetimes', $datetimes );
        }
        
        if ( is_array( $datetimes ) && ! empty( $datetimes )) {
            global $post;

            $html = $format ? '<div id="ee-event-datetimes-ul-' . $post->ID . '" class="udetor-event-meta ee-clearfix">' : '';
            foreach ( $datetimes as $datetime ) {                
                if ( $datetime instanceof EE_Datetime ) {                     
                    $start = str_replace( ' ', '&nbsp;', $datetime->get_i18n_datetime( 'DTT_EVT_start', 'j|F, Y' ) );                    
                    $datestart=explode("|",$start);

                    if(count($datestart)== 2){
                        $html .='<div class="left-meta-event">'.$datestart[0].'</div>';
                        $html .='<div class="right-meta-event">';
                        $html .= '<div class="udetor-date-event">'.$datestart[1].'</div>';
                    }
                   
                    $datetime_name = $datetime->name();
                    $html .= ! empty( $datetime_name ) ? '<strong>' . $datetime_name . '</strong>' : '';
                    $html .= ! empty( $datetime_name )  && $add_breaks ? '<br />' : '';
                    
                    $html .= '<div class="udetor-event-timerange">' . $datetime->time_range( $time_format ) . '</div>';
                    
                    $html .= '<div class="lst-venue">';
                    $html .= espresso_venue_address( 'inline',0, false );
                    
                    $html .= '</div>';
                    
                    if(count($datestart)== 2){
                            $html .='</div>'; 
                    }
                }
            }
            
            $html .= $format ? '</div>' : '';
        } else {
            $html = $format ?  '<p><span class="dashicons dashicons-marker pink-text"></span>' . esc_html__( 'There are no upcoming dates for this event.', 'udetor' ) . '</p><br/>' : '';
        }
        
        return $html;
    }
    

    public static function udetor_espresso_event_dates_detail( $EVT_ID = 0, $date_format = '', $time_format = '', $echo = TRUE, $show_expired = NULL, $format = TRUE, $add_breaks = TRUE, $limit = NULL ) {

        $date_format = ! empty( $date_format ) ? $date_format : get_option( 'date_format' );
        $time_format = ! empty( $time_format ) ? $time_format : get_option( 'time_format' );
        $date_format = apply_filters( 'FHEE__espresso_list_of_event_dates__date_format', $date_format );
        $time_format = apply_filters( 'FHEE__espresso_list_of_event_dates__time_format', $time_format );
        $datetimes = EEH_Event_View::get_all_date_obj( $EVT_ID, $show_expired, FALSE, $limit );
        if ( ! $format ) {
            return apply_filters( 'FHEE__espresso_list_of_event_dates__datetimes', $datetimes );
        }
        
        if ( is_array( $datetimes ) && ! empty( $datetimes )) {
            global $post;

            $html = $format ? '<div class="udetor-sidebar-datetimes ee-clearfix">' : '';
            foreach ( $datetimes as $datetime ) {
                
                if ( $datetime instanceof EE_Datetime ) {
                     
                    $timestart = str_replace( ' ', '&nbsp;', $datetime->get_i18n_datetime( 'DTT_EVT_start', 'l, F j, Y @g:i a' ) );
                    $timeend = str_replace( ' ', '&nbsp;', $datetime->get_i18n_datetime( 'DTT_EVT_end', 'l, F j, Y @g:i a' ) );
                   
                    $datestart = explode("@",$timestart);
                    $datesend  = explode('@', $timeend);                    
                    
                    if(count($datestart)== 2){
                    $html .='<div class="datetimes-wap"><h3 class="starttime-icon">'. esc_html__( 'Start time', 'udetor' ).'</h3>';
                    $html .= '<span>'.$datestart[1].'</span>';
                    $html .= '<span>'.$datestart[0].'</span>';
                    $html .= '</div>';
                    }
                    
                    if(count($datesend)== 2){
                    $html .='<div class="datetimes-wap"><h3 class="endtime-icon">'. esc_html__( 'Finish time', 'udetor' ).'</h3>';
                    $html .= '<span>'.$datesend[1].'</span>';
                    $html .= '<span>'.$datesend[0].'</span>';
                    $html .= '</div>';
                    }                    
                }
            }
            
            $html .= $format ? '</div>' : '';
        } else {
            $html = $format ?  '<p><span class="dashicons dashicons-marker pink-text"></span>' . esc_html__( 'There are no upcoming dates for this event.', 'udetor' ) . '</p>' : '';
        }
        
        return $html;
    }

}