<?php
/**
 * @version    1.0
 * @package    Udetor
 * @author     Netbase Team <support@netbaseteam.com>
 * @copyright  Copyright (C) 2014 Netbase.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 */

class Udetor_Content_Width {
    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;
    
    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize() {
        // Do nothing if start functions already initialized.
        if ( self::$initialized ) {
            return;
        }
        
        // Register actions to do something.
        add_action( 'after_setup_theme'   , array( __CLASS__, 'set_content_width' ), 0 );
        
        // State that initialization completed.
        self::$initialized = true;
    }
    
    /**
     * Set the content width in pixels, based on the theme's design and stylesheet.
     *
     * Priority 0 to make it available to lower priority callbacks.
     *
     * @global int $content_width
     * @return void
     */
    public static function set_content_width() {
        $GLOBALS['content_width'] = apply_filters( 'udetor_content_width', 640 );
    }
}