<?php
/**
 * @version    1.1
 * @package    Udetor
 * @author     Netbase Team <support@netbaseteam.com>
 * @copyright  Copyright (C) 2014 Netbase.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 */
class Udetor_Assets {
	/**
	 * Variable to hold the initialization state.
	 *
	 * @var  boolean
	 */
	protected static $initialized = false;

	/**
	 * Initialize functions.
	 *
	 * @return  void
	 */
	public static function initialize() {
		// Do nothing if start functions already initialized.
		if ( self::$initialized ) {
			return;
		}
		// Register actions to do something.
		add_action( 'wp_enqueue_scripts'   , array( __CLASS__, 'udetor_scripts_loader' ));
        add_action( 'wp_enqueue_scripts', array(__CLASS__, 'print_embed_style'), 9999);
        add_action( 'admin_enqueue_scripts', array( __CLASS__, 'udetor_admin_enqueue_scripts' ), 5 );  

        add_action( 'wp_print_styles', array( __CLASS__, 'udetor_deregister_styles' ), 100 );
		
        add_filter( 'FHEE__EE_Front_Controller__display_errors', array( __CLASS__, 'udetor_ee_remove_notices_from_front_page' ) );
        // State that initialization completed.
		self::$initialized = true;
	}

    /*check plugins*/
    public static function udetor_ee_remove_notices_from_front_page($display_errors) {        
        if(get_post_type()!='espresso_events'){
            $display_errors = false;
        }        
        return $display_errors;
    }
    
    public static function udetor_deregister_styles() {
        wp_deregister_style( 'yith-wcwl-font-awesome' );
    }

	/**
     * Get options from Customizer and mix to CSS
     */
    
    public static function get_embed_style()
    {
        global $post, $woocommerce;
        $page_id = get_the_ID();

        $custom_bg_footer_image_url = $custom_bg_page_image_url= $custom_bg_image_page_title_url = $page_header_trans ='';
        if ( $page_id ) {
            $custom_bg_image_page_title = get_post_meta( $page_id, 'custom_bg_image_page_title',true);
            $page_header_trans = get_post_meta($page_id,'custom_page_header_trans', true);    

            if ($custom_bg_image_page_title) {
                $custom_bg_image_page_title_url = wp_get_attachment_image_url ($custom_bg_image_page_title,'full');
            
            }
            $custom_bg_page_image = get_post_meta( $page_id, 'custom_bg_page_image',true);

            if ($custom_bg_page_image) {
                $custom_bg_page_image_url = wp_get_attachment_image_url ($custom_bg_page_image,'full');
            }

            $custom_bg_footer_image = get_post_meta( $page_id, 'custom_bg_footer_image',true);

            if ($custom_bg_footer_image) {
                $custom_bg_footer_image_url = wp_get_attachment_image_url ($custom_bg_footer_image,'full');
            }            
        }

        $udetor_layout_frame_width = get_theme_mod('udetor_layout_frame_width');
        $udetor_layout_bgimage = get_theme_mod('udetor_layout_bgimage');
        $udetor_layout_bgtype = get_theme_mod('udetor_layout_bgtype');

        $udetor_button_left_right= get_theme_mod('udetor_button_left_right');
        $udetor_button_top_bottom = get_theme_mod('udetor_button_top_bottom');
        $udetor_pages_404_bg_img= get_theme_mod('udetor_pages_404_bg_img');

        $udetor_courses_detail_headerbg_img = get_theme_mod( 'udetor_courses_detail_headerbg_img', '' ); 

        $udetor_body_font_type = explode(",",get_theme_mod('udetor_body_font_type','' ));
        $udetor_heading_font_type = explode(",", get_theme_mod('udetor_heading_font_type','' ) );
        $udetor_heading_font_type_2 = explode(",",get_theme_mod('udetor_heading_font_type_2','' ));
        
        $udetor_css_animation_type = get_theme_mod( 'udetor_css_animation_type', '1' );
        $udetor_css_icon_color = get_theme_mod( 'udetor_css_icon_color', '#1ba590' );

        $udetor_color_pagetitle_bg_img = get_theme_mod( 'udetor_color_pagetitle_bg_img', '' );
        $udetor_courses_item_hover_effect = get_theme_mod( 'udetor_courses_item_hover_effect','1');
        $udetor_event_list_head_img= get_theme_mod( 'udetor_event_list_head_img',''  );
        $udetor_color_footer_bg_img = get_theme_mod('udetor_color_footer_bg_img','');
        $udetor_layout_content_width = get_theme_mod('udetor_layout_content_width','1140');

        $woo_headerbg_img = get_theme_mod( 'udetor_woo_general_headerbg_img', '' );
        $woo_header_trans = get_theme_mod( 'udetor_woo_general_header_trans', true );
        
        $udetor_color_primary = get_theme_mod( 'udetor_color_primary', '#1ba590' );
        $color_primary_rgb = self::udetor_hexToRgb($udetor_color_primary);
        
        $css = "";

        if($udetor_body_font_type[0] === 'custom') {
            $body_custom_font_url = array_slice($udetor_body_font_type, 1, -1);
            $css .= "
            @font-face {
                font-family: '" . end($udetor_body_font_type) . "';            
            ";

            foreach($body_custom_font_url as $url) {
                $css .= "
                src: url('" . $url . "');
                ";
            }

            $css .= "
            }
            ";
            $css .='
                body {font-family: "'.end($udetor_body_font_type).'" ; } 
            ';
        }

        if($udetor_heading_font_type[0] === 'custom') {
            $h1_custom_font_url = array_slice($udetor_heading_font_type, 1, -1);
            $css .= "
            @font-face {
                font-family: '" . end($udetor_heading_font_type) . "';            
            ";

            foreach($h1_custom_font_url as $url) {
                $css .= "
                src: url('" . $url . "');
                ";
            }

            $css .= "
            }
            ";
            $css .='
                h1,h2,.widget-lst-title,#reply-title, .relatedposts-title,.udetor-event-meta .left-meta-event,.udetor-date-event, .education-event-header .education-event-time-countdown .education-time-countdown>div>span, .sidebar-title, .font-h1, #learndash_lessons a.font-h1, .main-footer .widget_nav_menu ul li a,.dropcap {font-family: "'.end($udetor_heading_font_type).'" ; } 
            ';
        }

        if($udetor_heading_font_type_2[0] === 'custom') {
            $h3_custom_font_url = array_slice($udetor_heading_font_type_2, 1, -1);
            $css .= "
            @font-face {
                font-family: '" . end($udetor_heading_font_type_2) . "';            
            ";

            foreach($h3_custom_font_url as $url) {
                $css .= "
                src: url('" . $url . "');
                ";
            }
            $css .= "
            }
            ";
            $css .='
                h3,h4,h5,h6 {font-family: "'.end($udetor_heading_font_type_2).'" ; } 
            ';
        }

        if($udetor_layout_content_width){
            $css .='
                @media (min-width: 1200px){.site-content,.udetor-page-title .entry-header, .container {width: '.$udetor_layout_content_width.'px; }}
            ';
        }

        if($udetor_courses_detail_headerbg_img){
         $css .='
                .header-page {background-image: url('.esc_url( $udetor_courses_detail_headerbg_img ).'); } 
            ';
        }
        
        if($custom_bg_footer_image_url!=''){
            $css .='
                .main-footer {background-image: url('.esc_url( $custom_bg_footer_image_url ).'); background-size: cover;} 
            ';
            if ( true == get_theme_mod( 'udetor_color_footer_bg_parallax', false ) ) {
                $css .='
                    .main-footer {background-attachment: fixed;background-position: center;} 
                ';
            }
        }
        elseif($udetor_color_footer_bg_img){
         $css .='
                .main-footer {background-image: url('.esc_url( $udetor_color_footer_bg_img ).'); background-size: cover;} 
            ';
            if ( true == get_theme_mod( 'udetor_color_footer_bg_parallax', false ) ) {
                $css .='
                    @media (min-width: 992px){.main-footer {background-attachment: fixed;background-position: center;} }
                ';
            }
        }

        if($udetor_event_list_head_img){
            $css .='
                .udetor-page-title.events-pagetitle {background-image: url('.esc_url( $udetor_event_list_head_img ).'); } 
            ';   
            if(get_post_type()=='espresso_events'){ 
                if ( true == get_theme_mod( 'udetor_event_header_trans', false ) ) :
                    $css .='
                       .udetor-page-title.events-pagetitle {padding-top:130px; } 
                        ';
                endif;
            }
        }
        if($page_header_trans !=''){
            $css .='.udetor-page-title {padding-top:130px; }';
        }

        if($custom_bg_image_page_title_url!=''){
             $css .='
                .udetor-page-title {background-image: url('.esc_url( $custom_bg_image_page_title_url ).'); } 
            ';  
             
        }else{
            if($woo_headerbg_img !='' && ($woocommerce && is_shop() || $woocommerce && is_product() || $woocommerce && is_product_category() || $woocommerce && is_product_tag()
         || $woocommerce && is_account_page() || $woocommerce && is_cart() || $woocommerce && is_checkout())
        ){
                $css .='
                    .udetor-page-title {background-image: url('.esc_url( $woo_headerbg_img ).'); } 
                ';
                if($woo_header_trans == true){
                    $css .='
                    .udetor-page-title {padding-top:130px; } 
                    ';
                }
            }
            elseif($udetor_color_pagetitle_bg_img && get_post_type()!='espresso_events'){
                $css .='
                    .udetor-page-title {background-image: url('.esc_url( $udetor_color_pagetitle_bg_img ).'); } 
                ';
            }            
        } 

        if($custom_bg_page_image_url!=''){
             $css .='
                #page.site {background-image: url('.esc_url( $custom_bg_page_image_url ).'); background-size: cover;} 
            ';
        }

        if($udetor_layout_frame_width){
            $css .='
                @media (min-width: 1200px) { .content-boxed .wrapper.site{width:'.$udetor_layout_frame_width.'px; } } 
            ';
        }
        if($udetor_layout_bgimage && $udetor_layout_bgtype=='img' ){
            $css .='
            .content-boxed{
                background-image: url("'. esc_url( $udetor_layout_bgimage ).'");
            }
            ';
        }
        if($udetor_button_left_right){
            $css .='
                input.search-submit,.btn, button,input[type="submit"],.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce .widget_price_filter .price_slider_amount .button,.udetor-page-cart tbody tr td.actions button,.entry-content .udetor-page-cart tbody tr td.actions .coupon #coupon_code,.btn-wap-update a.btn-continue-shop,.woocommerce button.button:disabled,.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button{ padding-right:'.$udetor_button_left_right.'px; padding-left:'.$udetor_button_left_right.'px;}
            ';
        }
        if($udetor_button_top_bottom){
            $css .='
                input.search-submit,.btn, button,input[type="submit"],.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .udetor-page-cart tbody tr td.actions button,.entry-content .udetor-page-cart tbody tr td.actions .coupon #coupon_code,.btn-wap-update a.btn-continue-shop,.woocommerce .shop_table button.button:disabled,.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button{ padding-top:'.$udetor_button_top_bottom.'px; padding-bottom:'.$udetor_button_top_bottom.'px;}
            ';
        }
        if($udetor_pages_404_bg_img){
            $css .='
            .error-404{
                background-image: url("'. esc_url( $udetor_pages_404_bg_img ).'");
            }
            ';
        }
        if($udetor_courses_item_hover_effect=='2'){
             $css .= '.ld-entry-content .post-thumbnail{position: relative;overflow: hidden;}
                .ld-entry-content .post-thumbnail img {
                    -webkit-transition: all 0.4s ease 0s;
                    -o-transition: all 0.4s ease 0s;
                    transition: all 0.4s ease 0s;
                }
                .ld-entry-content .post-thumbnail:hover img {
                    -webkit-transform: scale(1.08);
                    -ms-transform: scale(1.08);
                    -o-transform: scale(1.08);
                    transform: scale(1.08);
                }
             ';
        }

        if($udetor_css_animation_type=='1'){
            $css .= '
                    .udetor-loader-1 .udetor-loader {
                        width: 40px; height: 40px;
                        -webkit-animation: loader-1 1.2s infinite ease-in-out;
                        animation: loader-1 1.2s infinite ease-in-out;
                        background: ' . esc_attr( $udetor_css_icon_color ) . ';
                        display: inline-block;
                    }                    
                ';
        }
        
        if($udetor_css_animation_type=='2'){
            $css .= '
                .udetor-loader-2 .udetor-loader:after,  .udetor-loader-2 .udetor-loader {
                border-radius: 50%; width: 6em; height: 6em;
                }
                .udetor-loader-2 .udetor-loader{
                    margin: 60px auto; font-size: 10px;
                    position: relative; text-indent: -9999em;
                    border-top: 1.1em solid rgba(255, 255, 255, 0.2);
                    border-right: 1.1em solid rgba(255, 255, 255, 0.2);
                    border-bottom: 1.1em solid rgba(255, 255, 255, 0.2);
                    border-left: 1.1em solid #ffffff;
                    -webkit-transform: translateZ(0);
                    -ms-transform: translateZ(0);
                    transform: translateZ(0);
                    -webkit-animation: load8 1.1s infinite linear;
                    animation: load8 1.1s infinite linear;
                }  
            ';
        }

        if($udetor_css_animation_type=='3'){
            $css .= '               
                .udetor-loader-3 .udetor-loader,
                .udetor-loader-3 .udetor-loader:before,
                .udetor-loader-3 .udetor-loader:after {
                  background: ' . esc_attr( $udetor_css_icon_color ) . ';
                  -webkit-animation: load1 1s infinite ease-in-out;
                  animation: load1 1s infinite ease-in-out;
                  width: 1em; height: 4em;
                }
                .udetor-loader-3 .udetor-loader {
                  color: ' . esc_attr( $udetor_css_icon_color ) . ';
                  text-indent: -9999em; margin: 88px auto;
                  position: relative; font-size: 11px;
                  -webkit-transform: translateZ(0);
                  -ms-transform: translateZ(0);
                  transform: translateZ(0);
                  -webkit-animation-delay: -0.16s;
                  animation-delay: -0.16s;
                }
                .udetor-loader-3 .udetor-loader:before,
                .udetor-loader-3 .udetor-loader:after { position: absolute; top: 0; content: ""; }
                .udetor-loader-3 .udetor-loader:before {
                  left: -1.5em;
                  -webkit-animation-delay: -0.32s;
                  animation-delay: -0.32s;
                }
                .udetor-loader-3 .udetor-loader:after { left: 1.5em; }                  
            ';
        }    

        $css .='
            .post-thumbnail-gallery a.bggallery:before{
                background-color: rgba('.$color_primary_rgb["r"].', '.$color_primary_rgb["g"].', '.$color_primary_rgb["b"].', 0.6);
            }
            ';   
        if(true == get_theme_mod( 'udetor_button_secondary_icon', true )){
            $css .= '.secondary_btn:after{font-family:"FontAwesome"; content:"\f061";margin-left: 10px;font-size: 10px; vertical-align: text-bottom; line-height:21px;}
             ';
        }               

        return $css;
    }

	/**
     * Print Styles in to Head
	*/
	public static function print_embed_style(){
        $style = self::get_embed_style();

        $style = preg_replace('#/\*.*?\*/#s', '', $style);
        $style = preg_replace('/\s*([{}|:;,])\s+/', '$1', $style);
        $style = preg_replace('/\s\s+(.*)/', '$1', $style);

       //TODO Fix this hack? naming z_ to make this css final
        wp_register_style('z_udetor_front_style', false);
        wp_enqueue_style('z_udetor_front_style');
        wp_add_inline_style('z_udetor_front_style', $style);
    }

    /**
     * Default Customizer Values
    */
    public static function udetor_default_options($option){
        $default = array();    
        if (!empty($default[$option])) {
            return $default[$option];
        }
    }      

    /**
     * Enqueue scripts and styles.
     */
    public static function udetor_scripts_loader() {
        
        wp_enqueue_style( 'udetor-tether', self::get_assets_url() . '/vendors/tether/css/tether.min.css' );
        wp_enqueue_style( 'bootstrap', get_parent_theme_file_uri() . '/assets/vendors/bootstrap/bootstrap.min.css' );
        wp_enqueue_style( 'font-awesome', get_parent_theme_file_uri() . '/assets/vendors/font-awesome/font-awesome.min.css' );
        wp_enqueue_style( 'magnific-popup', get_parent_theme_file_uri() . '/assets/vendors/magnific-popup/magnific-popup.css' );
    
        wp_enqueue_style( 'owl-carousel', self::get_css_url() . '/carousel/owl.carousel.css' );
        wp_enqueue_style( 'owl-carousel-theme', self::get_css_url() . '/carousel/owl.theme.default.css' );

        if (is_rtl()) {
           wp_enqueue_style('udetor-style', get_stylesheet_directory_uri() . '/rtl-udetor.css');
           wp_enqueue_style( 'udetor-main-rtl', self::get_css_url() . 'main-rtl.css', array(), null );
           
        }
        else {
           wp_enqueue_style('udetor-style', get_stylesheet_uri());
           wp_enqueue_style( 'udetor-main-style', self::get_css_url() . 'main.css', array(), null );
           wp_enqueue_style( 'udetor-main-update', self::get_css_url() . 'edu-main.css', array(), null );
        }
    
        wp_enqueue_script( 'jquery');
        
        wp_enqueue_script( 'udetor-navigation', self::get_js_url() . 'navigation.js', array(), Udetor_Core::VERSION, true );        
        wp_enqueue_script( 'udetor-skip-link-focus-fix', self::get_js_url() . 'skip-link-focus-fix.js', array(), Udetor_Core::VERSION, true );        
        wp_enqueue_script( 'tether-script', self::get_assets_url() . '/vendors/tether/js/tether.min.js' );
        wp_enqueue_script( 'bootstrap', get_parent_theme_file_uri() . '/assets/vendors/bootstrap/bootstrap.min.js', array('jquery'), Udetor_Core::VERSION, true );
        wp_enqueue_script( 'isotope-script', self::get_js_url() . 'isotope.pkgd.min.js', array('jquery'), Udetor_Core::VERSION, true );
        wp_enqueue_script( 'magnific-popup-script', get_parent_theme_file_uri() . '/assets/vendors/magnific-popup/jquery-magnific-popup.min.js', array('jquery'), Udetor_Core::VERSION, true );
        wp_enqueue_script( 'waypoints', self::get_assets_url() . '/vendors/waypoints.js' );
        wp_enqueue_script( 'countdown', self::get_assets_url() . '/vendors/jquery.countdown.min.js' );

        wp_enqueue_script( 'udetor-main-script', self::get_js_url() . 'main.js', array('jquery'), Udetor_Core::VERSION, true );

        wp_enqueue_script( 'udetor-courses', self::get_js_url() . '/courses.js', array( 'jquery' ), Udetor_Core::VERSION, true );
        $localize_script = array(
            'errorMsg'     => esc_html__( 'Something wrong happened. Please try again.', 'udetor' ),
            'ajaxUrl'      => admin_url( 'admin-ajax.php' ),
            'nonce_course' => wp_create_nonce( 'nonce-courses' ),
        );

        wp_localize_script( 'udetor-courses', 'UdeTor', $localize_script );
        
        wp_localize_script( 'udetor-main-script', 'screenReaderText', array(
        'expand'   => esc_html__( 'expand child menu', 'udetor' ),
        'collapse' => esc_html__( 'collapse child menu', 'udetor' ),
        ) );
    
        wp_enqueue_script( 'owl-carousel', self::get_js_url() . 'owl.carousel.min.js', array('jquery'), Udetor_Core::VERSION, false );
        
        if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
            wp_enqueue_script( 'comment-reply' );
        }
    }

    /**
     * Admin Styles
    */
    public static function udetor_admin_enqueue_scripts() {
        wp_register_style( 'udetor-font-awesome', 'https://use.fontawesome.com/e8cbfd9eca.css', array(), '4.7.0' );
        wp_register_script( 'youtube-api', 'https://www.youtube.com/iframe_api', array() );
        wp_register_script( 'udetor-video-youtube', self::get_js_url() . '/vendors/youtube/youtube.js', array( 'jquery', 'youtube-api' ), Udetor_Core::VERSION );
        wp_enqueue_style( 'udetor-admin', self::get_css_url() . '/admin/admin.css', array(), Udetor_Core::VERSION );

    }
    /**
     * Enquee scripts and styles for Admin
     */

    public static function udetor_customize_preview_js() {
        wp_enqueue_script( 'udetor_custom_admin', self::get_js_url() . 'admin/admin-custom-script.js', array( 'jquery' ), self::VERSION, true );
    }

	/**
     * Get assets URL
	*/
	public static function get_assets_url(){
	    return trailingslashit(get_parent_theme_file_uri()) . 'assets/';
    }
    
    /**
     * Get assets css URL
     */
    public static function get_css_url(){
        return trailingslashit(get_parent_theme_file_uri()) . 'assets/udetor/css/';
    }
    
    /**
     * Get assets js URL
     */
    public static function get_js_url(){
        return trailingslashit(get_parent_theme_file_uri()) . 'assets/udetor/js/';
    }
    
    /**
     * Get assets images URL
     */
    public static function get_images_url(){
        return trailingslashit(get_parent_theme_file_uri()) . 'assets/udetor/images/';
    }

    public static function udetor_hexToRgb($hex, $alpha = false) {
       $hex      = str_replace('#', '', $hex);
       $length   = strlen($hex);
       $rgb['r'] = hexdec($length == 6 ? substr($hex, 0, 2) : ($length == 3 ? str_repeat(substr($hex, 0, 1), 2) : 0));
       $rgb['g'] = hexdec($length == 6 ? substr($hex, 2, 2) : ($length == 3 ? str_repeat(substr($hex, 1, 1), 2) : 0));
       $rgb['b'] = hexdec($length == 6 ? substr($hex, 4, 2) : ($length == 3 ? str_repeat(substr($hex, 2, 1), 2) : 0));
       if ( $alpha ) {
          $rgb['a'] = $alpha;
       }
       return $rgb;
       //return implode(array_keys($rgb)) . '(' . implode(', ', $rgb) . ')';        
    }
}