<?php
/**
 * @version    1.0
 * @package    Udetor
 * @author     Netbase Team <support@netbaseteam.com>
 * @copyright  Copyright (C) 2014 Netbase.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 */

/**
 * Plug additional setup supports.
 *
 * @package  Udetor
 * @since    1.0
 */
class Udetor_After_Setup {
    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;

    protected static $plugins;

    protected static $tgmpa;
    
    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize() {
        // Do nothing if start functions already initialized.
        if ( self::$initialized ) {
            return;
        }

        self::$tgmpa = isset($GLOBALS['tgmpa']) ? $GLOBALS['tgmpa'] : TGM_Plugin_Activation::get_instance();
        add_action('admin_enqueue_scripts', array( __CLASS__, 'admin_scripts_enqueue' ));
        add_action( 'tgmpa_register', array( __CLASS__, 'register_required_plugins' ) );
        add_action('wp_ajax_nbt_install_framework', array( __CLASS__, 'ajax_install_framework' ));
        add_action('wp_ajax_nbt_active_framework', array( __CLASS__, 'ajax_active_framework' ));

        // Register actions to do something.
        add_action( 'after_setup_theme', array( __CLASS__, 'udetor_setup' ) );        
        add_filter('wp_link_pages_args', array( __CLASS__, 'wp_link_pages_args_prevnext_add' ));
       
        // State that initialization completed.
        self::$initialized = true;
    }

    public static function admin_scripts_enqueue()
    {
        global $pagenow;

        // if ('themes.php' === $pagenow) {

        //     if (!get_transient('nbt_first_time_setup')) {
        //         wp_enqueue_script('switch-theme', get_template_directory_uri() . '/assets/src/js/admin/switch-theme.js', array('jquery'), NBT_VER);
        //         wp_enqueue_style('switch-theme', get_template_directory_uri() . '/assets/netbase/css/admin/switch-theme.min.css', array(), NBT_VER);

        //         wp_localize_script('switch-theme', 'nbt', array(
        //             'ajax_url' => admin_url('admin-ajax.php'),
        //             'wp_nonce' => wp_create_nonce('nbt_nonce'),
        //         ));
        //     }
        // }
    }


    /**
     * Add prev and next links to a numbered link list
     */
    public static function wp_link_pages_args_prevnext_add($args)
    {
        global $page, $numpages, $more, $pagenow;

        if (!$args['next_or_number'] == 'next_and_number')
            return $args; # exit early

        $args['next_or_number'] = 'number'; # keep numbering for the main part       


        if (!$more)
            return $args; # exit early

        if($page-1) # there is a previous page
            $args['before'] .=  _wp_link_page($page-1)
                . $args['link_before']. $args['previouspagelink'] . $args['link_after'] . '</a>'
            ;

        if ($page<$numpages) # there is a next page
            $args['after'] =  _wp_link_page($page+1)
                . $args['link_before'] . $args['nextpagelink'] . $args['link_after'] . '</a>'
                . $args['after']
            ;


        return $args;
    }
    
    function remove_core_updates(){
        global $wp_version;return(object) array('last_checked'=> time(),'version_checked'=> $wp_version,);
    }
    
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    public static function udetor_setup() {
        /*
         * Make theme available for translation.
         * Translations can be filed in the /languages/ directory.
         * If you're building a theme based on Y Te Nam Hai, use a find and replace
         * to change 'udetor' to the name of your theme in all the template files.
         */
        load_theme_textdomain( 'udetor', get_parent_theme_file_path() . '/languages' );
        
        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );
        
        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support( 'title-tag' );
        
        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support( 'html5', array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
        ) );
        
        // Set up the WordPress core custom background feature.
        add_theme_support( 'custom-background', apply_filters( 'udetor_custom_background_args', array(
            'default-color' => 'ffffff',
            'default-image' => '',
        ) ) );
        
        // Add theme support for selective refresh for widgets.
        add_theme_support( 'customize-selective-refresh-widgets' );

    }     

    /*tgm*/
    public static function register_required_plugins()
    {
        if(!isset(self::$plugins)) {
            self::$plugins = apply_filters('core_tgmpa_array', array(
                array(
                    'name' => 'Netbase Toolkit',
                    'slug' => 'netbase-toolkit',
                    'required' => true,
                    'version' => '',
                    'source' => get_parent_theme_file_path() . '/inc/plugins/netbase-toolkit.zip',
                ),
            ));
        }

        $config = array(
            'id'           => 'udetor',                 // Unique ID for hashing notices for multiple instances of TGMPA.
            'default_path' => '',                      // Default absolute path to bundled plugins.
            'menu'         => 'tgmpa-install-plugins', // Menu slug.
            'has_notices'  => true,                    // Show admin notices or not.
            'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
            'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
            'is_automatic' => false,                   // Automatically activate plugins after installation or not.
            'message'      => '',                      // Message to output right before the plugins table.
        );

        tgmpa( self::$plugins, $config );
    }

    public static function ajax_install_framework()
    {
        if (!check_ajax_referer('nbt_nonce', 'wpnonce') || empty($_POST['slug'])) {
            exit(0);
        }

        $json = array();
        $tgmpa_url = self::$tgmpa->get_tgmpa_url();

        if($_POST['slug'] === 'install') {
            $json = array(
                'url' => $tgmpa_url,
                'plugin' => array('netbase-toolkit'),
                'tgmpa-page' => self::$tgmpa->menu,
                '_wpnonce' => wp_create_nonce('bulk-plugins'),
                'action' => 'tgmpa-bulk-install',
                'action2' => - 1,
                'message' => esc_html__('Installing', 'udetor'),
            );
        } elseif($_POST['slug'] === 'active') {
            $json = array(
                'url' => $tgmpa_url,
                'plugin' => array('netbase-toolkit'),
                'tgmpa-page' => self::$tgmpa->menu,
                '_wpnonce' => wp_create_nonce('bulk-plugins'),
                'action' => 'tgmpa-bulk-activate',
                'action2' => - 1,
                'message' => esc_html__('Activating', 'udetor'),
            );
        }

        if($json) {
            wp_send_json($json);
        } else {
            wp_send_json(array('done' => 1, 'message' => esc_html__('Success', 'udetor')));
        }

        exit;
    }   

}