<?php
/**
 * @version    1.0
 * @package    Udetor
 * @author     Your Team <support@yourdomain.com>
 * @copyright  Copyright (C) 2014 yourdomain.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 */
class Udetor_AdminSetup
{
    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;

    /**
     * Initialize functions.
     *
     * @return  void
     */
    public static function initialize()
    {
        // Do nothing if start functions already initialized.
        if (self::$initialized) {
            return;
        }

        // Add admin menu
        add_filter('custom_menu_order', array(__CLASS__, 'custom_menu_order')); // Activate custom_menu_order
        add_filter('menu_order', array(__CLASS__, 'custom_menu_order'));

        // State that initialization completed.
        self::$initialized = true;
    }      

    // Reorder Menu
    public static function custom_menu_order($menu_ord)
    {
        if (!$menu_ord) return true;
        $menu_ord= array(
            'index.php',            
            'learndash-lms',
            'espresso_events',
            'pmpro-membershiplevels',
            'edit.php?post_type=page_header',
            'separator1',
            'edit.php',
            'upload.php',
            'edit.php?post_type=page',
            'edit-comments.php',
            'edit.php?post_type=netbase-faq',
            'edit.php?post_type=netbase-gallery',
            'edit.php?post_type=netbase-portfolio',
            'edit.php?post_type=netbase-team',
            'edit.php?post_type=netbase-testimonial',
            'separator2',
            'themes.php',
            'plugins.php',
            'users.php',
            'tools.php',
            'options-general.php',
            'separator-last',
            'learndash-plus-settings',
            'maxmegamenu',            
            'vc-general',
            'uncanny-learnDash-toolkit',
            'mailchimp-for-wp',
            'edit.php?post_type=acf',            
        );

        // return
        return $menu_ord;

    }

}